/*
    This linker script is derived from here: https://raw.githubusercontent.com/MayaPosch/Nodate/master/arch/stm32/
    linker/stm32f0/stm32f042x6.ld

    I have edited it for use with my TinyBasicLike project, using the STM32F407
    KEL  15 Jul 23
*/

/*
    Declare the entry point.  This is usually the reset handler entry point
*/
ENTRY(Reset_Handler)

MEMORY
{
  FLASH (xr)      : ORIGIN = 0x08000000, LENGTH = 2048K
  RAM1 (xrw)      : ORIGIN = 0x20000000, LENGTH = 112K		/* 112K = 0x1c000 */
  RAM2 (xrw)	  : ORIGIN = 0x2001c000, LENGTH = 16K		/*  16K = 0x3f00 */
/*  NOINIT (xrw)	  : ORIGIN = 0x20000000 + 112K - 0x8000, LENGTH = 0x8000	*/
}

_estack = ORIGIN(RAM2) + LENGTH(RAM2);   /* top of stack is last cell of RAM */


/* Generate a link error if heap and stack don't fit into RAM */
/*_Min_Heap_Size = 0x200;  */      /* required amount of heap  */
/*_Min_Stack_Size = 0x400; */      /* required amount of stack */


/* Define output sections */
SECTIONS
{
  /* The startup code goes first into FLASH */
  .isr_vector :
  {
    . = ALIGN(4);
    KEEP(*(.isr_vector)) /* Startup code */
    . = ALIGN(4);
  } >FLASH

  /* The program code and other data goes into FLASH */
  .text :
  {
    . = ALIGN(4);
    *(.text)           /* .text sections (code) */
    *(.text*)          /* .text* sections (code) */
    *(.glue_7)         /* glue arm to thumb code */
    *(.glue_7t)        /* glue thumb to arm code */
    *(.eh_frame)

    KEEP (*(.init))
    KEEP (*(.fini))

    . = ALIGN(4);
    _etext = .;        /* define a global symbols at end of code */
  } >FLASH

  /* Constant data goes into FLASH */
  .rodata :
  {
    . = ALIGN(4);
    *(.rodata)         /* .rodata sections (constants, strings, etc.) */
    *(.rodata*)        /* .rodata* sections (constants, strings, etc.) */
    . = ALIGN(4);
  } >FLASH

  .ARM.extab   : { *(.ARM.extab* .gnu.linkonce.armextab.*) } >FLASH
  .ARM : {
    __exidx_start = .;
    *(.ARM.exidx*)
    __exidx_end = .;
  } >FLASH

  .preinit_array     :
  {
    PROVIDE_HIDDEN (__preinit_array_start = .);
    KEEP (*(.preinit_array*))
    PROVIDE_HIDDEN (__preinit_array_end = .);
  } >FLASH
  .init_array :
  {
    PROVIDE_HIDDEN (__init_array_start = .);
    KEEP (*(SORT(.init_array.*)))
    KEEP (*(.init_array*))
    PROVIDE_HIDDEN (__init_array_end = .);
  } >FLASH
  .fini_array :
  {
    PROVIDE_HIDDEN (__fini_array_start = .);
    KEEP (*(SORT(.fini_array.*)))
    KEEP (*(.fini_array*))
    PROVIDE_HIDDEN (__fini_array_end = .);
  } >FLASH

  /* used by the startup to initialize data */
  _sidata = LOADADDR(.data);

  /* Initialized data sections goes into RAM, load LMA copy after code */
  .data : 
  {
    . = ALIGN(4);
    _sdata = .;        /* create a global symbol at data start */
    *(.data)           /* .data sections */
    *(.data*)          /* .data* sections */

    . = ALIGN(4);
    _edata = .;        /* define a global symbol at data end */
  } >RAM1 AT> FLASH

  
  /* Uninitialized data section */
  . = ALIGN(4);
  .bss (NOLOAD) :
  {
    /* This is used by the startup in order to initialize the .bss secion */
    _sbss = .;         /* define a global symbol at bss start */
    __bss_start__ = _sbss;
    *(.bss)
    *(.bss*)
    *(COMMON)

    . = ALIGN(4);
    _ebss = .;         /* define a global symbol at bss end */
    __bss_end__ = _ebss;
  } >RAM1

  /* User_heap_stack section, used to check that there is enough RAM left */
  ._user_heap_stack :
  {
    . = ALIGN(8);
    PROVIDE ( end = . );
    PROVIDE ( _end = . );
    /* . = . + _Min_Heap_Size;  */
    /* . = . + _Min_Stack_Size;  */
    . = ALIGN(8);
  } >RAM1
	
  
  /* .noinit (NOLOAD): */
  /* {  */
    /* place all symbols in input sections that start with .noinit */
    /* KEEP(*(*.noinit*)) */
  /* } > NOINIT  */


  /* Remove information from the standard libraries */
  /DISCARD/ :
  {
    libc.a ( * )
    libm.a ( * )
    /* libgcc.a ( * ) */
  }

  .ARM.attributes 0 : { *(.ARM.attributes) }
}

