/*
 *  ECM_startup.s		generic startup file for use with ECMs
 *                      (External Code Modules)
 *
 *  This is a generic LPC17xx startup script, suitable for use with
 *  the CodeSourcery Lite gcc toolset.
 *
 *  However, this startup code is not intended to act as a true
 *  starting point following a cold boot.  Instead, this code is
 *  intended to act as gateway to funtions that can be invoked
 *  by other programs.  These function can be invoked by
 *  executing jumps into a collection of jump vectors at the
 *  start of this module.
 *
 *  This code is based on several examples I found on the web, mashed
 *  together to do what I want it to do.  My thanks to the various
 *  authors for their contributions.
 */

	.syntax unified
	.thumb

	.section ".jump_vector_table"
	.global __jump_vector_table

/*
 *  Unlike a traditional startup file, this file is NOT intended to
 *  occupy the vector table area, and in fact has no traditional
 *  vectors or stack pointer initialization value.
 *
 *  Note that ECMs usually use the stack pointer that is passed to them
 *  when a function is invoked from outside; there isn't really any need for
 *  a stack for ECMs.  However, if you decide you want to have an ECM-
 *  specific stack, use a linker script that includes support for it.  Note that
 *  your ECM module will have to modify the stack pointer itself; there
 *  are no provisions for setting up the stack as part of an ECM's make.
 */

/*
 *  This jump vector table provides target jump points for other
 *  programs to "call" modules within this project.
 *
 *  For every entry in this jump vector table, you must provide an
 *  identically named C function in your ECM module.  You do not need
 *  to have a function named main(), though you are free to use that
 *  name if you like.
 */
	.balign 4
__jump_vector_table:
	b	_Private_Initialize		@ special case, need to set up C vars first!
	.balign 4					@ important!  this forces a 4-byte entry for the first label
	b	GetBreakflag
	b	Blinky


/*
 *  Actual code.
 */
	.thumb_func
	.global _Private_Initialize	@ make it visible in the map file
	.global GetBreakflag
	.global Blinky

/*
 *  Control jumps to here when the first entry in the jump table
 *  is invoked.  Unlike other jump table entries, the first entry
 *  performs the housekeeping functions normally done by the C
 *  startup code following reset.
 *
 *  If your calling program does not first invoke this vector,
 *  your variables will NOT be initialized!
 */
 
_Private_Initialize:
	stmdb sp!, {r0-r4}		@ save the critical regs
/*
 *  Clear the BSS section
 */ 
	mov r0, #0
	ldr r1, = _start_bss
	ldr r2, = _end_bss
	cmp	r1, r2
	beq	_done_clear

	sub r2, #1
_clear:
	cmp r1, r2
	str r0, [r1, #0]
	add r1, #4
	blo _clear
_done_clear:


/* 
 *  Copy data from flash initialization area to RAM
 *
 *  The three values seen here are supplied by the linker script
 */
    ldr   r0, =_start_data_flash	/* initial values, found in flash */
    ldr   r1, =_start_data			/* target locations in RAM to write */
    ldr   r2, =_data_size			/* number of bytes to write */

/*
 *  Perform the copy.
 *  Handle the special case where _data_size == 0
 */
    cmp   r2, #0
    beq   done_copy
copy:
    ldrb   r4, [r0], #1
    strb   r4, [r1], #1
    subs   r2, r2, #1
    bne    copy
done_copy:

/*
 *  Done with copy, restore critical regs and jump to initializer in C.
 */
	ldmia sp!, {r0-r4}
	b		Initialize
	





.end
