; ASSEMBLY LANGUAGE LISTING; BY CHRIS CHABRIS; ANTIC MAGAZINE       ORG  $6000 ;These subroutines are all relocatable;Routines to scroll display, callable;from BASIC as follows:;   Q=USR(ADR(SCRP$),OFS) or;   Q=USR(ADR(SCRN$),-OFS);Where: OFS is the offset valueOFS    EQU  $00CB   ;Storage of offset                    ;to scroll displayDL4    EQU  $0604   ;Fourth byte of                    ;display list                    ;(address lobyte)SCRP   PLA          ;This scrolls with                    ;a positive offset                    ;value       PLA       PLA       STA  OFS     ;Keep offset for                    ;later use       LDX  #00     ;In BASIC,                    ;"FOR L=0..."                    ;initialize indexLOOP1  LDA  DL4,X   ;Get lobyte of                    ;LMS address       CLC       ADC  OFS     ;Add the offset       STA  DL4,X   ;And replace with                    ;the new value       BCC  CONT1   ;If no carry,                    ;continue on       INC  DL4+1,X ;Carry set, so                    ;increment hibyteCONT1  INX       INX       INX          ;Add three to the                    ;index register       CPX  #36     ;If X=36, we have                    ;completed all                    ;12 lines       BNE  LOOP1   ;If not, go back                    ;& do the next one       RTS          ;If so, return to                    ;BASICSCRN   PLA          ;This (almost                    ;identical) is for                    ;negative OFS       PLA       PLA       STA  OFS       LDX  #00LOOP2  LDA  DL4,X       SEC          ;These two lines                    ;are different to                    ;allow sub-       SBC  OFS     ;traction of OFS       STA  DL4,X       BCS  CONT2   ;Same for this and                    ;following line       DEC  DL4+1,XCONT2  INX        INX       INX       CPX  #36       BNE  LOOP2       RTS; Routine to load or save data; callable from BASIC as follows:; Q=USR(ADR(DF$),IOCB,CMD,ADDRESS,NUM); Where: IOCB is the Input/Output ; channel being used;  CMD is 7 for READ or 11 for WRITE;  ADDR is the address to take data ;       from or move data to;  NUM is number of bytes to transferCIOV   EQU  $E456   ;Central Input/                    ;Output vectorICCOM  EQU  $0342   ;IOCB #0:                    ; command byteICSTA  EQU  $0343   ; status byteICBAL  EQU  $0344   ; buffer address                    ;    (lo-hi)ICBLL  EQU  $0348   ; buffer length                    ;    (lo-hi)USRARG EQU  $00D4   ;Address of USR                    ;function return                    ;argumentDF     PLA          ;Number of                    ;parameters passed                    ;by BASIC       CMP  #04     ;Is it four as it                    ;should be?       BNE  ERROR   ;If No return with                    ;variable Q=22       PLA          ;Hibyte of IOCB                    ;number - discard       PLA          ;Lobyte of same       ASL  A       ;Multiply it by 16                    ;for ease of use       ASL  A       ASL  A       ASL  A       TAX          ;Save it for later                    ;use in X-register       PLA          ;Hibyte of                    ;command - discard       PLA          ;Lobyte of command       STA  ICCOM,X ;Put it in com-                    ;mand byte of                    ;IOCB #X/16       PLA          ;This is hibyte                    ;of the buffer                    ;address       STA  ICBAL+1,X  ;Into the IOCB                       ;you go!       PLA          ;Lobyte of buffer                    ;address       STA  ICBAL,X ;goes in also       PLA          ;Hibyte of buffer                    ;length       STA  ICBLL+1,X       PLA             ;and lobyte of                       ;same go        STA  ICBLL,X   ;into proper                       ;IOCB,EXEC   JSR  CIOV    ;Now CIO will                    ;perform the I/OCHECK  TYA          ;Get completion                    ;status from                    ;Y-register       STA  USRARG  ;And pass it back                    ;to BASIC       LDA  #00       STA  USRARG+1  ;Zero-out hibyte                      ;just in case       RTS          ;Return to BASIC,                    ;Q=Error numberERROR  TAX          ;Save incorrect                    ;# of arguments                    ;passedLOOP3  PLA          ;and pull them off                    ;the stack one by                    ;one       PLA       DEX       BNE  LOOP3   ;Go do next one                    ;if any left       LDA  #22     ;ERROR- 22                    ;indicates                    ;incorrect # of                    ;args.       STA  USRARG  ;Let BASIC know                    ;about it       LDA  #00       STA  USRARG+1  ;Make sure the                      ;error number                      ;is <256!       RTS          ;BASIC regains                    ;control,                    ;unsatisfied          END                                                                                   