#include <linux/config.h>
#ifdef CONFIG_MODVERSIONS
#define MODVERSIONS
#include <linux/modversions.h>
#endif
#include <linux/module.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,3,0)
#define LINUX_22	1
#define DECLARE_WAITQUEUE(QUEUE,INIT) struct wait_queue QUEUE = {INIT, NULL}
#define wait_queue_head_t struct wait_queue *
#define SILLY_PCI_BASE_ADDRESS(PCIDEV) (PCIDEV->base_address[0] & PCI_BASE_ADDRESS_IO_MASK)
#define SILLY_INIT_SEM(SEM) SEM=MUTEX;
#define init_waitqueue_head init_waitqueue
#define SILLY_MAKE_INIT(FUNC) __initfunc(FUNC)
#else
#define SILLY_PCI_BASE_ADDRESS(PCIDEV) (PCIDEV->resource[0].start)
#define SILLY_INIT_SEM(SEM) init_MUTEX(&SEM)
#define SILLY_MAKE_INIT(FUNC) __init FUNC
#endif

#ifdef LINUX_22
#include <asm/spinlock.h>
/*
 * GFP bitmasks..
 */
#define __GFP_WAIT   0x01
#define __GFP_LOW   0x02
#define __GFP_MED   0x04
#define __GFP_HIGH   0x08
#define __GFP_IO   0x10
#define __GFP_SWAP   0x20

#define __GFP_DMA   0x80

#define GFP_BUFFER   (__GFP_LOW | __GFP_WAIT)
#define GFP_ATOMIC   (__GFP_HIGH)
#define GFP_USER   (__GFP_LOW | __GFP_WAIT | __GFP_IO)
#define GFP_KERNEL   (__GFP_MED | __GFP_WAIT | __GFP_IO)
#define GFP_NFS      (__GFP_HIGH | __GFP_WAIT | __GFP_IO)
#define GFP_KSWAPD   (__GFP_IO | __GFP_SWAP)
#else 
#include <linux/spinlock.h>
#endif

#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/string.h>
#include <linux/ctype.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/delay.h>
#include <linux/sound.h>
#include <linux/malloc.h>
#include <linux/soundcard.h>
#include <linux/pci.h>
#include <linux/init.h>
#include <linux/poll.h>
#include <asm/uaccess.h>
#include <asm/hardirq.h>
#include <asm/io.h>
#include <asm/dma.h>

#include "OS_inc.h"
#include "5530_def.h"

#ifndef DECLARE_WAIT_QUEUE_HEAD
#define DECLARE_WAIT_QUEUE_HEAD(sym)	struct wait_queue * sym = NULL
#endif

#undef	CONFIG_APM   // Disabled APM support

#ifdef CONFIG_APM
#include <linux/apm_bios.h>
static int cx5530_apm_callback(apm_event_t ae);
static int in_suspend=0;
wait_queue_head_t suspend_queue;
static void check_suspend(void);
#define CHECK_SUSPEND check_suspend();
#else
#define CHECK_SUSPEND
#endif

