/**************************************************************************/
/*									  */
/*	T U R B O C  2.0              (Mouse services)	                  */
/*									  */
/*				by T. Gouthas				  */
/**************************************************************************/

#include <dos.h>
#include <stdio.h>
#include <conio.h>

#define INVSCRNMASK 0xFFFF
#define INVCURSMASK 0x7700
#define MOUSE 51
typedef enum ButtonType      { LeftButton,RightButton,MidButton } ButtonType;
typedef enum MouseMode       { Hardware,Software }                MouseMode;
typedef unsigned int             MouseDef[31];
union				 REGS regs;
struct SREGS 			 sregs;
int                              MouseOK = 0;
int                              NoButtons = 2;
int                              MidPressed,RightPressed,LeftPressed;
MouseDef                         Mymouse;
int                              MouseX = 0, MouseY = 0;

void InitMouse()
{
   regs.x.ax = 0;
   int86(MOUSE,&regs,&regs);
   MouseOK = regs.x.ax;
   NoButtons = regs.x.bx;
}

void ShowMouse()
{
   regs.x.ax = 1;
   int86(MOUSE,&regs,&regs);
}

void HideMouse()
{
   regs.x.ax = 2;
   int86(MOUSE,&regs,&regs);
}

void MouseXY()
{
   regs.x.ax = 3;
   int86(MOUSE,&regs,&regs);
   MouseX = regs.x.cx/2;
   MouseY = regs.x.dx;
   LeftPressed =  (regs.x.bx & 1 == 1);
   RightPressed = (regs.x.bx & 2 == 2);
   MidPressed =   (regs.x.bx & 4 == 4);
}

void MouseToXY(int xpos, int ypos)
{
   regs.x.ax = 4;
   regs.x.cx = 2*(MouseX = xpos);
   regs.x.dx = (MouseY = ypos);
   int86(MOUSE,&regs,&regs);
}

int MousePressCount(ButtonType button, int *status)
{
   regs.x.ax = 5;
   regs.x.bx = button;
   int86(MOUSE,&regs,&regs);
   MouseX = regs.x.cx/2;
   MouseY = regs.x.dx;
   *status = regs.x.ax;
   return regs.x.bx;
}

int MouseReleaseCount(ButtonType button, int *status)
{
   regs.x.ax = 6;
   regs.x.bx = button;
   int86(MOUSE,&regs,&regs);
   MouseX = regs.x.cx/2;
   MouseY = regs.x.dx;
   *status = regs.x.ax;
   return regs.x.bx;
}

void MouseXRange(int x1, int x2)
{
   regs.x.ax = 7;
   regs.x.cx = x1*2;
   regs.x.dx = x2*2;
   int86(MOUSE,&regs,&regs);
}

void MouseYRange(int y1, int y2)
{
   regs.x.ax = 8;
   regs.x.cx = y1;
   regs.x.dx = y2;
   int86(MOUSE,&regs,&regs);
}

void DefineGraphMouse(MouseDef mouse, int xhot, int yhot)
{
   regs.x.ax = 9;
   regs.x.bx = xhot;
   regs.x.cx = yhot;
   regs.x.dx = FP_OFF(&mouse);
   sregs.es = FP_SEG(&mouse);
   int86x(MOUSE,&regs,&regs,&sregs);
}

void DefineTextMouse(MouseMode mode, int scrnmask, int cursormask)
{
   regs.x.ax = 10;
   regs.x.bx = mode;
   regs.x.cx = scrnmask;
   regs.x.cx = cursormask;
   int86(MOUSE,&regs,&regs);
}

void ReadMouseMickey(int *Xspeed, int *Yspeed)
{
   regs.x.ax = 11;
   int86(MOUSE,&regs,&regs);
   *Xspeed = regs.x.cx;
   *Yspeed = regs.x.dx;
/*
   if Xspeed > 0 then moving in positive x direction
   if Yspeed > 0 then moving in positive y direction
*/
}




void SetMouseMickey(int Xspeed, int Yspeed)
{
   regs.x.ax = 15;
   regs.x.cx = (unsigned) Xspeed;
   regs.x.dx = (unsigned) Yspeed;
   int86(MOUSE,&regs,&regs);
}

void TextCursorOff()
{
   regs.x.cx = 0x2000;
   regs.x.ax = 0x0100;
   int86(0x10,&regs,&regs);
}

void TextCursorOn()
{
   regs.x.cx = 0x0C0D;
   regs.x.ax = 0x0100;
   int86(0x10,&regs,&regs);
}
