/*
 *  "sound.h" -  Include file for use with Tandy digital sound library
 *		 as of Version 1(10)
 */


typedef unsigned long	u_long;
typedef unsigned int	u_int;
typedef unsigned short	u_short;
typedef unsigned char	u_char;

typedef char far *	saddr;


typedef struct sound {
	saddr		buffer;		/* The sound buffer itself */
	u_long		sndlen;		/* Length of the sound in the buffer */
	u_long		buflen;		/* Length of the buffer itself */
	u_char		rate;		/* Rate the sound was recoreded at */
	u_char		system;		/* Sound source (see defines below) */
	u_long		reserved[4];	/* Reserved for internal use */
} SOUND;

typedef struct sndhdr {
  /* The following items, except "ticket", "reserved1",
     and "reserved2" are to be filled in by the caller */
	SOUND	far	*sndp;		/* The sound structure */
	u_long		start;		/* Where to start playing (0 == ALL) */
	u_long		end;		/* Where to stop playing (0 == end) */
	u_short		ticket;		/* When buffer was/is-to-be played */
	u_char		rate;		/* Rate the sound is to be played at */
	u_char		reserved1;	/* Reserved for internal use */
	u_long		reserved2[4];	/* Also reserved for internal use */
} SNDHDR;

/* Machine sound came from */
#define B_SYNTH	0		/* Sound was synthetically produced */
#define B_MAC	0		/* Sound came from a Macintosh(R) */
#define B_AT8	1		/* Recorded on a 8mhz AT compatible */
#define B_SL	2		/* Sound was recorded on a 1000-SL */
#define B_TL	3		/* Sound was recorded on a 1000-TL */

/* Sampling rate defines */
#define R5500	1		/* 5.5khz sample rate */
#define R11000	2		/* 11khz sample rate */
#define R22000	3		/* 22khz sample rate */

typedef struct versioninfo {		/*Version format: Major[Minor](Edit)*/
	char far *	version;	/*String containing version message
					  that can be displayed via printf()*/
	u_char		major;		/*Major version number*/
	u_char		minor;		/*Minor version number 0=no character,
					  1=A, 2=B, 3=C...*/
	u_short		edit;		/*Edit number*/
	u_short		reserved1;	/*Reserved for future use*/
	u_long		reserved2;	/*Reserved for future use*/
	u_long		reserved3;	/*Reserved for future use*/
} VERSIONINFO;

/* Scratch area for internal use of compress/decompress routines */
typedef struct {
	u_long	scratch[25];		/* Scratch area */
} COMPINFO;


/* Defines for compress "type" parameter */
#define CTYPE_DESKMATE88	0

/* pParam structure for compressing with type=CTYPE_DESKMATE88 */
typedef struct compparam
{
	COMPINFO far *pinfo;	/* compress/decompress work area */
	u_long	start;		/* start position in sound */
	u_long	end;		/* end position in sound  (0 = to the end) */
	u_short	compress_mode;	/* what kind of compression to do */

	/* following parameters used only by  */
	/* compress_mode = DESKMATE88_ADJUSTABLE */

	u_short	threshhold_length; /* minimum length of "silence" */
	u_char	threshhold;	/* amplitude of "silence" */
	u_char	precision;	/* how accurate to make deltas */
} COMPPARAM;

/* Defines for compparam "mode" parameter */
#define DESKMATE88_MUSIC	1	/* music compression */
#define DESKMATE88_SPEECH	2	/* speech compression */
#define DESKMATE88_ADJUSTABLE	3	/* roll-your-own compress mode */

/* defines for snd_cue() "mode" parameter */
#define TOPLAY		1		/* prepare to play */
#define	TORECORD	2		/* prepare to record */

/* defines for snd_init() "options" parameter */
# define FASTRAMP	0x0001		/* fast change between record and play */
/* Misc defines */
#define TRUE	1
#define	FALSE	0
#ifndef NULL
#  define NULL	0
#endif /* NULL */


/* Error codes */
#define BADFMT	-3		/* Decompress called with corrupted data
				   or sound compressed with unsupported
				   algorithm */
#define BADPARM	-2		/* Compress called with bad type or
				   compress_mode */
#define INVALID  -1		/* Call made when driver uninitialized
				   or call not legal at this time */
#define NOERROR	 0
#define INITBUF	 1		/* Insufficient buffers were allocated
				   before snd_init() was called */
#define INIT64K	 2		/* All buffers spanned 64K physical
				   addresses - player cannot initialize */
#define BADDMA	 3		/* DMA Channel requested is invalid */
#define BADIRQ	 4		/* The IRQ number requested is invalid */
#define NOIRON	 5		/* Can't find our hardware */
#define BADSIZE	 6		/* Record buffer is too small or
				   too small for the requested time. */
#define WOULDBLOCK 7		/* snd_record() failed because two buffers are
				   already queued and block was set to FALSE */


/* Compression-precision default defines */
#define SND_PRECIS	1		/* "precision" compression default */
#define SND_SPEECH_THR	12		/* "threshold" speech comp. default */
#define	SND_MUSIC_THR	0		/* "threshold" music comp. default */
#define SND_THRESH_LEN	60		/* "threshold_length" default */


/* Prototypes for routines */
/* __STDC__ is automatically defined for compilers supporting ANSI function */
/* prototypes, and undefined for compilers that don't.  An ANSI and non-ANSI */
/* prototype is given for each function. */

#ifdef __STDC__
 short far snd_addbuf(saddr mem, u_short nr_bufs);
 short far snd_init(u_short trigger, u_short dma_ch, u_short irq, 
	u_short options);
 short far snd_exit(void);
 short far snd_play(SNDHDR far *pSound);
 void far snd_volume(u_short volume);
 short far snd_flush(void);
 short far snd_record(SOUND far *pSound, u_short maxTime, u_short rate,
	u_char far *adj_table, u_short block);
 short far snd_wait(SNDHDR far *pSound, u_short wait);
 void far snd_stop(SNDHDR far *pSound);
 void far snd_amplify(u_short factor, u_char far *output);
 void far snd_apply_func(SOUND far *pSound, 
	u_long start, u_long end,
	u_char far *table);
 long far snd_compress_part(SOUND far *psound, u_char far *dest, 
	u_short dest_size, u_short type, COMPPARAM far *pParam);
 short far snd_decompress_part(SOUND far *psound, COMPINFO far *pinfo, 
	u_char far *src, u_short src_len);
 short far snd_compensate(u_char far * adj_table);
 short far snd_cue(u_short mode);
 VERSIONINFO far * far snd_version(void);
#else /* __STDC__ */
 short far snd_addbuf();
 short far snd_init();
 short far snd_exit();
 short far snd_play();
 void far snd_volume();
 short far snd_flush();
 short far snd_record();
 short far snd_wait();
 void far snd_stop();
 void far snd_amplify();
 void far snd_apply_func();
 long far snd_compress_part();
 short far snd_decompress_part();
 short far snd_compensate();
 short far snd_cue();
 VERSIONINFO far *  far snd_version();
#endif /* __STDC__ */
