# include <stdio.h>
# include <fcntl.h>
# include <stdlib.h>
# include <io.h>
# include "sound.h"
# include "dgetbuf.h"
# include "dsave.h"
# include "csrbase.h"
# include "csrcmps.h"

extern	INFO_STRING IS;
extern	INFO_BOX IB;

/*
 *	This routine takes the sound saved in sound buffers allocated by
 *	set_up_buffers(), compresses it, and writes it to a file.
 *
 *	The file format is unlike anything used by anything else.
 *	The file format is:
 *	Repeat for each SOUND structure:
 *	  A long integer indicating the length of compressed data.
 *	  A long integer indicating the length of the data uncompressed.
 *	  An unsigned char indicating the recording rate.
 *	  An unsigned char indicating the system (machine type).
 *	  The compressed data
 *	Next SOUND structure
 *	A long integer containing 0.
 */
# ifdef __STDC__
void do_compress_and_save(char *filename)
# else
void do_compress_and_save(filename)
# endif
{
	int           	fd;              /* file handle for save file */
	COMPINFO      	Info;            /* compress scratch area */
	COMPPARAM     	Param;           /* compress parameters */
	unsigned char	filebuffer[512]; /* buffer for file writes */
	u_long        	ret;             /* return value from compress */
	u_long        	chunklength;     /* length of compressed data for
    	            	                  this SOUND structure */
	long          	lenpos, endpos;  /* file positions */
	int           	bufno;           /* index for SOUND structures */
	u_char        	rate;            /* speed sound was recorded at */
	u_char        	system;          /* type of machine recording was made on */
	u_long        	uncomplen;       /* uncompressed length of sound */
	char          	msg_buff[90];    /* message build buffer */
	MSGBOX			msg;

	rate = sndheaders[0]->sndp->rate;	/* get rate and system */
	system = sndheaders[0]->sndp->system;

	/* set up the compress parameter data */
	Param.pinfo = &Info;	/* scratch area pointer */
	Param.start = 0;	/* do the entire sound */
	Param.end = 0;
	Param.compress_mode = DESKMATE88_ADJUSTABLE;	/* specify parameters */
	Param.precision = 0;	/* exact sound reproduction */
	Param.threshhold = 0;
	Param.threshhold_length = 0;

	/* open the save file */
	if ( (fd = open(filename, O_WRONLY|O_BINARY|O_CREAT|O_TRUNC, 0666)) < 0)
	{
    	strcpy(msg_buff, "Cannot open sound data file ");
    	strncat(msg_buff, filename, 60);
		bomb_out( &msg );
	}

	msg.pMessage = "Cannot write to the save file, exiting the program.";

	/* for each SOUND structure */
	for (bufno = 0; bufno < numbuffers; bufno++)
	{
		/* if there is no sound recorded, ignore this SOUND */
		if (sndheaders[bufno]->sndp->sndlen == 0)
			continue;

		/* compress the sound */
		ret = snd_compress_part(sndheaders[bufno]->sndp,
			(unsigned char far *) filebuffer,
			(unsigned short) 512,
			CTYPE_DESKMATE88,
			(COMPPARAM far *) &Param);
		chunklength = ret;

		/* get current file position */
		lenpos = lseek(fd, (long) 0, SEEK_CUR);

		/* write the compressed length (currently wrong) */
		if (write(fd, (char *) &chunklength, sizeof(chunklength))
							!= sizeof(chunklength))
      		bomb_out( &msg );

		/* write the uncompressed length */
		uncomplen = sndheaders[bufno]->sndp->sndlen;
		if (write(fd, (char *) &uncomplen,
			sizeof(uncomplen)) != sizeof(uncomplen))
      		bomb_out( &msg );

		/* write the rate */
		if (write(fd, &rate, sizeof(rate))
						!= sizeof(rate))
			bomb_out( &msg );

		/* write the system */
		if (write(fd, (char *) &system, sizeof(system))
			!= sizeof(system))
      		bomb_out( &msg );

		/* write first chunk to file */
		if (write(fd, filebuffer, (unsigned int) ret) !=
			(int) ret)
    		bomb_out( &msg );

		/* process the rest of the data */

		while ((ret = snd_compress_part((SOUND far *) 0,
			(unsigned char far *) filebuffer,
			(unsigned short) 512,
			CTYPE_DESKMATE88,
			(COMPPARAM far *) &Param)) != 0)
		{
			if (write(fd, filebuffer, (unsigned int) ret) !=
				(int) ret)
    		    bomb_out( &msg );
			chunklength += ret;
		}

    	/* get current file position */
		endpos = lseek(fd, (long) 0, SEEK_CUR);
		if (endpos < 0)
		{
			IS.pString = "lseek 1 failed";
			info_draw( &IB );
			wait1000();
		}

		/* seek to where we wrote the (wrong) length */
		if (lseek(fd, lenpos, SEEK_SET) < 0)
		{
			IS.pString = "lseek 2 failed";
			info_draw( &IB );
			wait1000();
		}

    	/* write the correct length */
		sprintf(msg_buff, "Compressed %lu bytes into %lu",
				 sndheaders[bufno]->sndp->sndlen, chunklength);
		IS.pString = msg_buff;
		info_draw( &IB );
		wait1000();

    	if (write(fd, (char *) &chunklength, sizeof(chunklength))
				!= sizeof(chunklength))
      		bomb_out( &msg );

		/* seek back to the end of the file */
		if (lseek(fd, endpos, SEEK_SET) < 0)
		{
			IS.pString = "lseek 3 failed";
			info_draw( &IB );
			wait1000();
		}
	}

	/* write the last-chunk indicator */
	chunklength = 0;
	write(fd, (char *) &chunklength, sizeof(chunklength));

	/* close the file */
	close(fd);
}
