	page	60,132
;-----------------------------------------------------------------------------
;	Stop.asm - snd_stop() and snd_buf_stop() functions for the PSSJ
;		 Digital Sound Toolkit
;	Copyright 1994, Frank Durda IV. 
;	Commercial use is restricted.  See intro(PSSJ) for more information.
;-----------------------------------------------------------------------------
	extrn	_snd_flush:far
	extrn	delhook:near
	extrn	disk_pl_len:dword	;<22>
	extrn	queue_free:dword
	extrn	ld_buf:dword
	extrn	tmp_queue:dword
	extrn	snd_xfer_buf:NEAR
	extrn	snd_cat_chain:NEAR
	extrn	_snd_wait:FAR
	extrn	_snd_clock:word
	extrn	snd_residue:word	;<34>
	extrn	_snd_clock_t:word
	extrn	recoffload:near		;<30>
	extrn	rec_depth:WORD		;<32>
	extrn	nextrec_queue:dword	;<32>
	extrn	snd_rec_offl:near	;<33>
	extrn	snd_disk_wr:near	;<33>
	extrn	compress_hold:dword	;<34>
	extrn	disk_queue_free:dword	;<34>
	extrn	disk_exp_queue:dword	;<34>

DMACLR	equ	000ch			;<30>

	include external.inc

	include sound.inc

snddata	segment public 'DATA'

stpstr	struc
	dw	?
	dw	(@codesize+1) dup (?)
offs	dw	?			;Spell it out and confuse masm
segm	dw	?
stpstr	ends
snddata	ends
	page
sndseg	segment	public	'CODE'
	assume	cs:sndseg
;------------------------------------------------------------------------------
;	Snd_Stop	Stops sound output

;	Snd_stop accepts time parameters which go by different names:
;  1.		offset, segment		;RAM Playback-only, stop when you reach
;					;the buffer containing this sound.
;  2.	or	time,	0		;Stop if the player or recorder
;					;have run this amount of time.
;  3.	or	0,	0		;Stop now.

;	Modes 2 and 3 are handled by the same code since there can never
;	be zero time into a recording or playback.

;	Mode 1 is useful only for snd_play() operation.  When the stop is
;	performed, played and unplayed buffers will be moved back to the
;	free chain.

;	C definition:	extern void snd_stop(SNDHDR far * sp);
;		or	extern void snd_stop(u_short time, u_short ZERO);

;<29>	Replaces original snd_stop at Edit 29, 	19-Feb-90 Frank Durda IV
;------------------------------------------------------------------------------
	page
	public _snd_buf_stop
_snd_buf_stop	proc	far
	jmp	short	_snd_stop	;Common routine

_snd_buf_stop	endp

	public _snd_stop
_snd_stop	proc FAR
	push	bp
	mov	bp,sp
	push	di
	push	si
	push	ds
	push	es
	pushf

	mov	ax,snddata
	mov	ds,ax	;=======================================================
	assume	DS:snddata
	
;	Determine which mode we are in

	mov	ax,[bp].segm		
	or	ax,ax			;Are we in timed mode?
	jz	$istime			;Handle timed mode
	jmp	$nottime		;Handle recognition mode

;	Here we are in a timed mode

$istime:mov	ax,snd_mode		;If we are recording, don't fiddle
	and	ax,RAMPUP OR DISKPLAY OR INPLAY	;<33>Do a flush if not
	cmp	ax,RAMPUP		;<33>using disk ops and player
	jnz	$dontf			;<33>not yet running
					;<33>This could foul things up

	call	_snd_flush		;Kick start the player, just in case

$dontf:	mov	bx,[bp].offs		;Get time value
$clkloop:
	cmp	_snd_clock,bx		;Compare against the clock
	jnc	$timeisup		;It is not yet time to stop
	mov	ax,snd_mode
	test	al,INRECORD OR INPLAY
	jz	$timeisup		;They stopped by themselves
	jmp	$clkloop
	page
;	Here the time has arrived.

$timeisup:
	call	snd_dma_stop		;Turn DMA off
	cli	;--------------------------------------------------------------

;	Now we go though the steps of cleaning up the various devices
;	Clean up pending player buffers

	mov	si,offset queue_play	;Player process buffers
	mov	di,offset queue_free	;Free buffer pool
	call	snd_cat_chain		;Transfer any buffers to free list
					;queue_play will be NULL after call
	xor	ax,ax
	mov	word ptr queue_last,ax	;<34>
	mov	word ptr queue_last[2],ax	;<34>

	mov	si,offset ld_buf
	mov	di,offset queue_free
	call	snd_xfer_buf		;Will do nothing if ld_buf is null
					;ld_buf will be NULL at this point

;	Now turn attention to the recorder

	mov	ax,snd_mode
	test	al,INRECORD
	jnz	$geezintelisdumb
	jmp	$notinrec		;Recorder is not active now
$geezintelisdumb:

;	Here the recorder was doing something when we threw the brakes on

;	First thing we do is salvage data in the circular buffer that
;	has been recorded but not yet transferred to user buffers
;	To do this, we determine where the DMA was when we stopped.

	mov	dx,DMACLR
	mov	al,0ffh
	out	dx,al
	mov	dx,dma_count_port
	in	al,dx
	mov	bl,al
	in	al,dx
	mov	bh,al
	cmp	bx,MERRYGO_SPLIT

	jae	$insafety		;In the safety area

;	In this section, the DMA was working outside the safety area.
;	Therefore, we only copy the data from the start of the
;	safety area to the current DMA position.
;	We know this since the other areas are unloaded when we are
;	not in the safety area.

	mov	dx,MERRYGO_SPLIT	;<30>Size of the safety area
	sub	dx,bx			;<30>Remaining down-count from DMA
	call	recoffload		;<30>Transfer contents of 
					;<30>non-safety area.
	jmp	short $reccom		;<30>


;	Here, the DMA was within the safety area.  It was probably in
;	the first few bytes.  Normally, we enter the ISR shortly after
;	reaching the start of the safety area and wait there until we
;	leave that area (so it can be unloaded).  This means that
;	if the DMA is in this area, the interrupt has not yet been
;	serviced, and the valid data is the entire non-safety
;	area, plus the area to the left (lower addresses) in the safety
;	area.  Got that?  Then you are the only one.

$insafety:
	mov	dx,MERRYGO_SPLIT	;<30>Size of safety area
	call	recoffload		;<30>Transfer entire thing.
	jnz	$reccom			;<30>Ran out of target space

;	Now, we can transfer the tiny bit remaining in the 
;	safety area. WARNING, could be zero, always less than 
;	size of safety area.

;	OR WE COULD JUST TOSS 'EM!  at 22K, 10 msec, 40 msec at 5.5K

;	Now to common record things.  One is to clear the next buffer
;	(in case it remains unused.)  This prevents it from being
;	used by anyone who thinks it has useful data in it.

$reccom:mov	ax,rec_depth		;<32>Were there any pending buffers
	or	ax,ax			;<32>
	jz	$noextra		;Nope

	les	di,nextrec_queue;<32>::::::::Point at the buffer (unused):::::
$clrnxt:mov	bx,es			;<32>
	or	bx,di			;<32>
	jz	$clrall			;<32>All cleared
	xor	ax,ax			;Zero out the length since it
	mov	word ptr es:[di].sndlen,ax	;was never used
	mov	word ptr es:[di].sndlen[2],ax	;Zero len of recorded sound
	les	di,es:[di].sndchain	;<32>Do next record
	jmp	short $clrnxt		;<32>
	page
;------------------------------------------------------------------------------
;	Indicate how much of the users buffer was filled by updating
;	the length fields in his buffer based on our internal counts.
;------------------------------------------------------------------------------

$clrall:mov	word ptr nextrec_queue,bx	;<33>Zero pointer
	mov	word ptr nextrec_queue[2],bx	;<33>
	mov	rec_depth,bx			;<33>No buffers in there
$noextra:
	les	di,rec_hdr	;::::::::Get header on user buf:::::::::::::::
	mov	ax,word ptr es:[di].sndlen	;Number of bytes psbl
					;to fill.
	sub	ax,word ptr rec_len	;Subtract remaining counter
	mov	word ptr es:[di].sndlen,ax	;Store used count
	mov	ax,word ptr es:[di].sndlen[2]	;Number of bytes psbl
					;to fill.
	sbb	ax,word ptr rec_len[2]	;Subtract remaining counter
	mov	word ptr es:[di].sndlen[2],ax	;Store used count

	xor	ax,ax
	mov	word ptr disk_pl_len,ax	;<22>Zero count of buffers for
	mov	word ptr disk_pl_len[2],ax	;<22>file record.  NOTE:
					;<22>This being zero is the only
					;<22>indication that disk recording
					;<22>is to cease.
	mov	al,DMAIEI		;Parting command to hardware
	mov	dx,DacBase
	out	dx,al
	jmp	short $stopcom
$notinrec:
	mov	ax,snd_mode
	test	ax,DISKRECORD
	jz	$notdskrec

;	Here the disk record function was active, so allow it to get
;	flushed out.  We will block but allow interrupts, including our own

	and	snd_mode,NOT INRECORD	;<33>Make sure record flag is off
	sti	;-----------------------------------------------------------
$dskreclp:
	call	snd_rec_offl		;<33>Place on write queue
	call	snd_disk_wr		;<33>Write any buffers on queue
	mov	ax,snd_mode		;<33>
	test	ax,DISKRECORD		;<33>
	jnz	$dskreclp		;<33>Make another pass

$notdskrec:
	call	snd_file_buf_unload	;<34>Get buffers back on free queue

	mov	dx,DacBase
	in	al,dx
	and	al,NOT (DMAIEICL OR DMADRQ)
	out	dx,al

$stopcom:
	mov	ax,NOT (INRECORD OR STOPDMA OR INPLAY OR BIAS OR DISKPLAY OR DISKABORT)	;<34>
	and	word ptr snd_mode,ax

	popf	;--------------------------------------------------------------
	pop	es
	pop	ds
	pop	si
	pop	di
	pop	bp
	ret
	page
;------------------------------------------------------------------------------
;	This section handles the search for the buffer that contains
;	a specific sound.  We do this without hitting flush, the logic
;	being that we promise to stop within 100 msec of the target,
;	and we stop if we don't find the target, and the unflushed buffer
;	holds no more than 100 msec of sound.  Neat, huh?
;------------------------------------------------------------------------------

$nottime:
	mov	ax,snd_mode
	test	al,INPLAY
	jnz	$tryit
	call	_snd_flush
$tryit:	cli	;--------------------------------------------------------------
	les	di,queue_play		;Point at the list of buffers to play
	mov	ax,es
	or	ax,di			;Is queue empty?
	jnz	$moretime		;<30>
	jmp	$timeisup		;Then cleanup and get out

$moretime:
	mov	es,ax			;AX contains segment from earlier
	mov	di,[bp].offs		;Get pointer to structure
	mov	ax,es:[di].sndticket	;Get ticket

	les	di,queue_play		;Load pointer to play list again
	mov	cx,ds			;Point at head of chain
	mov	si,offset queue_play	;(NOT THE FIRST BUFFER)

$findloop:
	cmp	ax,es:[di].play_buf_ticket
	jz	$match			;Found the point
	mov	cx,es			;Save last one looked at
	mov	si,di
	les	di,es:[di].play_buf_next;Advance to next buffer on chain
	mov	bx,es			;See if it is NULL
	or	bx,di
	jnz	$findloop

;	Here we have searched all buffers and the ticket is not there,
;	so Nuke 'em all, Mr. Bligh!

	mov	cx,ds			;Point at head of chain
	mov	si,offset queue_play	;(NOT THE FIRST BUFFER)
	page
$match:	mov	word ptr tmp_queue,di	;Save pointer to matching structure
	mov	word ptr tmp_queue[2],es
	xor	ax,ax
	mov	es,cx
	mov	word ptr es:[si].play_buf_next,ax	;Zero next pointer
	mov	word ptr es:[si].play_buf_next[2],ax	;Zero next pointer

	mov	si,offset tmp_queue
	mov	di,offset queue_free
	call	snd_cat_chain		;Transfer the truncated buffers
					;to the free list

	mov	si,offset ld_buf	;Wipe out any dregs in the composing
	mov	di,offset queue_free	;area.
	call	snd_xfer_buf		;Will do nothing if ld_buf is null
					;ld_buf will be NULL at this point

;	Now that the list to play has been chopped down to size, 
;	Make sure it has started and wait for it to finish.

	mov	ax,TRUE
	push	ax
	xor	ax,ax
	push	ax
	push	ax
	call	far ptr _snd_wait	;Wait for player to finish
	add	sp,6
	jmp	$timeisup		;Shutdown everything

_snd_stop	endp

	public	snd_dma_stop
snd_dma_stop	proc	near

	mov	dx,dma_mask_port
	mov	al,dma_mask_value
	or	al,4
	out	dx,al

	mov	ax,snd_mode		;<30>Find out what is going on
	test	ax,DISKPLAY or DISKRECORD	;<30>If these are on
	jnz	$nores			;<30>we have just underrun
	call	snd_reset_clock		;<30>Reset the clocks
$nores:	mov	dx,DacBase		;<34>No matter what mode we are in
	in	al,dx			;<34>
	mov	ah,al			;<34>Make a copy
	and	ah,3			;<34>Lose all but mode field
	cmp	ah,RECMODE		;<34>Were we recording?
	jnz	$notrec			;<34>If not, Don't bother

	and	al,0fch			;<34>mask mode
	or	al,PLAYMODE		;<34>Switch hardware into play mode
	out	dx,al			;<34>Hardware not in record mode
	inc	dx			;<34>Bump to data point
	in	al,dx			;<34>Read and toss any pending
$notrec:ret

snd_dma_stop	endp

	public	snd_reset_clock
snd_reset_clock	proc near
	mov	ax,_snd_clock		;<30>
	or	ax,ax			;<30>
	jz	$nores1			;<30>Psbl redundant call
	mov	_snd_clock_t,ax		;<30>Save total
	xor	ax,ax			;<30>
	mov	_snd_clock,ax		;<30>Reset clock
	mov	snd_residue,ax		;<34>Reset clock
$nores1:ret

snd_reset_clock	endp

	public	snd_file_buf_unload
snd_file_buf_unload	proc	near
	
	mov	ax,snd_mode		;<34>
	test	ax,DISKPLAY		;<34>Should we do this?
	jz	$nounl			;<34>
	test	ax,COMPRESS		;<34>
	jz	$nounc			;<34>Don't release this
	mov	si,offset compress_hold	;<34>
	mov	di,offset queue_free	;<34>
	call	snd_xfer_buf		;<34>
$nounc:	mov	si,offset disk_queue_free	;<34>
	mov	di,offset queue_free	;<34>
	call	snd_cat_chain		;<34>
	mov	si,offset disk_exp_queue;<34>
	mov	di,offset queue_free	;<34>
	call	snd_cat_chain		;<34>
$nounl:	ret				;<34>

snd_file_buf_unload	endp

sndseg	ends
	end

