;------------------------------------------------------------------------
;                                                                        
; CSRFORM.INC Form Manager Include File for DMCSR
;                                                                        
;------------------------------------------------------------------------

; Form Manager 
FORM_HDR struc
    FORM_HDR_bNewList         db  ?   ;new list flag 
    FORM_HDR_bVideo           db  ?   ;video output flag 
    FORM_HDR_list_size        dw  ?   ;size of form in words 
    FORM_HDR_stroke_size      dw  ?   ;size of the stroke section in bytes 
    FORM_HDR_next_entry       dw  ?   ;for internal use only 
    FORM_HDR_last_def         dw  ?   ;for internal use only 
    FORM_HDR_tag_cnt          dw  ?   ;for internal use only 
    FORM_HDR_pGroup           dw  ?   ;pointer to group header 
    FORM_HDR_pFormList        dw  ?   ;pointer to the form buffer 
    FORM_HDR_pStrokes         dw  ?   ;pointer to the stroke list 
FORM_HDR ends

FORM_SIZE_BUF struc
    FORM_SIZE_BUF_list        dw  ?   ;size of list 
    FORM_SIZE_BUF_strokes     dw  ?   ;size of strokes 
FORM_SIZE_BUF ends

FORM_DST struc
    FORM_DST_x0               dw  ?   ;x origin integer 
    FORM_DST_x0f              dw  ?   ;x origin fraction 
    FORM_DST_y0               dw  ?   ;y origin integer 
    FORM_DST_y0f              dw  ?   ;y origin fraction 
    FORM_DST_x1               dw  ?   ;x end integer 
    FORM_DST_x1f              dw  ?   ;x end fraction 
    FORM_DST_y1               dw  ?   ;y end integer 
    FORM_DST_y1f              dw  ?   ;y end fraction 
FORM_DST ends

ELEMENT struc
    ELEMENT_type              db  ?   ;element type 
    ELEMENT_mod               db  ?   ;element attribute 
    ELEMENT_x0                dw  ?   ;x origin integer 
    ELEMENT_x0f               dw  ?   ;x origin fraction 
    ELEMENT_y0                dw  ?   ;y origin integer 
    ELEMENT_y0f               dw  ?   ;y origin fraction 
    ELEMENT_x1                dw  ?   ;x end integer 
    ELEMENT_x1f               dw  ?   ;x end fraction 
    ELEMENT_y1                dw  ?   ;y end integer 
    ELEMENT_y1f               dw  ?   ;y end fraction 
ELEMENT ends

FORM_SYS_TEXT       equ 1

FORM_POLY_TYPE      equ 'P'
FORM_ELLIP_TYPE     equ 'E'
FORM_LINE_TYPE      equ 'L'
FORM_BEV_TYPE       equ 'B'
FORM_RECT_TYPE      equ 'R'
FORM_TEXT_TYPE      equ 'T'
FORM_OTHER          equ 'U'

FORM_U_ARC_TYPE         equ 'A'
FORM_U_IMAGE_TYPE       equ 'I'
FORM_U_POLYLINE_TYPE    equ 'P'

FORM_ROT0       equ 0
FORM_ROT90      equ 1
FORM_ROT180     equ 2
FORM_ROT270     equ 3

FORM_LINE struc
    FORM_LINE_element         db  size ELEMENT dup (?)
    FORM_LINE_color           db  ?   ;line color 
    FORM_LINE_width           db  ?   ;line width 
FORM_LINE ends

FORM_RECT struc
    FORM_RECT_element         db  size ELEMENT dup (?)
    FORM_RECT_lncolor         db  ?   ;rectangle color 
    FORM_RECT_lnwidth         db  ?   ;rectangle width 
    FORM_RECT_lnstyle         db  ?   ;rectangle line style 
    FORM_RECT_bgnd_color      db  ?   ;background color of pattern 
    FORM_RECT_fgnd_color      db  ?   ;foreground color of pattern 
    FORM_RECT_pad             db  ?
FORM_RECT ends

FORM_BEV struc
    FORM_BEV_element          db  size ELEMENT dup (?)
    FORM_BEV_lncolor          db  ?   ;rectangle color 
    FORM_BEV_lnwidth          db  ?   ;rectangle width 
    FORM_BEV_lnstyle          db  ?   ;rectangle line style 
    FORM_BEV_bgnd_color       db  ?   ;background color of pattern 
    FORM_BEV_fgnd_color       db  ?   ;foreground color of pattern 
    FORM_BEV_pad              db  ?
FORM_BEV ends

FORM_ELLIPSE struc
    FORM_ELLIPSE_element      db  size ELEMENT dup (?)
    FORM_ELLIPSE_lncolor      db  ?   ;rectangle color 
    FORM_ELLIPSE_lnwidth      db  ?   ;rectangle width 
    FORM_ELLIPSE_lnstyle      db  ?   ;rectangle line style 
    FORM_ELLIPSE_bgnd_color   db  ?   ;background color of pattern 
    FORM_ELLIPSE_fgnd_color   db  ?   ;foreground color of pattern 
    FORM_ELLIPSE_pad          db  ?
FORM_ELLIPSE ends

FORM_TEXT struc
    FORM_TEXT_element         db  size ELEMENT dup (?)
    FORM_TEXT_attr            db  ?   ;character attribute for the string 
    FORM_TEXT_color           db  ?   ;foreground color of string 
    FORM_TEXT_nChars          db  ?   ;number of characters in the string 
    FORM_TEXT_rot             db  ?   ;character rotation 
    FORM_TEXT_pString         dw  ?   ;pointer to the string 
FORM_TEXT ends

FORM_U struc
    FORM_U_element            db  size ELEMENT dup (?)
    FORM_U_size               dw  ?
FORM_U ends

FORM_GATTR struc
    FORM_GATTR_line_fgnd_color db  ?   ;line pattern foreground color 
    FORM_GATTR_line_bgnd_color db  ?   ;line pattern background color 
    FORM_GATTR_line_style     db  ?   ;line style 
    FORM_GATTR_line_width     db  ?   ;line width 
    FORM_GATTR_pattern        db  ?   ;line pattern/fill pattern 
    FORM_GATTR_bgnd_color     db  ?   ;fill pattern background color 
    FORM_GATTR_fgnd_color     db  ?   ;fill pattern foreground color 
    FORM_GATTR_pad            db  ?   ;padding 
FORM_GATTR ends

FORM_TATTR struc
    FORM_TATTR_color          db  ?
    FORM_TATTR_attr           db  ?
    FORM_TATTR_rot            db  ?
    FORM_TATTR_font           db  ?
FORM_TATTR ends

FORM_U_ARC struc
    FORM_U_ARC_u_header       db  size FORM_U dup (?)   ;type U mod A 
    FORM_U_ARC_attr           db  size FORM_GATTR dup (?)
    FORM_U_ARC_xext           dw  ?   ;Original x extent of bounding rect 
    FORM_U_ARC_yext           dw  ?   ;Original y extent of bounding rect 
    FORM_U_ARC_arc            db  size ARC dup (?)   ;arc definition 
FORM_U_ARC ends

FORM_U_POLYLINE struc
    FORM_U_POLYLINE_u_header  db  size FORM_U dup (?)   ;type U mod P 
    FORM_U_POLYLINE_attr      db  size FORM_GATTR dup (?)
    FORM_U_POLYLINE_xext      dw  ?   ;original x extent of bounding rectangle 
    FORM_U_POLYLINE_yext      dw  ?   ;original y extent of bounding rectangle 
    FORM_U_POLYLINE_bFill     db  ?   ;fill flag for polygon 
    FORM_U_POLYLINE_bConnect  db  ?   ;1st & last point connect flag 
    FORM_U_POLYLINE_nPoints   dw  ?   ;number of points in polygon 
FORM_U_POLYLINE ends

FORM_U_IMAGE struc
    FORM_U_IMAGE_u_header     db  size FORM_U dup (?)   ;type U mod B 
    FORM_U_IMAGE_attr         db  size FORM_GATTR dup (?)
    FORM_U_IMAGE_bTransparent db  ?   ;transparency flag for COLOR1 
    FORM_U_IMAGE_bitmap_xext  dw  ?   ;x extent of image in pels 
    FORM_U_IMAGE_bitmap_yext  dw  ?   ;y extent of image in pels 
    FORM_U_IMAGE_nColors      db  ?   ;number of colors in image 
FORM_U_IMAGE ends

FORM_ATTR struc
    FORM_ATTR_text_color      db  ?
    FORM_ATTR_text_attr       db  ?
    FORM_ATTR_text_rot        db  ?
    FORM_ATTR_font            db  ?
    FORM_ATTR_line_fgnd_color db  ?
    FORM_ATTR_line_style      db  ?
    FORM_ATTR_line_width      db  ?
    FORM_ATTR_fill_pattern    db  ?
    FORM_ATTR_bgnd_color      db  ?
    FORM_ATTR_fgnd_color      db  ?
    FORM_ATTR_bev_pad         db  ?
    FORM_ATTR_line_bgnd_color db  ?
    FORM_ATTR_pad             db  ?
FORM_ATTR ends

FORM_GRP struc
    FORM_GRP_element          db  size ELEMENT dup (?)
    FORM_GRP_num_parts        dw  ?
    FORM_GRP_parts            dw  ?
FORM_GRP ends

;end of CSRFORM.INC
