;------------------------------------------------------------------------
;                                                                        
; CSRCMPS.INC Components, Dialog Box, Information Box and Message Box 
;             include File for DMCSR
;                                                                        
; Last update: 03/17/89
;                                                                        
;------------------------------------------------------------------------

; Titled frame 
FRAME struc
    FRAME_maprect             db  size MAPRECT dup (?)   ;origin/extent of the frame 
    FRAME_pString             dw  ?   ;pointer to title string for the frame 
FRAME ends



; Static string 
STATIC_STRING struc
    STATIC_STRING_bEnabled    db  ?   ;grayed flag 
    STATIC_STRING_xorg        dw  ?   ;x origin of string 
    STATIC_STRING_yorg        dw  ?   ;y origin of string 
    STATIC_STRING_attr        db  ?   ;string attribute 
    STATIC_STRING_pString     dw  ?   ;pointer to string 
STATIC_STRING ends



; Static box 
STATIC_BOX struc
    STATIC_BOX_type           db  ?   ;type of box 
    STATIC_BOX_maprect        db  size MAPRECT dup (?)   ;org/ext of box 
    STATIC_BOX_color          db  ?   ;color of the box 
STATIC_BOX ends



; Box types 
FLAT_BOX        equ 0       ; single thin line box 
RAISED_BOX      equ 1       ; 3-D raised block 
PYRAMID         equ 2       ; 3-D pyramid 
DEST_FLAT_BOX   equ 3       ; thin line box that erases a RAISED_BOX 
LISTBOX_BOX     equ 4       ; item list border for listboxes 
GRAYED_BOX      equ 80h    ; flag to make boxes grayed 
ENLARGED_BOX    equ 40h    ; flag to pad frame interior with gap 

; Static Icon 
STATIC_ICON struc
    STATIC_ICON_maprect       db  size MAPRECT dup (?)   ;icon org/ext 
    STATIC_ICON_pIcon         dw  ?   ;pointer to icon definition 
STATIC_ICON ends



; Dialog box 
DIALOG_BOX struc
    DIALOG_BOX_bStatRedraw    db  ?   ;redraw flag for static items 
    DIALOG_BOX_return_value   dw  ?   ;return code 
    DIALOG_BOX_focus_index    db  ?   ;next focus id 
    DIALOG_BOX_help_level     db  ?   ;help level 
    DIALOG_BOX_pFrame         dw  ?   ;pointer to FRAME structure 
    DIALOG_BOX_nStrings       db  ?   ;number of static strings 
    DIALOG_BOX_pStrings       dw  ?   ;ptr to STATIC_STRING structs 
    DIALOG_BOX_nBoxes         db  ?   ;number of static boxes 
    DIALOG_BOX_pBoxes         dw  ?   ;pointer to STATIC_BOX structs 
    DIALOG_BOX_nIcons         db  ?   ;number of static icons 
    DIALOG_BOX_pIcons         dw  ?   ;pointer to STATIC_ICON structs 
    DIALOG_BOX_nCmps          db  ?   ;number of components 
    DIALOG_BOX_pRFlags        dw  ?   ;ptr to component redraw flags 
    DIALOG_BOX_pCmps          dw  ?   ;ptr to component pointer list 
DIALOG_BOX ends



; Static item redraw flags 
DLG_REDRAW      equ SELECTED
DLG_NO_REDRAW   equ DESELECTED

; No dialog box help 
DLG_NO_HELP     equ CSR_NULL

; OK and Cancel button accelerators 
DLG_OK_KEY      equ RETURN_KEY
DLG_CANCEL_KEY  equ ESC_KEY

; New component session , used in bEnables cmp_headers 
DLG_NEW_SESSION equ 80h

; Request for event_appl to be returned to application, or in help_level 
DLG_APPL_REQUEST equ (MENU_TAG+01) ; return code for appl events     
DLG_RETURN_APPLS equ 80h          ; all appl events to be returned  


; Information Box 
INFO_STRING struc
    INFO_STRING_maprect       db  size MAPRECT dup (?)   ;word wrap boundaries 
    INFO_STRING_color         db  ?   ;foreground color of string 
    INFO_STRING_pString       dw  ?   ;pointer to zero terminated string 
INFO_STRING ends



INFO_ICON struc
    INFO_ICON_icon            db  size STATIC_ICON dup (?)   ;icon definition structure 
    INFO_ICON_line_type       db  ?   ;line type for stroke list 
    INFO_ICON_line_width      db  ?   ;line width for stroke list 
    INFO_ICON_line_color      db  ?   ;line color for stroke list 
INFO_ICON ends



INFO_BOX struc
    INFO_BOX_frame            db  size STATIC_BOX dup (?)   ;STATIC_BOX for INFO_BOX frame 
    INFO_BOX_bgnd_color       db  ?   ;background color of box 
    INFO_BOX_nStrings         db  ?   ;number of strings in INFO_BOX 
    INFO_BOX_pStrings         dw  ?   ;pointer to INFO_STRING struc s  
    INFO_BOX_nBoxes           db  ?   ;number of static boxes in INFO_BOX 
    INFO_BOX_pBoxes           dw  ?   ;pointer to STATIC_BOX struc s  
    INFO_BOX_nIcons           db  ?   ;number of icon images in INFO_BOX 
    INFO_BOX_pIcons           dw  ?   ;pointer to STATIC_ICON struc s  
    INFO_BOX_nImages          db  ?   ;number of generic bitmaps in INFO_BOX 
    INFO_BOX_pImages          dw  ?   ;pointer to IMAGE struc s  
INFO_BOX ends



; Information Box String attribute defines 
; Information Box String attribute defines 
INFO_NORMAL       equ 0C0h      ; info_box NORMAL attribute 
INFO_BOLD         equ 0C1h      ; info_box BOLD attribute 
INFO_ITALIC       equ 0C2h      ; info_box ITALIC attribute 
INFO_UNDERLINE    equ 0C3h      ; info_box UNDERLINE attribute 
INFO_INVERSE      equ 0C4h      ; info_box INVERSE attribute 
INFO_GRAYED       equ 0C5h      ; info_box GRAYED attribute 
INFO_TRANSPARENT  equ 0C6h      ; info_box TRANSPARENT attribute 
INFO_RES1         equ 0C7h      ; info_box RESERVED 1 attribute 
INFO_RES2         equ 0C8h      ; info_box RESERVED 2 attribute 

INFO_NO_FRAME     equ CSR_ERROR ; no frame option for info boxes 

; Component Manager 
CMP_ROUTINES struc
    CMP_ROUTINES_pOpen        dd  ?   ;pointer to open routine for the component 
    CMP_ROUTINES_pDraw        dd  ?   ;pointer to draw routine for the component 
    CMP_ROUTINES_pRun         dd  ?   ;pointer to run routine for the component 
    CMP_ROUTINES_pClose       dd  ?   ;pointer to close routine for component 
    CMP_ROUTINES_pHelp        dd  ?   ;pointer to routine to return help string 
CMP_ROUTINES ends



; Null routine 
CMP_NO_ROUTINE   equ 0

; General 
CMP_HEADER struc
    CMP_HEADER_type           dw  ?   ;component type 
    CMP_HEADER_bEnabled       db  ?   ;enable flag for component 
    CMP_HEADER_maprect        db  size MAPRECT dup (?)   ;origin/extent 
    CMP_HEADER_accel          dw  ?   ;key accelerator for component 
    CMP_HEADER_return_code    dw  ?   ;return code for component 
CMP_HEADER ends



; No handle 
CMP_NULL_HANDLE     equ -1

; Types 
CMP_PUSHBUTTON      equ CMP_TAG+0
CMP_RADIOBUTTONS    equ CMP_TAG+1
CMP_ICONBUTTON      equ CMP_TAG+2
CMP_LISTBOX         equ CMP_TAG+3
CMP_CHECKBOX        equ CMP_TAG+4
CMP_EDIT            equ CMP_TAG+5
CMP_MENUBAR         equ CMP_TAG+6
CMP_MESSAGE         equ CMP_TAG+7

CMP_QUEUE_HELP      equ CMP_TAG+251	; 03-17-89 
CMP_MESSAGE_BOX     equ CMP_TAG+252
CMP_DLG_BOX         equ CMP_TAG+253
CMP_MMBAR           equ CMP_TAG+254

; Return codes 
CMP_NO_ACTION       equ 0           ; no action taken within component 
CMP_ACTION          equ 1           ; component status has changed 
CMP_SCROLLED        equ 2           ; scroll occured 
CMP_TRUNCATED       equ 3           ; edit string was truncated 
CMP_CANCEL          equ 5           ; component was canceled 
CMP_DISABLED        equ 6           ; component was grayed 
CMP_GO              equ 7           ; user invoked select and go 
CMP_SELECT_CHANGE   equ 8           ; user invoked selection change 
CMP_ACTION_IN_EVENT equ 9           ; cmp action is in the event queue 
CMP_APPL            equ 10          ; cmp received an EVENT_APPL event 

; Null states 
NO_ACCEL     equ -1     ; no accelerator 
NO_SELECTED  equ -1     ; no selected 

; Keep component out of tab order 
CMP_NO_TAB          equ 02h

; Pushbutton Component 
PUSHBUTTON struc
    PUSHBUTTON_header         db  size CMP_HEADER dup (?)
    PUSHBUTTON_type           db  ?   ;flat or raised 
    PUSHBUTTON_bState         db  ?   ;up/down flag 
    PUSHBUTTON_pattern        db  ?   ;pattern number of background 
    PUSHBUTTON_pString        dw  ?   ;pointer to button name string 
PUSHBUTTON ends



; Header maprect 
PB_BASE_XEXT        equ 2*CHAR_XEXT
PB_YEXT             equ 345
PB_DEFAULT_ACCEL    equ CSR_DEFAULT

; Types 
PB_FLAT         equ 1   ; flat pushbutton 
PB_RAISED       equ 0   ; raised pushbutton 
PB_INV_RAISED   equ 2   ; invert raised pushbutton on press 

; States 
PB_UP       equ DESELECTED
PB_DOWN     equ SELECTED

; Radiobuttons Component 
RADIOBUTTON struc
    RADIOBUTTON_bEnabled      db  ?   ;enable  grayed  flag 
    RADIOBUTTON_xorg          dw  ?   ;x origin relative to group 
    RADIOBUTTON_yorg          dw  ?   ;y origin relative to group 
RADIOBUTTON ends



RB_GROUP struc
    RB_GROUP_header           db  size CMP_HEADER dup (?)
    RB_GROUP_nAcross          db  ?   ;number of buttons wide 
    RB_GROUP_nDown            db  ?   ;number of buttons tall 
    RB_GROUP_selected         db  ?   ;ordinal id of pushed button 
    RB_GROUP_pattern          db  ?   ;pattern number of background 
    RB_GROUP_nButtons         db  ?   ;number of buttons in group 
    RB_GROUP_pButtons         dw  ?   ;pointer to RADIOBUTTON structures 
    RB_GROUP_cursor           db  ?   ;cursor button index 
RB_GROUP ends



; Radiobutton extents 
RB_XEXT     equ 3*CHAR_XEXT
RB_YEXT     equ CHAR_YEXT

; Iconbutton Component 
ICONBUTTON struc
    ICONBUTTON_header         db  size CMP_HEADER dup (?)
    ICONBUTTON_type           db  ?   ;type of iconbutton 
    ICONBUTTON_bState         db  ?   ;on/off flag 
    ICONBUTTON_pattern        db  ?   ;pattern number of background 
    ICONBUTTON_interior       db  ?   ;interior pattern of button 
    ICONBUTTON_pUp            dw  ?   ;icon "on" definition 
    ICONBUTTON_pDown          dw  ?   ;icon "off" definition 
ICONBUTTON ends



; types 
IB_FLAT         equ 1   ; flat iconbutton 
IB_RAISED       equ 0   ; raised iconbutton 
IB_INV_RAISED   equ 2   ; invert raised icon button on press 
IB_NO_BORDER    equ 3   ; no frame on this button, flat button 

; Checkbox Component 
CHECKBOX struc
    CHECKBOX_header           db  size CMP_HEADER dup (?)
    CHECKBOX_bState           db  ?   ;checked/unchecked flag 
CHECKBOX ends



; Header maprect 
CB_XEXT     equ 2*CHAR_XEXT
CB_YEXT     equ 1*CHAR_YEXT

; State 
CB_CHECKED      equ SELECTED
CB_UNCHECKED    equ DESELECTED

; Listbox Component 
LISTBOX struc
    LISTBOX_header            db  size CMP_HEADER dup (?)
    LISTBOX_bTitle            db  ?   ;title selectable flag 
    LISTBOX_bScroll           db  ?   ;scroll direction flag 
    LISTBOX_bAlphabetize      db  ?   ;list alphabetization flag 
    LISTBOX_bMulti            db  ?   ;multi select flag 
    LISTBOX_border            db  ?   ;border type 
    LISTBOX_bgnd_color        db  ?   ;background color 
    LISTBOX_fgnd_color        db  ?   ;foreground color 
    LISTBOX_top_string        db  ?   ;number of top item in window 
    LISTBOX_selected          db  ?   ;list box selected item 
    LISTBOX_pString           dw  ?   ;list box title 
    LISTBOX_nItems            db  ?   ;number of strings 
    LISTBOX_pSelected         dw  ?   ;pointer to selected list 
    LISTBOX_pItems            dw  ?   ;pointer to string list 
LISTBOX ends



; Header maprect 
LB_BASE_XEXT    equ 2*CHAR_XEXT
LB_BASE_YEXT    equ 2*CHAR_YEXT

; Scroll types 
LB_VERT_SCROLL  equ 0           ; single column vertical scrolling 
LB_HORZ_SCROLL  equ 1           ; 2 coumn horizontal scrolling 

; Additional border types 
LB_NO_FRAME     equ -1          ; no frame around listbox 
LB_NO_BORDER    equ -2          ; no border or frame around listbox 

; Use current colors 
LB_NO_COLOR     equ CSR_DEFAULT

; y extent from top of listbox to top of list 
LB_TITLE_YEXT   equ CHAR_YEXT*3/2

; Listbox in multi-select mode mask 
LB_IN_MULTI     equ 02h

; Editfield Component 
EDITFIELD struc
    EDITFIELD_header          db  size CMP_HEADER dup (?)
    EDITFIELD_type            db  ?   ;edit field type 
    EDITFIELD_bHighlight      db  ?   ;flag to highlight field on run 
    EDITFIELD_dec_places      db  ?   ;number of places to the right of . 
    EDITFIELD_edit_maprect    db  size MAPRECT dup (?)   ;visible part 
    EDITFIELD_attr            db  ?   ;char attribute to use 
    EDITFIELD_cursor_offset   dw  ?   ;cursor offset into string 
    EDITFIELD_end_offset      dw  ?   ;offset to end of string 
    EDITFIELD_select_offset   dw  ?   ;offset to select start 
    EDITFIELD_select_length   dw  ?   ;length of selected area 
    EDITFIELD_terminator      db  ?   ;terminating character of string 
    EDITFIELD_pBuffer         dw  ?   ;pointer to edit string 
    EDITFIELD_pFormat         dw  ?   ;pointer to format string 
    EDITFIELD_scroll_type     db  ?   ;direction of scroll 
    EDITFIELD_scroll_length   dw  ?   ;number of chars to scroll 
    EDITFIELD_scroll_height   dw  ?   ;number of rows to scroll 
    EDITFIELD_bNoEdit         db  ?   ;editable field flag 
    EDITFIELD_border          db  ?   ;border type for editfield 
EDITFIELD ends



; Editable field flags 
EF_EDITABLE         equ DESELECTED
EF_NO_EDIT          equ SELECTED

; Types 
EF_STATIC           equ 00h ; static 
EF_EXPAND           equ 01h ; expand size of feild on insert 
EF_RIGHT_JUSTIFY    equ 02h ; right justification of edit string 
EF_NUMBER           equ 04h ; numeric input only 
EF_EXTNUM           equ 06h ; extended numeric input only 
EF_WORD_WRAP        equ 08h ; word wrap on multiline 
EF_NO_WORD_WRAP     equ 10h ; no word wrap on multiline 

; Highlight flag 
EF_HIGHLIGHT    equ ENABLED
EF_NO_HIGHLIGHT equ DISABLED

; Scroll types 
EF_SCROLL_UP        equ 0
EF_SCROLL_DOWN      equ 1
EF_SCROLL_LEFT      equ 2
EF_SCROLL_RIGHT     equ 3
EF_NO_SCROLL        equ 4
EF_SCROLL           equ 5

; Cursor offset options 
EF_SELECT_ALL       equ -1

; Frameless editfield 
EF_NO_FRAME         equ CSR_ERROR

; Editfield modified mask 
EF_MOD_MASK         equ 40h

; Menubar Component 
MENUITEM struc
    MENUITEM_type             db  ?   ;item type 
    MENUITEM_bEnabled         db  ?   ;enable  grayed  flag for item 
    MENUITEM_bChecked         db  ?   ;check flag 
    MENUITEM_accel            dw  ?   ;accelerator for item 
    MENUITEM_return_code      dw  ?   ;return code for item 
    MENUITEM_group            db  ?   ;group number of item 
    MENUITEM_pattern          db  ?   ;pattern to use as the item 
    MENUITEM_pString          dw  ?   ;pointer to item name string 
MENUITEM ends



MENU struc
    MENU_xext                 dw  ?   ;x extent of menu 
    MENU_pString              dw  ?   ;pointer to button name string 
    MENU_nItems               db  ?   ;number of items in the menu 
    MENU_pItems               dw  ?   ;pointer to MENUITEM structures 
MENU ends



MENUBAR struc
    MENUBAR_header            db  size CMP_HEADER dup (?)
    MENUBAR_bFlags            db  ?   ;arrow and top line flags 
    MENUBAR_bRedraw           db  ?   ;visible redraw flag 
    MENUBAR_nMenus            db  ?   ;number of menus on the menubar 
    MENUBAR_pMenus            dw  ?   ;pointer to MENU structures 
    MENUBAR_pattern           db  ?   ;background pattern of the menubar 
    MENUBAR_bStatus           db  ?   ;process help only flag 
MENUBAR ends



; Item check state 
MB_CHECKED     equ SELECTED
MB_UNCHECKED   equ DESELECTED

; Groups 
MB_GROUP1   equ 0
MB_GROUP2   equ 1
MB_GROUP3   equ 2
MB_GROUP4   equ 3
MB_GROUP5   equ 4
MB_GROUP6   equ 5
MB_GROUP7   equ 6
MB_GROUP8   equ 7
MB_GROUP9   equ 8

; Item types 
MB_STRING   equ 0   ; item is a string 
MB_PATTERN  equ 1   ; item is a pattern 

; Menu width 
MB_BASE_XEXT    equ 6*CHAR_XEXT     ; base x extent of a menu 

; Header maprect 
MB_XORG     equ 0               ; default x origin of a menubar 
MB_YORG     equ 290             ; default y origin of a menubar 
MB_XEXT     equ 80*CHAR_XEXT    ; default x extent of a menubar 
MB_YEXT     equ 345             ; y extent of menubars 

; Accelerator 
MB_ACCEL    equ ALT_SPACE_KEY

; Flag masks 
MB_PLAIN        equ 0   ; no Tandy, help or arrow buttons 
MB_HELP_BUTTON  equ 1   ; help button 
MB_RIGHT_ARROW  equ 2   ; right arrow button 
MB_LEFT_ARROW   equ 4   ; left arrow button 
MB_DOWN_ARROW   equ 8   ; down arrow button 
MB_UP_ARROW     equ 16  ; up arrow button 
MB_TANDY        equ 32  ; Tandy icon button ...... Clearly Superior 
MB_ALARM        equ 64  ; alarm button 
MB_VERT_ARROWS  equ MB_UP_ARROW+MB_DOWN_ARROW
MB_HORZ_ARROWS  equ MB_LEFT_ARROW+MB_RIGHT_ARROW
MB_ALL_ARROWS   equ MB_VERT_ARROWS+MB_HORZ_ARROWS

; Redraw flags 
MB_REDRAW       equ SELECTED    ; redraw menubar 
MB_NO_REDRAW    equ DESELECTED  ; only redifine enabled/disabled items 

; World coordinate of the last default main menubar pixel 
MB_BOTTOM_YORG  equ MB_YORG+MB_YEXT-1

; Alarm menu access mask for bSatus element of the MENUBAR structure 
MB_ALARM_ACCESS equ 01h

; mb_add_alarm return codes 
MB_NOT_NOTIFIED     equ 01h    ; alarm added but User not notified 
MB_ALARM_EXISTS     equ 02h    ; alarm exists, not added again 

; Message Box Manager 
MSGBOX struc
    MSGBOX_btn_combo          db  ?   ;button combination 
    MSGBOX_pString            dw  ?   ;pointer to title string 
    MSGBOX_pMessage           dw  ?   ;pointer to message 
MSGBOX ends



; Button combinations 
MSG_COMBO_OK            equ 0   ; OK button only 
MSG_COMBO_OK_CAN        equ 1   ; OK and CANCEL buttons 
MSG_COMBO_YES_NO_CAN    equ 2   ; YES, NO and CANCEL buttons 
; Combos 3-11 must remain undefined for 1987 compatibility 
MSG_COMBO_CANCEL        equ 12  ; CANCEL button only 
MSG_COMBO_RETRY_CAN     equ 13  ; RETRY and CANCEL buttons 
MSG_COMBO_YES_NO        equ 14  ; YES and NO buttons 

; Button return codes 
MSG_OK          equ MSG_TAG+1
MSG_CANCEL      equ MSG_TAG+2
MSG_YES         equ MSG_TAG+3
MSG_NO          equ MSG_TAG+4
; Buttons 5-10 must remain undefined for 1987 compatibility 
MSG_RETRY       equ MSG_TAG+11
; Buttons 12-16 must remain undefined for 1987 compatibility 

MSG_HS_XORG     equ 36*CHAR_XEXT
MSG_HS_YORG     equ 14*CHAR_YEXT
MSG_HS_XEXT     equ 8*CHAR_XEXT

; Message box save rectangle 
MSG_SAVE_XORG   equ 19*CHAR_XEXT
MSG_SAVE_YORG   equ 8*CHAR_YEXT
MSG_SAVE_XEXT   equ 42*CHAR_XEXT
MSG_SAVE_YEXT   equ 9*CHAR_YEXT

;end of CSRCMPS.INC
