/*------------------------------------------------------------------------*/
/*                                                                        */
/* CSRBASE.H Base Include File for DMCSR                                  */
/*                                                                        */
/* This include file contains common/miscellaneous defines and            */
/* structures, including:                                                 */
/*     Compatibility defines                                              */
/*     Tags                                                               */
/*     General defines                                                    */
/*     Common key codes                                                   */
/*     Mapping rectangles                                                 */
/*     Title line constants                                               */
/*     Common graphic primitives                                          */
/*     Event Manager defines and structures                               */
/*     HELP structure                                                     */
/*     ALARM structure                                                    */
/*                                                                        */
/* Last Update: 03-24-89                                                  */
/*                                                                        */
/*------------------------------------------------------------------------*/
#ifndef CSRBASE_INCLUDED
#define CSRBASE_INCLUDED 1

/* CSR/Application version defines */
#define USER88      0   /* current CSR User is a 1988 version */
#define USER89      1   /* current CSR User is a 1989 version */

/* Return code tags */
#define ASCII_TAG   0x0000      /* ASCII key codes */
#define SYS_TAG     0xFF00      /* system defined return codes */
#define ALT_TAG     0xFE00      /* ALT'ed key codes */
#define CTRL_TAG    0xFD00      /* CTRL'ed key codes */
#define BIG_TAG     0xFC00      /* big select key codes */
#define MOUSE_TAG   0xFB00      /* mouse event manager codes */
#define MENU_TAG    0xFA00      /* menubar component codes */
#define ARROW_TAG   0xF900      /* arrow key and menubar arrow codes */
#define CMP_TAG     0xF800      /* component code */
#define MSG_TAG     0xF700      /* message box codes */
#define FILE_TAG    0xF600      /* form manager codes */
#define APP_TAG     0xF500      /* application defined return codes */
#define F11_TAG     0xF400      /* F11 DeskMate extended codes */
#define WDG_TAG     0x8400      /* keyboard wedge modified key codes */

/* General defines */
#define CHAR_XEXT       100         /* world coordinate width of character */
#define CHAR_YEXT       220         /* world coordinate height of character */

#define CSR_NULL         0          /* null or not available code */
#define CSR_ERROR       -1          /* error or exception code */
#define CSR_DEFAULT     -2          /* default state code */

#define HCR             0x0D        /* hard carriage return */
#define SCR             0x0A        /* soft carraige return */

#define LINE_FEED       0x0A        /* line feed control code */
#define FORM_FEED       0x0C        /* form feed control code */

#define END_OF_FILE     0x1A        /* end of file marker */

#define BELL            7           /* bell character */

#define ENABLED         1           /* item or feature enabled */
#define DISABLED        0           /* item or feature disabled */

#define SELECTED        ENABLED     /* item or feature selected */
#define DESELECTED      DISABLED    /* item or feature deselected */

#define BUTTON_UP       DESELECTED  /* button is up, item not selected */
#define BUTTON_DOWN     SELECTED    /* button is down, item selected */

#define BUSY_PRESERVE       SELECTED    /* preserve bgnd of busy icon (TBD) */
#define BUSY_NO_PRESERVE    DESELECTED  /* do not preserve bgnd (TBD) */

/* Common key codes */
#define RETURN_KEY      (ASCII_TAG+0x0D)
#define ESC_KEY         (ASCII_TAG+0x1B)
#define ALT_SPACE_KEY   (WDG_TAG+0x06)

/* These are the different accessories available & their associated codes */
#define ACC_CALC        0x00
/* 0x01 must remain undefined due to MS-DOS parameter limitations */
#define ACC_NOTEPD      0x02
#define ACC_CORKBRD     0x02
#define ACC_CAL         0x03
#define ACC_CLIPBD      0x04
#define ACC_COLORS      0x05
#define ACC_COMM        0x06
#define ACC_DATTIM      0x07
#define ACC_MOUSE       0x08
#define ACC_PRINTR      0x09
#define ACC_HELP        0x0A
#define ACC_PGSETUP     0x0B
#define ACC_PHONE       0x0C
#define ACC_DESKLINK    0x0D
#define ACC_VIDEO       0x0E
#define ACC_TASKSWITCH  0x0F
#define ACC_SPELL       0x10
#define ACC_ALARM       0x11
#define ACC_SETUP       0x12
#define ACC_TALK        0x13

#define ACC_TODO        0x14
#define ACC_MORE        0x15


/* 02-06-89 - equates moved form the dmexec.inc */
/*---------------------------------------------------------------------------*/
/* The executive is responsible for providing the Core Services Resource     */
/* with two blocks of memory. The first is a single block used by the CSR    */
/* for CSR task independent data.  The second block is for the data for the  */
/* currently execing task.  The segment addresses for the blocks of data     */
/* will be placed in an unused location in the vector table. It is the execs */
/* responsibility to make sure the second (task specific) address is always  */
/* correct.                                                                  */
/*---------------------------------------------------------------------------*/
#define CSR_RAM_VECTOR_SEG	 0x0000	/* Segment add of task independent data  */
#define CSR_RAM_VECTOR_ADD	 0x0384	/* 0:offset of the task independent data */ 
#define CSR_TASK_VECTOR_ADD 0x0386	/* 0:offset of the task dependent data   */



/* Mapping rectangles */
struct rect_defn
{
    int     x1;     /* rectangle x1 coordinate */
    int     y1;     /* rectangle y1 coordinate */
    int     x2;     /* rectangle x2 coordinate */
    int     y2;     /* rectangle y2 coordinate */
};
typedef struct rect_defn RECT;

struct maprect_defn
{
    int     xorg;   /* rectangle x origin */
    int     yorg;   /* rectangle y origin */
    int     xext;   /* rectangle x extent */
    int     yext;   /* rectangle y extent */
};
typedef struct maprect_defn MAPRECT;

/* Title Line constants */
#define TTL_XORG    29*CHAR_XEXT    /* x origin of usable area of title line */
#define TTL_YORG    12              /* y origin of usable area of title line */
#define TTL_XEXT    40*CHAR_XEXT    /* x extent of usable area of title line */

/* graphic primitive structures */
struct arc_defn
{
    int     base1_x;    /* first base point x */
    int     base1_y;    /* first base point y */
    int     base2_x;    /* second base point x */
    int     base2_y;    /* second base point y */
    int     apogee_x;   /* apogee x */
    int     apogee_y;   /* apogee y */
};
typedef struct arc_defn ARC;

struct image_defn
{
    MAPRECT maprect;            /* maprect on device to size image to */
    char    bTransparent;       /* flag for COLOR1 transparency */
    int     bitmap_xext;        /* number of pels in x extent of image */
    int     bitmap_yext;        /* number of pels in y extent of image */
    char    nColors;            /* IMAGE_2COLORS, IMAGE_4COLORS, etc. */
    char    *pBitmap;           /* pointer to generic bitmap */
};
typedef struct image_defn IMAGE;

/* Number of colors in a bitmap definition */
#define IMAGE_2COLORS   1
#define IMAGE_4COLORS   2
#define IMAGE_16COLORS  4
#define IMAGE_256COLORS 8

/* Event Manager */
struct event_defn
{
    char         msg;        /* event type */
    unsigned int param;      /* event parameter */
    int          x;          /* event mouse x */
    int          y;          /* event mouse y */
};
typedef struct event_defn EVENT;

/* Event types for msg element */
#define EVENT_NULL          0   /* no event */
#define EVENT_CHAR          1   /* character event */
#define EVENT_MOUSE         2   /* mouse click event */
#define EVENT_COMMAND       3   /* command event */
#define EVENT_OUTSIDE       4   /* outside event */
#define EVENT_REEVALUATE    5   /* reevaluate raw event (for event_write) */
#define EVENT_APPL          6   /* special application message */
#define EVENT_MENU          7   /* special menubar event */

/* Mouse event types for param element */
#define MS_CLICK        (MOUSE_TAG+1)   /* single click */
#define MS_DBL_CLICK    (MOUSE_TAG+2)   /* double click */
#define MS_BUTTON_DOWN  (MOUSE_TAG+3)   /* button down (begin repeat) */
#define MS_HOLD         (MOUSE_TAG+4)   /* button held (repeating) */
#define MS_BUTTON_UP    (MOUSE_TAG+5)   /* button released (end repeat) */
#define MS_SHFT_CLICK   (MOUSE_TAG+6)   /* shifted click */

/* Application messages for param element */
#define APPL_REDRAW_VID     1   /* redraw video */
#define APPL_REDRAW_VGM     2   /* redraw form */
#define APPL_ACCESS         3   /* accessory executed */
#define APPL_TASK_SWITCH    4   /* task switch requested */
#define APPL_STAT           5   /* request for immediate Appl attention */
#define APPL_ALARM          6   /* an alarm item has been selected */

/* Definable event drivers and interpreters */
struct edriver_defn
{
    int     (far *pInit)();     /* event driver init routine pointer */
    int     (far *pRead)();     /* event driver scan routine pointer */
    int     (far *pResrv1)();   /* reserved for future use */
    int     (far *pResrv2)();   /* reserved for future use */
};
typedef struct edriver_defn EDRIVER;

struct interp_defn
{
    char    priority;           /* priority relative to internal interps */
    int     (far *pInterp)();   /* far pointer to interpreter routine */
};
typedef struct interp_defn INTERP;

#define EVENT_HIGH_PRIORITY 1
#define EVENT_LOW_PRIORITY  2

/* Mouse status */
struct mouse_stat_defn
{
    char    bDriver;        /* enable state of driver */
    char    bPointer;       /* on/off state of pointer */
    char    bRegions;       /* enable state of pointer regions */
    char    button_state;   /* status of the mouse buttons */
    int     pointer_x;      /* mouse pointer wc x position */
    int     pointer_y;      /* mouse pointer wc y position */
};
typedef struct mouse_stat_defn MOUSE_STAT;

#define MS_BUTTON_OPEN      0   /* mouse button is up */
#define MS_BUTTON_CLOSED    1   /* mouse button is closed */

/* Mouse pointer regions */
struct ptr_region_defn
{
    char    id;             /* application defined id for region */
    MAPRECT maprect;
    char    focal_x;        /* mouse hot spot x */
    char    focal_y;        /* mouse hot spot y */
    int     *pPointer;      /* pointer to mouse pointer definition */
};
typedef struct ptr_region_defn PTR_REGION;

/* Help levels */
struct help_defn
{
    long    *pMenubar;
    int     state;
    char    level;
};
typedef struct help_defn HELP;

#define HELP_NULL   0   /* no help available for category */

/* Main Menubar Manager ALARM sturcture */
struct alarm_defn
{
    char    *pType;                /* <=16 char ASCIIZ string for menuitem */
    char    *pMessage;             /* <=120 char ASCIIZ string for message */
    char    bRemove;               /* remove alarm on User selection flag */
    int     (far *pSelected)();    /* far call upon User selection address */
};
typedef struct alarm_defn ALARM;

#endif

/* end of CSRBASE.H */
