/*-------------------------------------------------------------*/
/*                                                             */
/*  AUTOLOAD.H contains the defines and structures used by     */
/*             applications calling the autoload resource.     */
/*                                                             */
/*-------------------------------------------------------------*/

#ifndef AUTOLOAD_INCLUDED
#define AUTOLOAD_INCLUDED 1

struct autoload_struct
{

    char        CallerId;       /* define code for application that
                                   requested autoload for resource */
    char        ResourceName[9];/* ASCIIZ string containing the name of
                                   the resource load */
    char        FunctionId;     /* number of function to call in resource
                                   for it to initialize or start running */
    char        LoadPriority;   /* define code for the resource load
                                   priority */
    char        FunctionParams[5]; /* 5 byte list of parameters the
                                      initialization function needs;
                                      the format is determined by the
                                      is determined by the resource */
};
typedef struct autoload_struct AUTOLOAD;

#define     LOAD_PRIORITY0      0   /* resource is loaded at applications
                                       request an free when application is
                                       is exited */
#define     LOAD_PRIORITY1      1   /* resource is loaded at applications
                                       request and unloaded for old
                                       applications and reloaded after old
                                       applications exit and freed upon
                                       exit from desk */
#define     LOAD_PRIORITY2      2   /* resource is loaded at applications 
                                       request and stays in until exit from
                                       desk */
#define     LOAD_PRIORITY3      3   /* resource is loaded before desk is 
                                       run (preloaded) and remains loaded
                                       upon exit from desk */

#define     NO_FUNCTION        -1   /* define for FunctionId if there is no
                                       initialization function */

#define     AUTO_SPELL        1     /* spell checker CallerId */
#define     AUTO_ALARM        2     /* alarm accessory CallerId */

#endif

/* end of AUTOLOAD.H */
