/*
    Play3voi.h

    Global constants and variables for Play3voi.c.
*/

#ifndef PLAY3VOI_H
#define PLAY3VOI_H

#include <stdio.h>      /* Standard I/O functions header file */

/*************************************************************************/
/*                                                                       */
/* Macros.                                                               */
/*                                                                       */
/*************************************************************************/

    /* Maximum amplification factor. */
#define MAX_AMPLIFICATION 9

    /* Maximum translation table number. */
#define MAX_TRANSLATE 1

    /* Minimum sampling rate allowed.  If you reduce this, you will need to 
       modify TESTSAMPLES in Chip3asm.asm. */
#define MIN_SAMPRATE 4000


/*************************************************************************/
/*                                                                       */
/* Global variables.                                                     */
/*                                                                       */
/*************************************************************************/

    /* Amplification factor to apply. */
extern int Amplification;

    /* I/O port value translation table to use. */
extern int Translation;

    /* File handle of sound file. */
extern FILE *FileHandle;

    /* Buffer for sound, and size of that buffer. */
extern char huge *SoundBuf;
extern unsigned long SoundBufSize;

    /* Number of bytes of sound in the sound buffer. */
extern unsigned long SoundLen;

    /* Overflow flag.  Set to 1 if the file was too long to fit entirely in 
       the buffer. */
extern int TooLong;

    /* Sampling rate of the file. */
extern unsigned SampRate;


/*************************************************************************/
/*                                                                       */
/* Function prototypes.                                                  */
/*                                                                       */
/*************************************************************************/

    /* Functions in Chip3asm.asm. */
int Test_Speed( unsigned rate );
void Play_Internal( void );

#endif
