
Unit ABI_ICMP;

Interface

{$G-}

Uses DOS,CRT,ABI,ABI_DOM,XSTRING,ABI_JP;

{$I TCP.INC}

CONST     { icmp & other IP protocols }
     ICMPTIMEOUT = 350;  {timer ticks}
     ICMPT_DUM = 3;       {Type 3  are Destination Unreachable Messages}
     ICMPT_TEM = 11;      {Type 11 are Time Exceeded Messages          }
     ICMPT_PPM = 12;      {Type 12 are Parameter Problem Messages      }
     ICMPT_SQM = 4;       {Type 4  are Source Quench Messages          }
     ICMPT_RM  = 5;       {Type 5  are Redirect Messages               }
     ICMPT_ECHO      = 8; {Type 8  are Echo Messages (e.g. PING)       }
     ICMPT_ECHOREPLY = 0; {Type 0  are Echo Reply Messages             }
     ICMPT_TS  = 13;      {Type 13 are TimeStamp messages              }
     ICMPT_TSR = 14;      {Type 14 are TimeStamp Reply messages        }
     ICMPT_IREQ = 15;     {     15 are Information REQuest messages    }
     ICMPT_IREPLY = 16;   {     16 are Information Reply messages      }

  icmpDUM : Array[0..5] of String[20] = ('net unreachable','host unreachable',
                       'protocol unreachable','port unreachable',
                       'frag need and DF set','source route failed');
  icmpTEM : Array[0..1] of String[33] = ('time to live exceeded in transit',
                       'fragment reassembly time exceeded');
  icmpPPM : Array[0..1] of String[24] = ('pointer points to error',
                       'non-showable error');
  icmpRM  : Array[0..3] of String[54] = ('Redirect datagrams for the Network',
                       'Redirect datagrams for the Host',
                       'Redirect datagrams for the Type of Service and Network',
                       'Redirect datagrams for the Type of Service and Host');

TYPE
    ICMPpacketREC = RECORD
                     Valid : Boolean;
                     SourceAddr : IPAddr;
                     DestAddr   : IPAddr;
                     Handle   : Word;
                     ICMPType : Byte;
                     Code : Byte;
                     ChkSum : Word;
                     NextOne: Word; { <= Pointer on PPM      \ gateway IP on }
                                    { Echo=ID        TimeStamp=ID            }
                                    { IREQ=ID                                }
                     NextTwo: Word; {                        / ICMPT_RM      }
                                    { Echo=Seq_Num   TimeStamp=Seq_Num       }
                                    { IREQ=Seq_Num                           }
                     OrigTimeStamp : LongInt;
                     RecvTimeStamp : LongInt;
                     TransTimeStamp: LongInt;
                   End;

VAR
  GlobalICMP:ICMPpacketREC;
  ICMPverbose:Boolean;

Function ReceiveICMP(Opts:Byte; timeout:Word):Boolean;
Function SendPing(Opts:Byte; host:IPAddr):Boolean;
Function DoPING(Opts:Byte; host:IPAddr; timeout:Word):Boolean;
Procedure IPchksum(var ChkSum,CompleteChkSum:Word; AddIt:Word);

Implementation

const CleanChr : Array[$00..$FF] of Byte = ($FF,1,2,3,4,5,6,7,8,$FF,$FF,$FF,$FF,$FF,14,15,
                      $10,$11,$12,$13,$14,$15,$16,$17,$18,$19,$1A,$1B,$1C,$1D,$1E,$1F,
                      $20,$21,$22,$23,$24,$25,$26,$27,$28,$29,$2A,$2B,$2C,$2D,$2E,$2F,
                      $30,$31,$32,$33,$34,$35,$36,$37,$38,$39,$3A,$3B,$3C,$3D,$3E,$3F,
                      $40,$41,$42,$43,$44,$45,$46,$47,$48,$49,$4A,$4B,$4C,$4D,$4E,$4F,
                      $50,$51,$52,$53,$54,$55,$56,$57,$58,$59,$5A,$5B,$5C,$5D,$5E,$5F,
                      $60,$61,$62,$63,$64,$65,$66,$67,$68,$69,$6A,$6B,$6C,$6D,$6E,$6F,
                      $70,$71,$72,$73,$74,$75,$76,$77,$78,$79,$7A,$7B,$7C,$7D,$7E,$7F,
                      $80,$81,$82,$83,$84,$85,$86,$87,$88,$89,$8A,$8B,$8C,$8D,$8E,$8F,
                      $90,$91,$92,$93,$94,$95,$96,$97,$98,$99,$9A,$9B,$9C,$9D,$9E,$9F,
                      $A0,$A1,$A2,$A3,$A4,$A5,$A6,$A7,$A8,$A9,$AA,$AB,$AC,$AD,$AE,$AF,
                      $B0,$B1,$B2,$B3,$B4,$B5,$B6,$B7,$B8,$B9,$BA,$BB,$BC,$BD,$BE,$BF,
                      $C0,$C1,$C2,$C3,$C4,$C5,$C6,$C7,$C8,$C9,$CA,$CB,$CC,$CD,$CE,$CF,
                      $D0,$D1,$D2,$D3,$D4,$D5,$D6,$D7,$D8,$D9,$DA,$DB,$DC,$DD,$DE,$DF,
                      $E0,$E1,$E2,$E3,$E4,$E5,$E6,$E7,$E8,$E9,$EA,$EB,$EC,$ED,$EE,$EF,
                      $F0,$F1,$F2,$F3,$F4,$F5,$F6,$F7,$F8,$F9,$FA,$FB,$FC,$FD,$FE,$FF);
var
  Result:Byte;

Procedure IPchksum(var ChkSum,CompleteChkSum:Word; AddIt:Word);
 begin
   Inc(ChkSum,AddIt);
   CompleteChkSum:=ChkSum;
   {If not Odd(I) then Inc(CompleteChkSum,1);}
   CompleteChkSum:=not CompleteChkSum;
 end;

Function SendPing(Opts:Byte; host:IPAddr):Boolean;
 const  FullAddr:IPAddr = ($FF,$FF,$FF,$FF);
 var
   ISESP : ipSessionREC;
   I : Integer;
   ChkSum:Word;
   CompleteChkSum:Word;
   TmpAddIt:Word;

   DebugF: text;
   TmpSeg: Word;
   TmpOff: Word;
   ToDisLength:Word;
   wCount:Word;
   TmpStr:String;
   TmpHex:String;
   TmpByte:Byte;

 begin
   SendPing:=False;
   Result:=ip_Open(ISESP, 0, host, 1);
   if Result<>0 then Write('[ERR:ip_Open:host,1]');
                            {type}    {chksum}

   FillChar(ISESP.Buffer,SizeOf(ISESP.Buffer),#0);
   AddBuffer(ISESP.Buffer, 0, #8+  #0+  #0+#0+ #$13+#$13+
                 'Alpha');
                               {code}
   Writeln;
   Writeln(ISESP.Buffer.Length);

   ChkSum:=0;  CompleteChkSum:=0;  TmpAddIt:=0;
   wCount:=1;                                                                                      {*1* was 0}
   repeat
    TmpAddIt:=Ord(ISESP.Buffer.Buffer[wCount])+(Ord(ISESP.Buffer.Buffer[wCount+1])*256);
    IPchksum(ChkSum, CompleteChkSum, TmpAddIt);
    If not Odd(ISESP.Buffer.Length) then
      begin
       Inc(wCount,2);
      end else begin
       If wCount<ISESP.Buffer.Length-2 then
           begin
            Inc(wCount,2);
           end else begin
            Inc(wCount,2);
            TmpAddIt:=Ord(ISESP.Buffer.Buffer[wCount])+(Ord(ISESP.Buffer.Buffer[wCount+1])*256);
            IPchksum(ChkSum, CompleteChkSum, TmpAddit);
            wCount:=ISESP.Buffer.Length+1;
           end;

      end;
   until wCount>ISESP.Buffer.Length;

   ISESP.Buffer.Buffer[3]:=Chr(Lo(CompleteChkSum)); {hi}                                           {*1* was 2}
   ISESP.Buffer.Buffer[4]:=Chr(Hi(CompleteChkSum));                                                {*1* was 3}

   If ip_Send(ISESP, 0, $1313, 0, 0, 0)=0 then
     begin
      Writeln('SendPING Sent to ',IPTOASCII(host));
      SendPing:=True;
     end;

   For wCount:=1 to 100 do asm nop end;
   Result:=ip_Close(ISESP, 0);
end;

Function DoPing(Opts:Byte; host:IPAddr; timeout:Word):Boolean;
 const  FullAddr:IPAddr = ($FF,$FF,$FF,$FF);
 var
   ISES : ipSessionREC;
   I : Integer;
   ChkSum:Word;
   CompleteChkSum:Word;
   TmpAddIt:Word;

   DebugF: text;
   TmpSeg: Word;
   TmpOff: Word;
   ToDisLength:Word;
   wCount:Word;
   TmpStr:String;
   TmpHex:String;
   TmpByte:Byte;

 begin
   DoPing:=False;
   Result:=ip_Open(ISES, 0, host, 1);
   if Result<>0 then Write('[ERR:ip_Open:host,1]');
                            {type}    {chksum}

   FillChar(ISES.Buffer,SizeOf(ISES.Buffer),#0);
   AddBuffer(ISES.Buffer, 0, #8+  #0+  #0+#0+ #$13+#$13+
                 'Alpha');
{                'A little more string to get a more accurate PING reading.');}
                               {code}
   Writeln;
   Writeln(ISES.Buffer.Length);

   ChkSum:=0;  CompleteChkSum:=0;  TmpAddIt:=0;
   wCount:=1;                                                                                      {*1* was 0}
   repeat
    TmpAddIt:=Ord(ISES.Buffer.Buffer[wCount])+(Ord(ISES.Buffer.Buffer[wCount+1])*256);
    IPchksum(ChkSum, CompleteChkSum, TmpAddIt);
    If not Odd(ISES.Buffer.Length) then
      begin
       Inc(wCount,2);
      end else begin
       If wCount<ISES.Buffer.Length-2 then
           begin
            Inc(wCount,2);
           end else begin
            Inc(wCount,2);
            TmpAddIt:=Ord(ISES.Buffer.Buffer[wCount])+(Ord(ISES.Buffer.Buffer[wCount+1])*256);
            IPchksum(ChkSum, CompleteChkSum, TmpAddit);
            wCount:=ISES.Buffer.Length+1;
           end;

      end;
   until wCount>ISES.Buffer.Length;
{   If not Odd(ISES.Buffer.Length) then
     begin
       TmpAddIt:=(Ord(ISES.Buffer.Buffer[ISES.Buffer.Length])*256);
       IPchksum(ChkSum,CompleteChkSum,TmpAddIt);
     end;                                                                 }

   ISES.Buffer.Buffer[3]:=Chr(Lo(CompleteChkSum)); {hi}                                            {*1* was 2}
   ISES.Buffer.Buffer[4]:=Chr(Hi(CompleteChkSum));                                                 {*1* was 3}

   If ip_Send(ISES, 0, $1313, 0, 0, 0)=0 then Writeln('PING Sent to ',IPTOASCII(host));

   For wCount:=1 to 500 do asm nop end;

   If ip_Recv(ISES,0, timeout)=0 then
     begin
         Writeln('[ICMP:Rcvd]');
                        DoPing:=True;
                        Assign(DebugF, 'ICMP.DBG');
                        ReWrite(DebugF);
                        If ISES.Buffer.Length>0 then
                          begin
                             Writeln(debugf,#13+#10);
                                  TmpSeg:=Seg(ISES.Buffer.Buffer);
                                  TmpOff:=Ofs(ISES.Buffer.Buffer);
                                  ToDisLength:=ISES.Buffer.Length;
                                  wCount:=0;
                                   TmpStr:='';
                                   TmpHex:='';
                                  repeat
                                   if ((wCount/8)=Trunc(wCount/8)) then Write(Debugf,' ');
                                   if ((wCount/16)=Trunc(wCount/16)) then
                                     begin
                                      Writeln(Debugf, ' '+TmpStr); TmpStr:=''; TmpHex:='';
                                      Write(Debugf, WordToHexASCII(wCount),': ');
                                     end;
                                   TmpByte:=Mem[TmpSeg:TmpOff+wCount];
                                   Write(Debugf, ByteToHexASCII(TmpByte)+' ');
                                   TmpStr:=TmpStr+Chr(CleanChr[TmpByte]);
                                  inc(wCount);
                                  until wCount=ToDisLength;
                                   Writeln(debugf, ' '+TmpStr);
                          end;
                        Close(DebugF);

     end;

   Result:=ip_Close(ISES, 0);
   if Result<>0 then Write('[ERR:ip_Close]');
 end;



Function ReceiveICMP(Opts:Byte; timeout:Word):Boolean;
 const  FullAddr:IPAddr = ($FF,$FF,$FF,$FF);
 var
   ISES : ipSessionREC;
   I : Integer;

   DebugF: text;
   TmpSeg: Word;
   TmpOff: Word;
   ToDisLength:Word;
   wCount:Word;
   TmpStr:String;
   TmpHex:String;
   TmpByte:Byte;

 begin
   ReceiveICMP:=False;
   Result:=ip_Open(ISES, 0, NullAddr, 1);
   if Result<>0 then Write('[ERR:ip_Open:NullAddr,1]');

   If ip_Recv(ISES, 0, timeout)=0 then
     begin
         Writeln('[ICMP:Rcvd]');
                        ReceiveICMP:=True;
                        Assign(DebugF, 'ICMP.DBG');
                        ReWrite(DebugF);
                        If ISES.Buffer.Length>0 then
                          begin

                             Writeln(debugf,#13+#10);
                                  TmpSeg:=Seg(ISES.Buffer.Buffer);
                                  TmpOff:=Ofs(ISES.Buffer.Buffer);
                                  ToDisLength:=ISES.Buffer.Length;
                                  wCount:=0;
                                   TmpStr:='';
                                   TmpHex:='';
                                  repeat
                                   if ((wCount/8)=Trunc(wCount/8)) then Write(Debugf,' ');
                                   if ((wCount/16)=Trunc(wCount/16)) then
                                     begin
                                      Writeln(Debugf, ' '+TmpStr); TmpStr:=''; TmpHex:='';
                                      Write(Debugf, WordToHexASCII(wCount),': ');
                                     end;
                                   TmpByte:=Mem[TmpSeg:TmpOff+wCount];
                                   Write(Debugf, ByteToHexASCII(TmpByte)+' ');
                                   TmpStr:=TmpStr+Chr(CleanChr[TmpByte]);
                                  inc(wCount);
                                  until wCount=ToDisLength;
                                   Writeln(debugf, ' '+TmpStr);
                          end;
                        Close(DebugF);
         Writeln;
         Result:=ip_status(ISES,0);
         GlobalICMP.SourceAddr := ISES.Status.IP_SRCE;
         Writeln('Protocol from ip_status = ',ISES.Status.ip_prot);
         GlobalICMP.DestAddr := ISES.Status.IP_DEST;
         GlobalICMP.Handle:=ISES.Handle;
{   AddBuffer(ISES.Buffer, 0, #8+  #0+  #0+#0+ #$13+#$13+ }
         GlobalICMP.ICMPType:=Ord(ISES.Buffer.Buffer[1]);                                    {*1* changes}
         GlobalICMP.Code:=Ord(ISES.Buffer.Buffer[2]);                                        {*1* changes}
         GlobalICMP.ChkSum:=Ord(ISES.Buffer.Buffer[3])*256+Ord(ISES.Buffer.Buffer[4]);       {*1* changes}
         GlobalICMP.NextOne:=Ord(ISES.Buffer.Buffer[5])*256+Ord(ISES.Buffer.Buffer[6]);      {*1* changes}
         GlobalICMP.NextTwo:=Ord(ISES.Buffer.Buffer[7])*256+Ord(ISES.Buffer.Buffer[8]);      {*1* changes}
         {GlobalICMP.OrigTimeStamp:=}
         {GlobalICMP.RecvTimeStamp:=}
         {GlobalICMP.TransTimeStamp:=}
         GlobalICMP.Valid:=true;
         Writeln('Packet Information: ');
         Writeln('     From: ',IPTOASCII(GlobalICMP.SourceAddr));
         Writeln('     To  : ',IPTOASCII(GlobalICMP.DestAddr));
         case GlobalICMP.ICMPType of
           ICMPT_DUM : Writeln('      - Destination Unreachable: '+icmpDUM[GlobalICMP.Code]);
           ICMPT_TEM : Writeln('      - Time Exceeded Messages : '+icmpTEM[GlobalICMP.Code]);
           ICMPT_PPM : Writeln('      - Parameter Problem Msg. : '+icmpPPM[GlobalICMP.Code]);
           ICMPT_RM  : Writeln('      - Redirect Message       : '+icmpRM[GlobalICMP.Code]);
           ICMPT_SQM : Writeln('      - Source Quench Message');
           ICMPT_ECHO: Writeln('      - Echo Request Message ');
           ICMPT_ECHOREPLY: Writeln('     - Echo Reply Message');
           ICMPT_TS  : Writeln('      - TimeStamp Message');
           ICMPT_TSR : Writeln('      - TimeStamp Reply Message');
           ICMPT_IREQ  : Writeln('      - Information Request Message');
           ICMPT_IREPLY: Writeln('      - Information Reply Message');
          else
           Writeln('Unknown type 0x'+ByteToHexASCII(GlobalICMP.ICMPType));
          end;

     end;

   Result:=ip_Close(ISES, 0);
   if Result<>0 then Write('[ERR:ip_Close]');
 end;





BEGIN
  Writeln('Running experimental ICMP unit for use with Trumpet ABI for DOS');
  ICMPverbose:=true;


END.  (C) 1997 by Jeff Patterson

