unit QzHtmlDialog2;
{*********************************************************}
{*                    QzHTMLEditor.pas                   *}
{*                  Quick Zip HTML Editor                *}
{*     Copyright (c) 2003 Joseph Leung Yat Chun          *}
{*                 All rights reserved.                  *}
{*********************************************************}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ToolWin, ExtCtrls, QzMiniHtml2, ImgList,
  QzHtmlLabel2, ExtDlgs;

type

TQzHtmlDialog2 = class(TComponent)
                 private
                 htmlinput : string;
                 public
                 Hotkey : char;
                 Left,Top : integer;
                 fmWidth : integer;
                 fmTitle : string;
                 function Execute : boolean;
                 constructor Create(AOwner : TComponent); override;
                 published
                 property Html : string read htmlinput write htmlinput;
                 property Width : integer read fmWidth write fmWidth;
                 property Title : string read fmTitle write fmTitle;
                 end;

procedure Register;
var showingtext : string;
implementation

constructor TQzHtmlDialog2.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  fmWidth := 200;
end;

function TQzHtmlDialog2.Execute : boolean;
var Form1 : TForm;
    HtmlLabel : TQzHtmlLabel2;
    Panel1 : TPanel;
    bOK,bCancel : TButton; 
begin
  Result := False;
  Form1 := TForm.create(Self);
  with Form1 do
  try
    //AutoSize := true;
    BorderStyle := bsDialog;
    Caption := Title;

    HtmlLabel := TQzHtmlLabel2.Create(Form1);
    HtmlLabel.Parent := Form1;
    HtmlLabel.Left := 0;
    HtmlLabel.Top := 0;
    HtmlLabel.Width := Width;
    HtmlLabel.AutoHeight := true;
    HtmlLabel.Html := Html;
    HtmlLabel.Align := alClient;

    Form1.Refresh;
    
    Panel1 := TPanel.Create(Form1);
    Panel1.Parent := Form1;
    Panel1.align := alBottom;
    Panel1.Height := 30;

    bOK := TButton.Create(Panel1);
    bOK.Parent := Panel1;
    bOK.Top := 2;
    bOK.Caption := 'Ok';
    bOk.Left := Width - 10 - bOk.Width;
    bOK.ModalResult := mrOK;

    bCancel := TButton.Create(Panel1);
    bCancel.Parent := Panel1;
    bCancel.Top := 2;
    bCancel.Caption := 'Cancel';
    bCancel.Left := Width - bOk.Width  - bCancel.Width - 20;
    bCancel.ModalResult := mrCancel;

    Position := poScreenCenter;
    Showmodal;
  finally
    Free;
  end;

end;

procedure Register;
begin
  RegisterComponents('QZip', [TQzHtmlDialog2]);
end;

end.
