#!/usr/bin/perl

###############################################################################
#
# ClassDef.pl - an include file for perl...
#
# AUTHOR:	Shawn Stepper, wiTHinc Inc.
# AUTHOR:	George Toye, wiTHinc Inc.
# DATE:		$Date: 2001/08/21 17:50:51 $ (last modified)
# COPYRIGHT:	1998, 1999, 2000, 2001 wiTHinc Inc. All Rights Reserved.
#
###############################################################################

$FileRevision = '$Id: ClassDef.pl,v 1.32.2.3 2001/08/21 17:50:51 stepper Exp $';
$Version = '1.4.0';

if (@ARGV[0] eq "-v" || @ARGV[0] eq "--version") {
	print "File:		$0\n";
	print "Revision:	$FileRevision\n";
	print "Version:	$Version\n";
	exit();
}

1;

###################################
#
# Lookup Class Information
#
###################################

sub lookupClass {
	local($cl) = @_;
	local($found, $junk, $DB_Key, @DB_Data, $DB_Data, $k, $index);
	
	if ($cl eq "") { $cl = $Class;}
	
	if ($cl eq "") {
		@getclass = split("/", $CGIEnvScript);
		$index = @getclass - 3;
		$cl = @getclass[$index];
	}

	$dbfile = $DBFILE_CLASSID;
	if (! -e $dbfile) {
		return(0);
	}
	
	($retval, $C_rootpath) = split(/\t/, `$prtDB $dbfile -thash -k "$cl"`);
	$status = &dbErrorCheck($?, $retval);
	if ($status) {
		return(0);
	}

	chomp($C_rootpath);
	$C_rootpath =~ s/\/$//;
	
	$dbfile = "$C_rootpath" . "/" . $DIR_CONFIG . "/" .$DBFILE_CLASSINFO;
	
	if (! -e $dbfile) {
		return(0);
	}
	
	# Defaults for Pagination
	$C_TopicsPage = 0;
	$C_TopicsPageNov = 20;
	$C_ThreadsPage = 10;
	$C_ThreadsPageNov = 20;
	$C_ContentPage = 0;
	$C_ContentPageAuto = 0;
	$C_NewPage = 10;
	$C_AuthorsPage = 10;
	
	$C_Disable = 0;
	
	# This loads all of the data from the class database into variables.
	# The variable name is the key. so a key of C_title with a value of
	# "some title" gives a variable called $C_title with a value = "some title"
	foreach (`$prtDB $dbfile -thash -a`) {
		$value = $_;
		$status = &dbErrorCheck($?, $value);
		if ($status) {
			return(0);
		}
	
		($DB_Key, @DB_Data) = split(/\t/, $value);
		$DB_Data = join("\t", @DB_Data);
		chomp($DB_Data);
		eval "\$$DB_Key=\"$DB_Data\";";
	}
	
	# Handle exceptions
	# Set Colorstring
	$ColorQueryString = $C_colors;
	
	# Load section variables
	for ($k=1; $k <= $C_Sect_n; $k++) {
		eval "\$stmp = \$C_Sect_$k;";
		@sectinfo = split(/\t/, $stmp);
		$C_Sects{$k}{"num"} = @sectinfo[0];
		$C_Sects{$k}{"name"} = @sectinfo[1];
		$C_Sects{$k}{"fac"} = @sectinfo[2];
		$C_Sects{$k}{"time"} = @sectinfo[3];
		$C_Sects{$k}{"location"} = @sectinfo[4];
		$C_Sects{$k}{"email"} = @sectinfo[5];
	}
	
	# Load faculty variables
	for ($k=1; $k <= $C_Fac_n; $k++) {
		eval "\$stmp = \$C_Fac_$k;";
		@facinfo = split(/\t/, $stmp);
		$C_Sects{$k}{"login"} = @facinfo[0];
		$C_Sects{$k}{"firstname"} = @facinfo[1];
		$C_Sects{$k}{"lastname"} = @facinfo[2];
		$C_Sects{$k}{"prefname"} = @facinfo[3];
		$C_Sects{$k}{"officehours"} = @facinfo[4];
	}
	
	if ($C_authtype eq "") {
		$C_authtype = "webauth and apache";
	}
	
	if ($C_photodir eq "") {
		$C_photodir = "Photo/";
	}
	if ($C_photodir !~ /\/$/) {
		$C_photodir .= "/";
	}

	if ((!$isWin && $C_photodir !~ /^\//) || ($isWin && $C_photodir !~ /^\w\:/ && $C_photodir !~ /^\//)) {
		$C_photodir = $C_rootpath . "/" . $C_photodir;
	}
	
	if ($C_photourl eq "") {
		$C_photourl = "Photo/";
	}
	if ($C_photourl !~ /\/$/) {
		$C_photourl .= "/";
	}
	if ($C_photourl !~ /^\//) {
		$C_photourl = $C_rooturl . "/" . $C_photourl;
	}

	if ($C_listdir=~ /\/$/) {
		chop($C_listdir);
	}
	
	if ($C_listdir eq "") {
		$C_listdir = "/web/Admin/MailingLists";
	}
	
	return(1);
}

sub lookupFacList {
	local(@return) = &lookupFacAdminList("fac");
	return(@return);
}

sub lookupAdminList {
	local(@return) = &lookupFacAdminList("admin");
	return(@return);
}

sub lookupFacAdminList {
	local($what) = @_;
	local($status, $dbfile, $ju, $fn, $ln, $pn);
	local($DB_Key, $DB_Data, @DB_Data, @junk);

	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_USERINFO;
	
	if (! -e $dbfile) {
		return("");
	}
	
	foreach (`$prtDB $dbfile -thash -a`) {
		($DB_Key, $ju, $ju, $fn, $ln, $pn, $ju, $ju, $getperm, @junk) = split(/\t/, $_);
		
		$status = &dbErrorCheck($?, $DB_Key);
		if ($status) {
			return("");
		}
		
		if ($pn ne "") {
			$fn = $pn;
		}
		if (($what eq "fac" && &IS_FAC($getperm))
				|| ($what eq "admin" && &IS_ADMIN($getperm))
				|| ($what eq "" && (&IS_FAC($getperm) || &IS_ADMIN($getperm)))){
			push(@thefaclist, "$ln, $fn ($DB_Key)");
		}
	}

	@thefaclist = sort(@thefaclist);

	return(@thefaclist);
}

sub lookupSubjList {
	local($dbfile, $DB_Key, @DB_Data, $status);
	$dbfile = $C_rootpath . "/". $DIR_CLASSFORUM . "/" . $DBFILE_FSUBJ;
	
	if (! -e $dbfile) {
		return("");
	}
	
	foreach (`$prtDB $dbfile -tbtree -a`) {
		($DB_Key, @DB_Data) = split(/\t/, $_);
		
		$status = &dbErrorCheck($?, $DB_Key);
		if ($status) {
			return("");
		}
		
		push(@mastersublist, $DB_Key);
	}
	
	return(@mastersublist);
}

sub lookupClassList {
	local($i, @input, $DB_Key, $DB_Data);

	$dbfile = $DBFILE_CLASSID;
	if (! -e $dbfile) {
		return("");
	}
	
	foreach (`$prtDB $dbfile -thash -a`) {
		($DB_Key, $DB_Data) = split(/\t/, $_);
		
		$status = &dbErrorCheck($?, $DB_Key);
		if ($status) {
			return("");
		}
		
		push(@masterclasslist, $DB_Key);
	}
	
	@masterclasslist = sort(@masterclasslist);
	return(@masterclasslist);
}

###################################
#
# Look Up User
#
###################################

sub lookupUser {
	local($subuser, $noErrorOutput) = @_;
	local($value, $dbfile, $junk, $found);
	
	$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_USERINFO;
	
	if (! -e $dbfile) {
		return(1);
	}
	
	if ($subuser eq "" && $CGIEnvUser eq "") {
		if (! $noErrorOutput) {
			&invalidUser();
		}
		return(1);
	}

	$DB_Key = $CGIEnvUser;
	if ($subuser ne "") {
		$DB_Key = $subuser;
	}
	
	($retval, $U_SUID, $U_Pass, $U_NameFirst, $U_NameLast, $U_NamePref, $U_Email, $U_Phone, $U_Perms, $U_C_Sect, $U_Photo, $U_Classify, $U_ProfileText, $U_Sig, $U_HideEmail) = split(/\t/, `$prtDB $dbfile -thash -k "$DB_Key"`);
	
	if (&dbErrorCheck($?, $retval) || $retval eq "") {
		return(1);
	}
	
	chomp($U_HideEmail);
	
	chomp($U_ProfileText);
	if ($U_ProfileText eq "") {
		$U_ProfileText = "No Personal Information Provided";
	}
	
	if ($U_NamePref eq "") {
		$U_NamePref = $U_NameFirst;
	}
	
	$fullname = $U_NamePref . " " . $U_NameLast;
	
	if ($U_HideEmail !~ /^1/) {
		$U_HideEmail = 0;
	} else {
		$U_HideEmail = 1;
	}
	
	&procUserPhoto;

	$UserDataString = "$U_SUID\t$U_Pass\t$U_NameFirst\t$U_NameLast\t$U_NamePref\t$U_Email\t$U_Phone\t$U_Perms\t$U_C_Sect\t$U_Photo,$U_PhotoLarge\t$U_Classify\t$U_ProfileText\t$U_sig\t$U_HideEmail";
	
	return(0);
}

sub invalidUser {
	# The user was not found, or was not properly logged in
	&showErrorHTML("You are not properly logged in, or are not in the database of users.");
	exit();

}

sub procUserPhoto {
	# Process single/multiple photos
	if ($U_Photo eq "") {
		$U_Photo = "Guest.gif";
	}
	
	if ($U_Photo =~ /\,/) {
		($U_Photo, $U_PhotoLarge) = split(/\,/, $U_Photo);
	} elsif ($U_PhotoLarge eq "") {
		$U_PhotoLarge = $U_Photo;
		$U_PhotoLarge =~ s/\.gif$/\.jpg/i;
	}
	
	# Let's keep photos as reltive urls, relative to photo directory
	
	if ($U_Photo !~ /^\//) {
		if ($U_Photo =~ /^Photo\//) {
			$U_Photo =~ s/^Photo\//$C_photourl/;
		} else {
			$U_Photo = $C_photourl . $U_Photo;
		}
	}
	if ($U_PhotoLarge !~ /^\//) {
		if ($U_PhotoLarge =~ /^Photo\//) {
			$U_PhotoLarge =~ s/^Photo\//$C_photourl/;
		} else {
			$U_PhotoLarge = $C_photourl . $U_PhotoLarge;
		}
	}
	
	# Get just the relative names of the photos
	$U_PhotoName = $U_Photo;
	$U_PhotoName =~ s/^$C_photourl//;
	$U_PhotoNameLarge = $U_PhotoLarge;
	$U_PhotoNameLarge =~ s/^$C_photourl//;

}

# See if this is a cookie based forum, and if the user is guest.
sub checkCookieGuest {
	local($User, $authtype) = @_;
	if ($authtype =~ /cookie/i && $User eq "Guest") {
		# Let the user log in
		local($redir) = $CGI_ForumCookieLogin . "?fid=" . $Class;
		$redir .= "&nexturl=" . escape($ENV{'SCRIPT_NAME'} . "?" . $ENV{'QUERY_STRING'});
		print $CGIQuery->redirect($redir);
		exit();
	} else {
		return 0;
	}
	return 0;
}

###################################
#
# Color Handling
#
###################################

sub lookupColors {
	local($ColorScheme) = @_;
	local($ColorQueryString, $ind, $key, $value, $dbfile, @ALLCOLORS);
	
	if ((! -e $DBFILE_COLORS) && -e $DBFILE_COLORS_SRC) {
		$retval = `$setHashDB $DBFILE_COLORS < $DBFILE_COLORS_SRC`;
	}
	
	if ($C_rootpath ne "" && -e $C_rootpath . "/" . $DIR_CONFIG) {
		if (! -e $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_COLORS && -e $DBFILE_COLORS_SRC) {
			$retval = `$setHashDB $C_rootpath/$DIR_CONFIG/$DBFILE_COLORS < $DBFILE_COLORS_SRC`;
		}
	}

	if (-e $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_COLORS) {
		local($junk);
		($junk, $ColorQueryString) = split(/\t/, `$prtDB $C_rootpath/$DIR_CONFIG/$DBFILE_COLORS -thash -k "$ColorScheme"`);
		chomp($ColorQueryString);
	} elsif (-e $DBFILE_COLORS) {
		local($junk);
		($junk, $ColorQueryString) = split(/\t/, `$prtDB $DBFILE_COLORS -thash -k "$ColorScheme"`);
		chomp($ColorQueryString);
	}
	
	if ($ColorQueryString eq "") {
		# No colors.db and no colors.src. Bummer. Hardcode panfora color scheme
		$ColorQueryString = "FSHB=#000000&FSLB=#dcdcdc&FSHT=#FFFFFF&FSLT=#000000&FSLD=#907d7d&FSL=#213bdb&FTHB=#c0c0c0&FTST=#e31616&FTLB=#dcdcdc&FTHT=#000000&FTLT=#000000&FTLD=#907d7d&FTL=#213bdb&FTH=#e31616&FCHB=#E33131&FCLB=#FFFFFF&FCHT=#FFFFFF&FCLT=#000000&FCL=#213bdb&FCMHH=#FFFF99&FCMBH=#FFFFCC&F_SH=#A4A4A4&F_FH=#2AA332&scheme=1&schemename=panFora";
	}
	
	
	return($ColorQueryString);
}

sub lookupColorSchemes {
	local($ColorQueryString, $name, $cq, $DB_Key, $DB_Value);
	local($dbfile);
	
	if ((! -e $DBFILE_COLORS) && (! -e $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_COLORS)) {
		return("");
	}
	
	if (-e $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_COLORS) {
		$dbfile = $C_rootpath . "/" . $DIR_CONFIG . "/" . $DBFILE_COLORS;
	} else {
		$dbfile = $DBFILE_COLORS;
	}
	
	foreach (`$prtDB $dbfile -thash -a`) {
		($DB_Key, $DB_Data) = split(/\t/, $_);
		chomp($DB_Data);
		
		$cq = new CGI($DB_Data);
		$name = $cq->param('schemename');
		
		push(@allschemenames, $name);
		push(@allschemenums, $DB_Key);
		$cscheme{"$name"} = $DB_Key;
	}
	return(%cscheme);
}

sub loadColors {
	local($ColorQueryStringLocal) = @_;
	
	if ($ColorQueryStringLocal eq "") {
		$ColorQueryStringLocal = $ColorQueryString;
	}
	
	local($CGIColors) = new CGI($ColorQueryStringLocal);

	# Subjects view
	$FSheaderback = $CGIColors->param('FSHB');
	$FSheadertext = $CGIColors->param('FSHT');
	$FSbg = $CGIColors->param('FSLB');
	$FStext = $CGIColors->param('FSLT');
	$FSdate = $CGIColors->param('FSLD');
	$FSlink = $CGIColors->param('FSL');
	$FSvlink = $CGIColors->param('FSVL');
	$FSbgimage = $CGIColors->param('FSBI');
	
	# Threads view
	$FTheaderback = $CGIColors->param('FTHB');
	$FTheadertext = $CGIColors->param('FTHT');
	$FTseltopic = $CGIColors->param('FTST');
	$FTbg = $CGIColors->param('FTLB');
	$FTtext = $CGIColors->param('FTLT');
	$FTdate = $CGIColors->param('FTLD');
	$FTlink = $CGIColors->param('FTL');
	$FTvlink = $CGIColors->param('FTVL');
	$FTbgimage = $CGIColors->param('FTBI');
	
	# Content view
	$FCheaderback = $CGIColors->param('FCHB');
	$FCheadertext = $CGIColors->param('FCHT');
	$FCbg = $CGIColors->param('FCLB');
	$FCtext = $CGIColors->param('FCLT');
	$FCdate = $CGIColors->param('FCLD');
	$FClink = $CGIColors->param('FCL');
	$FCvlink = $CGIColors->param('FCVL');
	$FCbgimage = $CGIColors->param('FCBI');
	
	$FCmsgheadhilight = $CGIColors->param('FCMHH');
	$FCmsghilight = $CGIColors->param('FCMBH');
	
	$Fstudenthilight = $CGIColors->param('F_SH');
	$Ffacultyhilight = $CGIColors->param('F_FH');
	
	$ColorScheme = $CGIColors->param('scheme');
	$ColorSchemename = $CGIColors->param('schemename');
	
	if ($FTseltopic eq "") {
		$FTseltopic = "#e31616";
	}
}
