// =================================================================
//
//  Copyright (C) 2003 Alex Vinokur
//
//  For conditions of distribution and use, see
//  copyright notice in common.h
//
// =================================================================


// #################################################################
//
//  SOFTWARE : C++ Stream-Compatible TCP/IP Sockets Demo Application
//  FILE     : partner.cpp
//
//  DESCRIPTION :
//         Partner related class implementation 
//         (non-template methods)
//
// #################################################################


// ==================
#include "partner2.h"
// ==================


// ---------------------
// ---------------------
BasicCallAction::BasicCallAction ()
{
SET_CTOR_TRACE;
}

// ---------------------
BasicCallAction::~BasicCallAction ()
{
SET_DTOR_TRACE;
}


// ---------------------
// ---------------------
// Constructor-1
BasicPartner::BasicPartner (
		const string& partner_name_i, 
		int ip_port_no_i
		)
		:
		call_action_ (call_action_s),
		partner_name_ (partner_name_i),		 
		pre_check_ (true),		 
		ip_port_no_ (ip_port_no_i),		 
		total_sent_packets_ (0),
		total_recv_packets_ (0),
		local_sent_packets_ (0),
		local_recv_packets_ (0),
		cur_request_id_ (0),
		prev_request_id_ (0)
{
SET_CTOR_TRACE;

time_t timer;
        timer   = time(NULL);

  assert (!call_action_.empty());

  assert ((get_partner_name() == CLIENT_NAME) || (get_partner_name() == SERVER_NAME));

ostringstream oss, oss2;
  oss << get_partner_name() << " ---> Start Of Session";


  oss2 << endl;
  oss2 << "\t" << string (oss.str().size(), '#') << endl;
  oss2 << "\t" << oss.str() << endl;
  oss2 << "\t" << asctime (localtime(&timer));
  oss2 << "\t" << string (oss.str().size(), '#') << endl;
  oss2 << endl;

  cout << oss2.str();

#ifdef SCREEN_LOG
#if (SCREEN_LOG)
  cerr << oss2.str();
#endif
#endif

  assert (pre_check_);
  pre_check_ = pre_check_ && check_ip_port_no ();
  assert (pre_check_);


}

// ---------------------
// Destructor
BasicPartner::~BasicPartner ()
{
SET_DTOR_TRACE;
ostringstream oss, oss2;

time_t timer;
        timer   = time(NULL);

  oss << get_partner_name() << " ---> End Of Session";

  oss2 << endl;
  oss2 << "\t" << string (oss.str().size(), '#') << endl;
  oss2 << "\t" << oss.str() << endl;
  oss2 << "\t" << asctime (localtime(&timer));
  oss2 << "\t" << string (oss.str().size(), '#') << endl;
  oss2 << endl;

  cout << oss2.str();

#ifdef SCREEN_LOG
#if (SCREEN_LOG)
  cerr << oss2.str();
#endif
#endif

}


// ---------------------
bool BasicPartner::check_ip_port_no () const
{
SET_TRACE;
  return true; // TBD
}



// ---------------------
int BasicPartner::get_ip_port_no () const
{
SET_TRACE;
  return ip_port_no_;
}

// ---------------------
string BasicPartner::get_partner_name () const
{
  return partner_name_;
}



// ----------------------------------
bool BasicPartner::recv_packet_head (
			ulong&  request_id_o,
			string& packet_typename_o, 
			size_t& packet_size_o
			)
{
SET_TRACE;

bool ret_bool = true;


  // ----------------------
  ret_bool = ret_bool && read_via_broker_from_stream (request_id_o, "[Request-Id]");
  if (!ret_bool)
  {
    MOUT (  get_partner_name() 
         << " * " 
         << " Unable to get Request-Id" 
         << endl
         );

    return ret_bool;
  }
  if (is_end_of_session (request_id_o)) return ret_bool;


  // ----------------------
  ret_bool = ret_bool && read_via_broker_from_stream (packet_typename_o, "[Packet Typename]");
  if (!ret_bool)
  {
    MOUT (  get_partner_name() 
         << " * " 
         << " Unable to get Packet Typename" 
         << endl
         );

    return ret_bool;
  }


  // ----------------------
  ret_bool = ret_bool && read_via_broker_from_stream (packet_size_o, "[Packet Size]");
  if (!ret_bool)
  {
    MOUT (  get_partner_name() 
         << " * " 
         << " Unable to get Packet Size" 
         << endl
         );

    return ret_bool;
  }

  return ret_bool;

}



// ----------------------------------
bool BasicPartner::send_relevant_packet (const BasicDataType*& packet_i)
{
SET_TRACE;

  set_local_sent_packets ();
  prev_request_id_ = cur_request_id_;

  total_sent_packets_++;
  local_sent_packets_++;

  show_outcoming_packet (packet_i);

  assert (!call_action_.empty());
  assert (call_action_.count(packet_i->get_typeid_data_type()) == 1);

const map<string, BasicCallAction*>::const_iterator find_iter = call_action_.find (packet_i->get_typeid_data_type());
  assert (find_iter != call_action_.end());

bool ret_bool = find_iter->second->call_send_templated_packet(this, packet_i);

  return ret_bool;

}


// ----------------------------------
bool BasicPartner::recv_relevant_packet (BasicDataType*& packet_o)
{
SET_TRACE;

  total_recv_packets_++;

  assert (packet_o == NULL);

  assert (!call_action_.empty());

ulong  request_id;
string packet_typename;
size_t packet_size;

bool ret_bool = false;

  if (recv_packet_head (request_id, packet_typename, packet_size))
  {
    set_request_id (request_id);

    set_local_recv_packets ();

    local_recv_packets_++;

    if (!is_end_of_session ())
    {
      assert (packet_size != 0);
      assert (call_action_.count(packet_typename) == 1);

      const map<string, BasicCallAction*>::const_iterator find_iter = call_action_.find (packet_typename);
      assert (find_iter != call_action_.end());

      ret_bool = find_iter->second->call_recv_templated_packet(
					this, 
					request_id, 
					packet_typename, 
					packet_size, 
					packet_o
					);

      if (ret_bool) 
      {
        const BasicDataType* ptr_packet = packet_o;
        show_incoming_packet (ptr_packet);
      }
    }
  }
  else
  {
    MOUT (  get_partner_name() 
         << " * " 
         << " Unable to get Packet header" 
         << endl
         );
    // ret_bool == false  !!!
  }

  return ret_bool;

} // recv_relevant_packet


				
// ----------------------------------
ulong BasicPartner::get_total_sent_packets () const
{
SET_TRACE;
  return total_sent_packets_;
}

				
// ----------------------------------
ulong BasicPartner::get_total_recv_packets () const
{
SET_TRACE;
  return total_recv_packets_;
}

				
// ----------------------------------
ulong BasicPartner::get_request_id () const
{
SET_TRACE;
  return cur_request_id_;
}

				
// ----------------------------------
void BasicPartner::set_request_id (ulong request_id_i)
{
SET_TRACE;
  cur_request_id_ = request_id_i;
}

// ----------------------------------
bool BasicPartner::is_end_of_session (ulong request_id_i) const
{
SET_TRACE;
  return (request_id_i == END_OF_SESSION_ID);
}


// ----------------------------------
bool BasicPartner::is_end_of_session () const
{
SET_TRACE;
  return (cur_request_id_ == END_OF_SESSION_ID);
}


// ----------------------------------
void BasicPartner::show_outcoming_packet (const BasicDataType*& packet_i) const
{
SET_TRACE;
ostringstream oss;
vector<string> msg;

  oss << get_partner_name() 
      << " : "
      << get_outcoming_packet_desr()
      << "Id-"
      << cur_request_id_
      << " ("
      << local_sent_packets_
      << ") ; SerialSentPacketNo = " 
      << total_sent_packets_;

  msg.push_back (oss.str());
  oss.str("");

  oss << "peer   : "
      << get_peer_name() 
      << " IP Address = " 
      << get_peer_ip_address();
  msg.push_back (oss.str());

  packet_i->show_packet (msg, '=');

}



// ----------------------------------
void BasicPartner::show_incoming_packet (const BasicDataType*& packet_i) const
{
SET_TRACE;
ostringstream oss;
vector<string> msg;

  oss << get_partner_name() 
      << " : "
      << get_incoming_packet_desr()
      << "Id-"
      << cur_request_id_
      << " ("
      << local_recv_packets_
      << ") ; SerialRecvPacketNo = " 
      << total_recv_packets_;

  msg.push_back (oss.str());
  oss.str("");

  oss << "peer   : "
      << get_peer_name() 
      << " IP Address = " 
      << get_peer_ip_address();
  msg.push_back (oss.str());
  
  packet_i->show_packet (msg, '-');

}






