// ==============================================================
//
//  Copyright (c) 2002-2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : t_stub.cpp
//
//  DESCRIPTION :
//         Implementation of measured/compared functions
//
// ##############################################################


// ===============
#include "tests.h"
// ===============


// #########################################
// -------------------------------------------
#define SIZE0	20
#define SIZE1	200
#define SIZE2	2000

#define NUMBER_OF_TEST_SIZES	3
static const size_t t_asizet[] = {SIZE0, SIZE1, SIZE2};
static vector<size_t> t_vsizet (t_asizet, t_asizet + NUMBER_OF_TEST_SIZES);
// -------------------------------------------



// -------------------------------------------
#define CSTR0	"0123456789"
#define CSTR1	"0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789"
#define CSTR2	"0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789"

static const size_t max_cstr_size = string(CSTR2).size();

#define NUMBER_OF_TESt_stubS	3
static const char* t_acstr[] = {CSTR0, CSTR1, CSTR2};
static vector<string> t_vstr (t_acstr, t_acstr + NUMBER_OF_TESt_stubS);
// -------------------------------------------


// #########################################
// -----------
#define return_t	void	// sample
#define arg_t1		int	// sample
#define arg_t2		string	// sample


// -----------
static return_t stub_foo1__size_independent (arg_t1 /* arg_i; */) 
{ 
  // Stuff
  // Do something
}

// -----------
static return_t stub_foo2__size_independent (arg_t1 /* arg_i; */) 
{ 
  // Stuff
  // Do something
}

// -----------
static return_t stub_foo3__size_dependent (arg_t1 /* arg_i; */) 
{ 
  // Stuff
  // Do something
}

// -----------
static return_t stub_foo4__size_dependent (arg_t1 /* arg_i; */) 
{ 
  // Stuff
  // Do something
}


// -----------
static return_t stub_foo5__size_dependent (arg_t2 /* arg_i; */) 
{ 
  // Stuff
  // Do something
}


// -----------
static return_t stub_foo6__size_dependent (arg_t2 /* arg_i; */) 
{ 
  // Stuff
  // Do something
}

// -----------
static return_t stub_foo7__size_independent (arg_t1 /* arg_i; */) 
{ 
  // Stuff
  // Do something
}

// -----------
static return_t stub_foo8__size_dependent (arg_t1 /* arg_i; */) 
{ 
  // Stuff
  // Do something
}


// -----------
static return_t stub_foo9__size_dependent (arg_t2 /* arg_i; */) 
{ 
  // Stuff
  // Do something
}



// #########################################
// #
// #  Functions To Be Measured (Compared)
// #  Prototypes are in file tests.h
// #
// #########################################


// =============================
void stub_action1 (void)
{
const string htext__tested_foo1  ("foo1 description");
const string htext__tested_foo2  ("foo2 description");
const string htext__tested_foo3  ("foo3 description");
const string htext__tested_foo4  ("foo4 description");
const string htext__tested_foo5  ("foo5 description");
const string htext__tested_foo6  ("foo6 description");

  // -------------------------------
const arg_t1	 val_a = 12345; 
  {
    TURN_ON_DEFAULT_TIMER (htext__tested_foo1, "No") 
    {
      stub_foo1__size_independent (val_a);
    }
  }


  {
    TURN_ON_DEFAULT_TIMER (htext__tested_foo2, "No") 
    {
      stub_foo2__size_independent (val_a);
    }
  }


  // -------------------------------------
  for (size_t i = 0; i < t_vsizet.size(); i++)
  {
    const size_t	cur_size (t_vsizet[i]);
    const arg_t1	val_b = cur_size/2; 	// sample

    {
      TURN_ON_DEFAULT_TIMER (htext__tested_foo3, cur_size) 
      {
        stub_foo3__size_dependent (val_b);
      }
    }

    {
      TURN_ON_DEFAULT_TIMER (htext__tested_foo4, cur_size) 
      {
        stub_foo4__size_dependent (val_b);
      }
    }

  } // for (size_t i = 0; i < t_vsizet.size(); i++)


  // -------------------------------------
  for (size_t i = 0; i < t_vstr.size(); i++) 
  {
    string str			(t_vstr[i]);
    const size_t str_size	= str.size();

    {
      TURN_ON_DEFAULT_TIMER (htext__tested_foo5, str_size) 
      {
        stub_foo5__size_dependent (str);
      }
    }

    {
      TURN_ON_DEFAULT_TIMER (htext__tested_foo6, str_size) 
      {
        stub_foo6__size_dependent (str);
      }
    }


  } // for (size_t i = 0; i < t_vstr.size(); i++)


} // stub_action1


// =============================
void stub_action2 (void)
{
const string htext__tested_foo7  ("foo7 description");
const string htext__tested_foo8  ("foo8 description");
const string htext__tested_foo9  ("foo9 description");

  // -------------------------------
const arg_t1	 val_a = 12345; 
  {
    TURN_ON_DEFAULT_TIMER (htext__tested_foo7, "No") 
    {
      stub_foo7__size_independent (val_a);
    }
  }

  // -------------------------------------
  for (size_t i = 0; i < t_vsizet.size(); i++)
  {
    const size_t	cur_size (t_vsizet[i]);
    const arg_t1	val_b = cur_size/2; 	// sample

    {
      TURN_ON_DEFAULT_TIMER (htext__tested_foo8, cur_size) 
      {
        stub_foo8__size_dependent (val_b);
      }
    }

  } // for (size_t i = 0; i < t_vsizet.size(); i++)


  // -------------------------------------
  for (size_t i = 0; i < t_vstr.size(); i++) 
  {
    string str			(t_vstr[i]);
    const size_t str_size	= str.size();

    {
      TURN_ON_DEFAULT_TIMER (htext__tested_foo9, str_size) 
      {
        stub_foo9__size_dependent (str);
      }
    }

  } // for (size_t i = 0; i < t_vstr.size(); i++)


} // stub_action2



///////////////
// End-Of-File
///////////////

