// ==============================================================
//
//  Copyright (c) 2002-2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : t_find.cpp
//
//  DESCRIPTION :
//         Implementation of measured/compared functions
//
// ##############################################################


// ===============
#include "tests.h"
#include <list>
// ===============


// #########################################
#define SIZE0	10
#define SIZE1	100
#define SIZE2	1000

// -------------------------------------------
#define NUMBER_OF_TEST_SIZES	3
static const size_t t_asizet[] = {SIZE0, SIZE1, SIZE2};
static vector<size_t> t_vsizet (t_asizet, t_asizet + NUMBER_OF_TEST_SIZES);
// -------------------------------------------


// #########################################
// #
// #  Functions To Be Measured (Compared)
// #  Prototypes are in file tests.h
// #
// #########################################




// =============================
void find_action (void)
{
const string dummy_str ("ABCDEF");

const string htext__find_algorithm_vector      ("find algorithm - vector");
const string htext__find_algorithm_list        ("find algorithm - list  ");
const string htext__find_algorithm_set         ("find algorithm - set   ");
const string htext__find_method_set            ("find method    - set   ");
const string htext__find_method_map            ("find method    - map   ");

  // -------------------------------
  for (size_t i = 0; i < t_vsizet.size(); i++)
  {
    const size_t cur_size (t_vsizet[i]);
    const int median_value = static_cast<int>(cur_size/2);

    vector<int>      int_vector;
    list<int>        int_list;
    set<int>         int_set;
    map<int, string> int_map;


    for (size_t j = 0; j < cur_size; j++)
    {
      int_vector.push_back(j);
      int_list.push_back(j);
      int_set.insert(j);
      int_map[j] = dummy_str;
    }

    assert (int_vector.size() == cur_size);
    assert (int_list.size()   == cur_size);
    assert (int_set.size()    == cur_size);
    assert (int_map.size()    == cur_size);


    // ---------------------------
    {
      TURN_ON_DEFAULT_TIMER (htext__find_algorithm_vector, cur_size) 
      {
        find (int_vector.begin(), int_vector.end(), median_value);
      }
    }

    {
      TURN_ON_DEFAULT_TIMER (htext__find_algorithm_list, cur_size) 
      {
        find (int_list.begin(), int_list.end(), median_value);
      }
    }
  
    {
      TURN_ON_DEFAULT_TIMER (htext__find_algorithm_set, cur_size) 
      {
        find (int_set.begin(), int_set.end(), median_value);
      }
    }
  
    {
      TURN_ON_DEFAULT_TIMER (htext__find_method_set, cur_size) 
      {
        int_set.find(median_value);
      }
    }
  
    {
      TURN_ON_DEFAULT_TIMER (htext__find_method_map, cur_size) 
      {
        int_map.find(median_value);
      }
    }


  } // for (size_t i = 0; i < t_vsizet.size(); i++)


} // find_action


///////////////
// End-Of-File
///////////////

