// ==============================================================
//
//  Copyright (c) 2002-2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : t_call.cpp
//
//  DESCRIPTION :
//         Implementation of measured/compared functions
//
// ##############################################################


// ===============
#include "tests.h"
// ===============


// #########################################
#define CSTR0	"0123456789"
#define CSTR1	"0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789"
#define CSTR2	"0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789"

static const size_t max_cstr_size = string(CSTR2).size();

// -------------------------------------------
#define NUMBER_OF_TEST_CALLS	3
static const char* t_acstr[] = {CSTR0, CSTR1, CSTR2};
static vector<string> t_vstr (t_acstr, t_acstr + NUMBER_OF_TEST_CALLS);
// -------------------------------------------


// ##########################################
template <typename T>
static T templated_foo (const T&) { T t; return t; }

static int ordinary_foo (int) { int t; return t; }

static string ordinary_foo (const string&) { string t; return t; }


// #########################################
// #
// #  Functions To Be Measured (Compared)
// #  Prototypes are in file tests.h
// #
// #########################################


// =============================
void calling_functions (void)
{

const string htext__templated_int     ("templated int   ");
const string htext__templated_string  ("templated string");
const string htext__ordinary_int      ("ordinary  int   ");
const string htext__ordinary_string   ("ordinary  string");

  // -------------------------------

int int_value = 12345;

  {
    TURN_ON_DEFAULT_TIMER (htext__templated_int, "No") 
    {
      templated_foo (int_value);
    }
  }

  {
    TURN_ON_DEFAULT_TIMER (htext__ordinary_int, "No") 
    {
      ordinary_foo (int_value);
    }
  }


  for (size_t i = 0; i < t_vstr.size(); i++)
  {
    string str			= t_vstr[i].c_str();
    const size_t str_size	= str.size();

    {
      TURN_ON_DEFAULT_TIMER (htext__templated_string, str_size) 
      {
        templated_foo (str);
      }
    }

    {
      TURN_ON_DEFAULT_TIMER (htext__ordinary_string, str_size) 
      {
        ordinary_foo (str);
      }
    }


  } // for (size_t i = 0; i < t_vstr.size(); i++)


} // calling_functions


///////////////
// End-Of-File
///////////////

