// ==============================================================
//
//  Copyright (c) 2002-2003 by Alex Vinokur.
//
//  For conditions of distribution and use, see
//  copyright notice in version.h
//
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : t_access.cpp
//
//  DESCRIPTION :
//         Implementation of measured/compared functions
//
// ##############################################################


// ===============
#include "tests.h"
// ===============


// #########################################
#define SIZE0	10
#define SIZE1	100
#define SIZE2	1000

// -------------------------------------------
#define NUMBER_OF_TEST_SIZES	3
static const size_t t_asizet[] = {SIZE0, SIZE1, SIZE2};
static vector<size_t> t_vsizet (t_asizet, t_asizet + NUMBER_OF_TEST_SIZES);
// -------------------------------------------


// #########################################
// #
// #  Functions To Be Measured (Compared)
// #  Prototypes are in file tests.h
// #
// #########################################




// =============================
void access_action (void)
{
#define DUMMY_CHAR 123

const string htext__access_operator_vector     ("operator[] - vector");
const string htext__access_operator_array      ("operator[] - array ");
const string htext__access_operator_string     ("operator[] - string");
const string htext__at_method_vector           ("at method  - vector");
const string htext__at_method_string           ("at method  - string");


  // -------------------------------
  for (size_t i = 0; i < t_vsizet.size(); i++)
  {
    const size_t cur_size (t_vsizet[i]);
    const size_t median_value = cur_size/2;

    char* char_array = (char*) malloc (cur_size * sizeof (char));
    for (size_t j = 0; j < cur_size; j++) char_array[j] = DUMMY_CHAR;

    vector<char> char_vector (char_array, char_array + cur_size);
    string char_string (cur_size, DUMMY_CHAR);

    assert (median_value < cur_size);
    assert (median_value < char_vector.size());
    assert (median_value < char_string.size());


    // ---------------------------
    {
      TURN_ON_DEFAULT_TIMER (htext__access_operator_array, cur_size) 
      {
        char_array [median_value];
      }
    }

    {
      TURN_ON_DEFAULT_TIMER (htext__access_operator_vector, cur_size) 
      {
        char_vector [median_value];
      }
    }

    {
      TURN_ON_DEFAULT_TIMER (htext__access_operator_string, cur_size) 
      {
        char_string [median_value];
      }
    }


    {
      TURN_ON_DEFAULT_TIMER (htext__at_method_vector, cur_size) 
      {
        char_vector.at (median_value);
      }
    }


    {
      TURN_ON_DEFAULT_TIMER (htext__at_method_string, cur_size) 
      {
        char_string.at (median_value);
      }
    }


  } // for (size_t i = 0; i < t_vsizet.size(); i++)


} // access_action


///////////////
// End-Of-File
///////////////

