// ####################################
// Getting info about network interfaces
// C++-wrapper around Floyd Davidson's function
// See: http://groups.google.com/groups?selm=87ofbox7xn.fld%40barrow.com
// ====================================
// Windows 2000 Professional
// CYGWIN_NT-5.0
// GNU gcc/g++ version 2.95.3-5 (cygwin special)
// ====================================
// Compilation :
//    g++ main.cpp netif.cpp
// ====================================
// Alex Vinokur
//  http://up.to/alexvn
//  mailto:alexvn@go.to
// ####################################



#ifndef _NETIF_H
#define _NETIF_H

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <arpa/inet.h>
#include <assert.h>
#include <string>
#include <sstream>
#include <vector>
#include <map>
#include <algorithm>
#include <iostream>
#include <iomanip>
using namespace std;


typedef unsigned long	ulong;
typedef unsigned int	uint;
typedef unsigned short	ushort;
typedef unsigned char	uchar;

#define MAX_VALUE(x,y)  ((x) > (y) ? (x) : (y))

#define CERR cerr << "[" << setw (12) << __FILE__ << ", " << setw(2) << __LINE__ << "] "

#define IP_ADDRESS_NAME	"IP Address"
#define HW_ADDRESS_NAME	"HW Address"
#define NETMASK_NAME	"Netmask"
#define BROADCAST_NAME	"Broadcast"
#define MTU_NAME	"MTU"
#define METRIC_NAME	"Metric"

#define MAC_ADDRESS_CHAR_LEN	6

//---------------------------
template <typename T> string to_string (const T& val_i, int width_i = -1, char fill_i = ' ')
//---------------------------
{
ostringstream osstr;
  if (width_i > 0)
  {
    osstr.width (width_i);
    osstr.fill (fill_i);
  }
  osstr << val_i;
  return osstr.str();   
}



// ----------------------------
class NetInterface
{
  private :
    vector<string>			interface_names_;
    vector<string>			property_names_;
    map<string, map<string, string> >	net_interfaces_;

    uint				interface_name_max_len_;
    uint				property_name_max_len_;
    static uint			request_counter_s;

    void	set_property_names_ ();
    string	return_property_name_ (const string& property_name_i) const;
    bool	floyd_davidson_get_net_interfaces_ ();
    void	show_net_interface_ (const string& interface_name_i, const string& property_name_i, bool flag_i) const;
    void	show_net_interface_ (const vector<string>& interface_names_i, const vector<string>& property_names_i, bool flag_i) const;


  public :
    NetInterface ();
    ~NetInterface() {}  

   string	get_net_interface (const string& interface_name_i, const string& property_name_i) const;

   void	show_net_interface (const string& interface_name_i = string(), const string& property_name_i = string()) const;

};


#endif

