// #########################################################
// === File #4 of 14 : common.h ============================
// ------------------- C++ code : BEGIN --------------------

// ==============================================================
//
//  Copyright (c) 2002 by Alex Vinokur.  This work and all works
//  derived from it may be copied and modified without any
//  restrictions other than that a copy of this copyright notice
//  must be included in any copy of this work or any derived work.
//
// ==============================================================
// #########################################################
// ## mailto:alexvn@go.to, mailto:alexv@hitechclub.com
// ## http://up.to/alexv, http://go.to/alexv_math
// #########################################################
// ==============================================================


// ##############################################################
//
//  SOFTWARE : C/C++ Program Perfometer
//  FILE     : common.h
//
//  DESCRIPTION :
//         Common function etc.
//
// ##############################################################


/////////////////
#ifndef _COMMON_H
#define _COMMON_H
/////////////////

//==================
#include "version.h"

//==================
#include <iostream>
#include <string>
#include <vector>
#include <set>
#include <map>
#include <sstream>
#include <strstream>
#include <iomanip>
#include <algorithm>
#include <iterator>
#include <functional>
#include <typeinfo>
#include <assert.h>
#include <sys/time.h>
using namespace std;


//#########################################
#ifdef OPT_LEVEL
  #if (OPT_LEVEL == -1)
  #define OPTIMIZATION_LEVEL "No optimization"
  #endif

  #if ((OPT_LEVEL == 0) || (OPT_LEVEL == 1) || (OPT_LEVEL == 2) || (OPT_LEVEL == 3))
  #define OPTIMIZATION_LEVEL ("Optimization O" + to_string(OPT_LEVEL))
  #endif
#endif

//#########################################
//#
//#  typedefs
//#
//#########################################
//=============================
typedef	unsigned long		ulong;
typedef	unsigned long long	ulonglong;
typedef	unsigned long		count_t;
//=============================


//#########################################
//#
//#  Template Functions	(Implementation)
//#
//#########################################
//=============================
//---------------------------
template <typename T>
string to_string (const T& val_i, int width_i = -1, char fill_i = ' ')
//---------------------------
{
ostringstream osstr;
  if (width_i > 0)
  {
    osstr.width (width_i);
    osstr.fill (fill_i);
  }
  osstr << val_i;
  return osstr.str();   
}

//---------------------------
template <typename T>
bool string_to (const string& str_i, T& t_value_o)
//---------------------------
{
istringstream	isstr(str_i);
  isstr >> t_value_o;
  if (isstr.fail())			return false;
  if (isstr.rdbuf()->in_avail())	return false;
  return true;   
}


//---------------------------
template <typename F>
void self_caller (F func_i)
//---------------------------
{
  func_i();
}


//###########################################
#endif
//###########################################

// ------------------- C++ code : END ----------------------
// === File #4 of 14 : common.h ============================
