/*
 * Decompiled with CFR 0.152.
 */
package com.rathedg.cachalot.tru;

import com.rathedg.cachalot.common.CommonDB;
import com.rathedg.cachalot.tru.HostInfo;
import com.rathedg.cachalot.tru.TrafficInfo;
import com.rathedg.util.PropertyExtractor;
import com.rathedg.util.db.ConnectionTuner;
import com.rathedg.util.db.DBConnectionSource;
import com.rathedg.util.db.DBUtils;
import com.rathedg.util.exception.InitializationException;
import com.rathedg.util.exception.InvalidValueException;
import com.rathedg.util.log.LoggerInterface;
import com.rathedg.util.math.IntegerIntervalsList;
import com.rathedg.util.net.IP;
import com.rathedg.util.snt.Queue;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class DB
extends Thread
implements ConnectionTuner {
    boolean shutdown = false;
    private Queue queue;
    private LoggerInterface logger;
    private int txLevel;
    private DBConnectionSource dbsource;
    private Map hosts = new HashMap();

    DB(PropertyExtractor propertyExtractor, Queue queue, LoggerInterface loggerInterface) throws InvalidValueException, InitializationException {
        this.logger = loggerInterface;
        try {
            DriverManager.registerDriver((Driver)Class.forName(propertyExtractor.getStringNotNullNotEmpty("db.driver", true)).newInstance());
        }
        catch (InvalidValueException invalidValueException) {
            throw invalidValueException;
        }
        catch (Exception exception) {
            throw new InitializationException("error instantiating or registering driver", exception);
        }
        this.txLevel = DBUtils.parseTXLevel(propertyExtractor.getStringNotNullNotEmpty("db.transaction", true));
        if (this.txLevel == -1) {
            throw new InitializationException("value 'db.transaction' is invalid");
        }
        try {
            this.dbsource = DBConnectionSource.getDBConnectionSource(propertyExtractor.getStringNotNullNotEmpty("db.url", true), new Properties(), this, 1, null);
        }
        catch (Throwable throwable) {
            if (this.dbsource != null) {
                this.dbsource.releaseResources();
            }
            throw new InitializationException("error connecting to db", throwable);
        }
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.dbsource.getConnection();
            preparedStatement = connection.prepareStatement("SELECT f_address1, f_address2, f_address3, f_address4, f_uin, f_combinetraffic FROM t_hosts");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                IP iP = new IP(CommonDB.cb(resultSet.getShort(1)), CommonDB.cb(resultSet.getShort(2)), CommonDB.cb(resultSet.getShort(3)), CommonDB.cb(resultSet.getShort(4)));
                short s = resultSet.getShort(5);
                boolean bl = resultSet.getBoolean(6);
                IntegerIntervalsList integerIntervalsList = CommonDB.getHostPriviledgedPorts(connection, s);
                this.hosts.put(iP, new HostInfo(new Short(s), bl, integerIntervalsList));
            }
            DBUtils.safeCloseStatement(preparedStatement);
            this.dbsource.releaseConnectionSafe(connection);
        }
        catch (SQLException sQLException) {
            DBUtils.safeCloseStatement(preparedStatement);
            this.dbsource.releaseConnectionSafe(connection);
            this.dbsource.releaseResources();
            throw new InitializationException(sQLException.toString());
        }
        this.queue = queue;
    }

    Map getHosts() {
        return this.hosts;
    }

    public void run() {
        while (true) {
            Object object;
            block10: {
                if (this.queue.size() == 0) {
                    try {
                        object = this;
                        synchronized (object) {
                            if (this.shutdown) {
                                if (this.queue.size() != 0) {
                                    break block10;
                                }
                                this.notify();
                                return;
                            }
                            this.wait(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            object = this.queue.get();
            if (object instanceof List) {
                this.fill((List)object);
                continue;
            }
            this.fill((TrafficInfo)object);
        }
    }

    void fill(List list) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object var11_10;
            TrafficInfo trafficInfo = (TrafficInfo)list.get(n2);
            String string = trafficInfo.incoming ? "INSERT INTO t_intraffic (f_protocol,f_host,f_rhost,f_port,f_rport,f_bytes,f_moment) VALUES (?,?,?,?,?,?,?)" : "INSERT INTO t_outtraffic (f_protocol,f_host,f_rhost,f_port,f_rport,f_bytes,f_moment) VALUES (?,?,?,?,?,?,?)";
            try {
                while (true) {
                    try {
                        connection = this.dbsource.getConnection();
                        preparedStatement = connection.prepareStatement(string);
                        preparedStatement.setByte(1, trafficInfo.protocol);
                        preparedStatement.setShort(2, trafficInfo.host);
                        preparedStatement.setString(3, trafficInfo.rhost.toString());
                        preparedStatement.setShort(4, trafficInfo.port);
                        preparedStatement.setShort(5, trafficInfo.rport);
                        preparedStatement.setInt(6, trafficInfo.amount);
                        preparedStatement.setTimestamp(7, new Timestamp(trafficInfo.moment));
                        preparedStatement.executeUpdate();
                    }
                    catch (Throwable throwable) {
                        this.logger.log("Error inserting to db " + trafficInfo + " (queue size is " + (this.queue.size() + n - n2) + ": " + throwable);
                        DBUtils.safeCloseStatement(preparedStatement);
                        this.dbsource.releaseConnectionSafe(connection);
                        preparedStatement = null;
                        connection = null;
                        try {
                            Thread.sleep(1000 * 2);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        var11_10 = null;
                        DBUtils.safeCloseStatement(preparedStatement);
                        this.dbsource.releaseConnectionSafe(connection);
                        connection = null;
                        continue;
                    }
                    var11_10 = null;
                    break;
                }
            }
            catch (Throwable throwable) {
                var11_10 = null;
                DBUtils.safeCloseStatement(preparedStatement);
                this.dbsource.releaseConnectionSafe(connection);
                connection = null;
                throw throwable;
            }
            DBUtils.safeCloseStatement(preparedStatement);
            this.dbsource.releaseConnectionSafe(connection);
            connection = null;
            ++n2;
        }
    }

    void fill(TrafficInfo trafficInfo) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        String string = trafficInfo.incoming ? "INSERT INTO t_intraffic (f_protocol,f_host,f_rhost,f_port,f_rport,f_bytes,f_moment) VALUES (?,?,?,?,?,?,?)" : "INSERT INTO t_outtraffic (f_protocol,f_host,f_rhost,f_port,f_rport,f_bytes,f_moment) VALUES (?,?,?,?,?,?,?)";
        try {
            while (true) {
                Object var8_5;
                try {
                    connection = this.dbsource.getConnection();
                    preparedStatement = connection.prepareStatement(string);
                    preparedStatement.setByte(1, trafficInfo.protocol);
                    preparedStatement.setShort(2, trafficInfo.host);
                    preparedStatement.setString(3, trafficInfo.rhost.toString());
                    preparedStatement.setShort(4, trafficInfo.port);
                    preparedStatement.setShort(5, trafficInfo.rport);
                    preparedStatement.setInt(6, trafficInfo.amount);
                    preparedStatement.setTimestamp(7, new Timestamp(trafficInfo.moment));
                    preparedStatement.executeUpdate();
                }
                catch (Throwable throwable) {
                    this.logger.log("Error inserting to db " + trafficInfo + " (queue size is " + (this.queue.size() + 1) + ": " + throwable);
                    DBUtils.safeCloseStatement(preparedStatement);
                    this.dbsource.releaseConnectionSafe(connection);
                    preparedStatement = null;
                    connection = null;
                    try {
                        Thread.sleep(1000 * 2);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    var8_5 = null;
                    DBUtils.safeCloseStatement(preparedStatement);
                    this.dbsource.releaseConnectionSafe(connection);
                    connection = null;
                    continue;
                }
                var8_5 = null;
                break;
            }
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            DBUtils.safeCloseStatement(preparedStatement);
            this.dbsource.releaseConnectionSafe(connection);
            connection = null;
            throw throwable;
        }
        DBUtils.safeCloseStatement(preparedStatement);
        this.dbsource.releaseConnectionSafe(connection);
        connection = null;
    }

    public void tune(Connection connection) throws SQLException {
        try {
            connection.setTransactionIsolation(this.txLevel);
        }
        catch (SQLException sQLException) {
            throw new SQLException("Error setting transaction isolation level: " + sQLException.getMessage());
        }
    }

    synchronized void shutdown() {
        this.shutdown = true;
        this.notify();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

