/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlGui.applet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javazoom.Util.Debug;
import javazoom.jlGui.BasicPlayerListener;
import javazoom.jlGui.applet.AppletMpegSPIWorkaround;
import javazoom.jlGui.applet.AppletVorbisSPIWorkaround;

public class BasicPlayer
implements Runnable {
    private static final int EXTERNAL_BUFFER_SIZE = 16000;
    private Thread m_thread = null;
    private Object m_dataSource = null;
    private AudioInputStream m_audioInputStream = null;
    private AudioFileFormat m_audioFileFormat = null;
    private SourceDataLine m_line = null;
    private FloatControl m_gainControl = null;
    private FloatControl m_panControl = null;
    public static final int PAUSED = 1;
    public static final int PLAYING = 0;
    public static final int STOPPED = 2;
    public static final int READY = 3;
    private int m_status = 3;
    private long doSeek = -1L;
    private File _file = null;
    private BasicPlayerListener m_bpl = null;
    public static String OGGEXTENSIONS = "ogg";
    public static boolean isOgg = false;
    public static boolean forceOgg = false;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public BasicPlayer() {
    }

    public BasicPlayer(BasicPlayerListener basicPlayerListener) {
        this();
        this.m_bpl = basicPlayerListener;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setDataSource(File file) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        if (file != null) {
            this.m_dataSource = file;
            this.initAudioInputStream();
        }
    }

    public void setDataSource(URL uRL) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        if (uRL != null) {
            this.m_dataSource = uRL;
            this.initAudioInputStream();
        }
    }

    public void setDataSource(InputStream inputStream) throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        if (inputStream != null) {
            this.m_dataSource = inputStream;
            this.initAudioInputStream();
        }
    }

    private void initAudioInputStream() throws UnsupportedAudioFileException, LineUnavailableException, IOException {
        if (this.m_dataSource instanceof URL) {
            this.initAudioInputStream((URL)this.m_dataSource);
        } else if (this.m_dataSource instanceof File) {
            this.initAudioInputStream((File)this.m_dataSource);
        } else if (this.m_dataSource instanceof InputStream) {
            this.initAudioInputStream((InputStream)this.m_dataSource);
        }
    }

    private void initAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        this._file = file;
        if (file.getName().toLowerCase().endsWith(OGGEXTENSIONS) || forceOgg) {
            this.m_audioInputStream = AppletVorbisSPIWorkaround.getAudioInputStream(file);
            this.m_audioFileFormat = AppletVorbisSPIWorkaround.getAudioFileFormat(file);
            isOgg = true;
        } else {
            this.m_audioInputStream = AppletMpegSPIWorkaround.getAudioInputStream(file);
            this.m_audioFileFormat = AppletMpegSPIWorkaround.getAudioFileFormat(file);
            isOgg = false;
        }
    }

    private void initAudioInputStream(URL uRL) throws UnsupportedAudioFileException, IOException {
        if (uRL.toString().toLowerCase().endsWith(OGGEXTENSIONS) || forceOgg) {
            this.m_audioInputStream = AppletVorbisSPIWorkaround.getAudioInputStream(uRL);
            this.m_audioFileFormat = AppletVorbisSPIWorkaround.getAudioFileFormat(uRL);
            isOgg = true;
        } else {
            this.m_audioInputStream = AppletMpegSPIWorkaround.getAudioInputStream(uRL);
            this.m_audioFileFormat = AppletMpegSPIWorkaround.getAudioFileFormat(uRL);
            isOgg = false;
        }
    }

    private void initAudioInputStream(InputStream inputStream) throws UnsupportedAudioFileException, IOException {
        if (forceOgg) {
            this.m_audioFileFormat = AppletVorbisSPIWorkaround.getAudioFileFormat(inputStream);
            this.m_audioInputStream = AppletVorbisSPIWorkaround.getAudioInputStream(inputStream);
            isOgg = true;
        } else {
            try {
                this.m_audioFileFormat = AppletMpegSPIWorkaround.getAudioFileFormat(inputStream);
                this.m_audioInputStream = AppletMpegSPIWorkaround.getAudioInputStream(inputStream);
                isOgg = false;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
                this.m_audioFileFormat = AppletVorbisSPIWorkaround.getAudioFileFormat(inputStream);
                this.m_audioInputStream = AppletVorbisSPIWorkaround.getAudioInputStream(inputStream);
                isOgg = true;
            }
        }
    }

    protected void initLine() throws LineUnavailableException {
        if (this.m_line == null) {
            this.createLine();
            this.trace(1, this.getClass().getName(), "Create Line OK ");
            this.openLine();
        } else {
            AudioFormat audioFormat;
            AudioFormat audioFormat2 = this.m_line.getFormat();
            AudioFormat audioFormat3 = audioFormat = this.m_audioInputStream == null ? null : this.m_audioInputStream.getFormat();
            if (!audioFormat2.equals(audioFormat)) {
                this.m_line.close();
                this.openLine();
            }
        }
    }

    private void createLine() throws LineUnavailableException {
        if (this.m_line == null) {
            AudioFormat audioFormat = this.m_audioInputStream.getFormat();
            this.trace(1, this.getClass().getName(), "Source format : ", audioFormat.toString());
            AudioFormat audioFormat2 = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, audioFormat.getSampleRate(), 16, audioFormat.getChannels(), audioFormat.getChannels() * 2, audioFormat.getSampleRate(), false);
            this.trace(1, this.getClass().getName(), "Target format: " + audioFormat2);
            this.m_audioInputStream = isOgg || forceOgg ? AppletVorbisSPIWorkaround.getAudioInputStream(audioFormat2, this.m_audioInputStream) : AppletMpegSPIWorkaround.getAudioInputStream(audioFormat2, this.m_audioInputStream);
            AudioFormat audioFormat3 = this.m_audioInputStream.getFormat();
            this.trace(1, this.getClass().getName(), "Create Line : ", audioFormat3.toString());
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = BasicPlayer.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat3, -1);
            this.m_line = (SourceDataLine)AudioSystem.getLine(info);
            Control[] controlArray = this.m_line.getControls();
            int n = 0;
            while (n < controlArray.length) {
                this.trace(2, this.getClass().getName(), "Controls : " + controlArray[n].toString());
                ++n;
            }
            if (this.m_line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                this.m_gainControl = (FloatControl)this.m_line.getControl(FloatControl.Type.MASTER_GAIN);
                this.trace(1, this.getClass().getName(), "Master Gain Control : [" + this.m_gainControl.getMinimum() + "," + this.m_gainControl.getMaximum() + "]", "" + this.m_gainControl.getPrecision());
            }
            if (this.m_line.isControlSupported(FloatControl.Type.PAN)) {
                this.m_panControl = (FloatControl)this.m_line.getControl(FloatControl.Type.PAN);
                this.trace(1, this.getClass().getName(), "Pan Control : [" + this.m_panControl.getMinimum() + "," + this.m_panControl.getMaximum() + "]", "" + this.m_panControl.getPrecision());
            }
        }
    }

    private void openLine() throws LineUnavailableException {
        if (this.m_line != null) {
            AudioFormat audioFormat = this.m_audioInputStream.getFormat();
            this.trace(1, this.getClass().getName(), "AudioFormat : " + audioFormat);
            this.m_line.open(audioFormat, this.m_line.getBufferSize());
        }
    }

    public void stopPlayback() {
        if (this.m_status == 0 || this.m_status == 1) {
            if (this.m_line != null) {
                this.m_line.flush();
                this.m_line.stop();
            }
            this.m_status = 2;
            try {
                this.m_audioInputStream.close();
            }
            catch (IOException iOException) {
                this.trace(1, this.getClass().getName(), "Cannot close stream : " + iOException.getMessage());
            }
            this.trace(1, this.getClass().getName(), "Stop called");
        }
    }

    public void pausePlayback() {
        if (this.m_line != null && this.m_status == 0) {
            this.m_line.flush();
            this.m_line.stop();
            this.m_status = 1;
            this.trace(1, this.getClass().getName(), "Pause called");
        }
    }

    public void resumePlayback() {
        if (this.m_line != null && this.m_status == 1) {
            this.m_line.start();
            this.m_status = 0;
            this.trace(1, this.getClass().getName(), "Resume called");
        }
    }

    public String startPlayback() {
        if (this.m_status == 2 || this.m_status == 3) {
            this.trace(1, this.getClass().getName(), "Start called");
            if (this.m_thread != null && this.m_thread.isAlive()) {
                this.trace(1, this.getClass().getName(), "WARNING: old thread still running!!");
                int n = 0;
                while (this.m_status != 3) {
                    try {
                        if (this.m_thread != null) {
                            Thread.sleep(1000L);
                            if (++n > 2) {
                                this.m_thread.interrupt();
                            }
                        }
                    }
                    catch (Exception exception) {
                        this.trace(1, this.getClass().getName(), "Waiting Error : " + exception.getMessage());
                    }
                    this.trace(1, this.getClass().getName(), "Waiting ... " + n);
                }
            }
            try {
                this.initLine();
            }
            catch (Exception exception) {
                this.trace(0, this.getClass().getName(), "Cannot init Line", exception.getMessage());
                return "ERROR";
            }
            this.trace(1, this.getClass().getName(), "Creating new thread");
            this.m_thread = new Thread(this);
            this.m_thread.start();
            if (this.m_line != null) {
                this.m_line.start();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.trace(1, this.getClass().getName(), "Thread Running");
        int n = 1;
        this.m_status = 0;
        int n2 = 0;
        byte[] byArray = new byte[16000];
        float f = this.m_line.getFormat().getFrameSize();
        float f2 = this.m_line.getFormat().getFrameRate();
        float f3 = f * f2;
        int n3 = Math.round((float)this.m_audioFileFormat.getByteLength() / f3);
        n3 = (int)Math.round(this.getTotalLengthInSeconds());
        while (n != -1 && this.m_status != 2) {
            if (this.m_status == 0) {
                try {
                    if (this.doSeek > -1L) {
                        if (this.getAudioFileFormat() != null && this.getAudioFileFormat().getType().toString().startsWith("WAV")) {
                            if (n3 != -1 && n3 > 0) {
                                this.m_line.flush();
                                this.m_line.stop();
                                this.m_audioInputStream.close();
                                this.m_audioInputStream = AudioSystem.getAudioInputStream(this._file);
                                n2 = 0;
                                if ((long)this.m_audioFileFormat.getByteLength() - this.doSeek < (long)byArray.length) {
                                    this.doSeek = this.m_audioFileFormat.getByteLength() - byArray.length;
                                }
                                this.doSeek -= this.doSeek % 4L;
                                int n4 = (int)this.doSeek;
                                while (n4 > 0 && n > 0) {
                                    n = n4 > byArray.length ? this.m_audioInputStream.read(byArray, 0, byArray.length) : this.m_audioInputStream.read(byArray, 0, n4);
                                    n4 -= n;
                                    n2 += n;
                                }
                                this.m_line.start();
                            } else {
                                this.trace(1, this.getClass().getName(), "Seek not supported for this InputStream : " + n3);
                            }
                        } else {
                            this.trace(1, this.getClass().getName(), "Seek not supported for this InputStream : " + n3);
                        }
                        this.doSeek = -1L;
                    }
                    n = this.m_audioInputStream.read(byArray, 0, byArray.length);
                }
                catch (Exception exception) {
                    this.trace(1, this.getClass().getName(), "InputStream error : (" + n + ")", exception.getMessage());
                    exception.printStackTrace();
                    this.m_status = 2;
                }
                if (n < 0) continue;
                if (this.m_bpl != null) {
                    this.m_bpl.updateMediaData(byArray);
                }
                int n5 = this.m_line.write(byArray, 0, n);
                n2 += n5;
                if (this.m_bpl == null) continue;
                this.m_bpl.updateCursor(Math.round((float)n2 / f3), n3);
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                this.trace(1, this.getClass().getName(), "Thread cannot sleep : ", exception.getMessage());
            }
        }
        if (this.m_line != null) {
            try {
                try {
                    this.m_line.drain();
                    this.m_line.stop();
                    this.m_line.close();
                }
                catch (Exception exception) {
                    this.trace(1, this.getClass().getName(), "Cannot Free Audio ressources", exception.getMessage());
                    Object var10_14 = null;
                    this.m_line = null;
                }
                Object var10_13 = null;
                this.m_line = null;
            }
            catch (Throwable throwable) {
                Object var10_15 = null;
                this.m_line = null;
                throw throwable;
            }
        }
        this.trace(1, this.getClass().getName(), "Thread Stopped");
        this.m_status = 3;
        if (this.m_bpl != null && n == -1) {
            this.m_bpl.updateMediaState("EOM");
        }
    }

    public boolean hasGainControl() {
        return this.m_gainControl != null;
    }

    public void setGain(double d) {
        if (this.hasGainControl()) {
            double d2 = this.getMinimum();
            double d3 = 0.5f * this.getMaximum() - this.getMinimum();
            double d4 = Math.log(10.0) / 20.0;
            double d5 = d2 + 1.0 / d4 * Math.log(1.0 + (Math.exp(d4 * d3) - 1.0) * d);
            this.m_gainControl.setValue((float)d5);
        }
    }

    public float getGain() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getValue();
        }
        return 0.0f;
    }

    public float getMaximum() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getMaximum();
        }
        return 0.0f;
    }

    public float getMinimum() {
        if (this.hasGainControl()) {
            return this.m_gainControl.getMinimum();
        }
        return 0.0f;
    }

    public boolean hasPanControl() {
        return this.m_panControl != null;
    }

    public float getPrecision() {
        if (this.hasPanControl()) {
            return this.m_panControl.getPrecision();
        }
        return 0.0f;
    }

    public float getPan() {
        if (this.hasPanControl()) {
            return this.m_panControl.getValue();
        }
        return 0.0f;
    }

    public void setPan(float f) {
        if (this.hasPanControl()) {
            this.m_panControl.setValue(f);
        }
    }

    public void setSeek(double d) throws IOException {
        long l;
        double d2 = -1.0;
        if (this.m_audioFileFormat != null && this.m_audioFileFormat.getByteLength() != -1) {
            d2 = this.m_audioFileFormat.getByteLength();
        }
        this.doSeek = l = Math.round(d * d2);
    }

    public AudioFormat getAudioFormat() {
        if (this.m_audioFileFormat != null) {
            return this.m_audioFileFormat.getFormat();
        }
        return null;
    }

    public AudioFileFormat getAudioFileFormat() {
        if (this.m_audioFileFormat != null) {
            return this.m_audioFileFormat;
        }
        return null;
    }

    public double getTotalLengthInSeconds() {
        double d = 0.0;
        if (this.getAudioFileFormat() != null) {
            int n = this.getAudioFileFormat().getFrameLength();
            int n2 = this.getAudioFormat().getFrameSize();
            float f = this.getAudioFormat().getSampleRate();
            float f2 = this.getAudioFormat().getFrameRate();
            int n3 = this.getAudioFileFormat().getByteLength();
            String string = this.getAudioFileFormat().getType().toString();
            String string2 = this.getAudioFormat().getEncoding().toString();
            if (n != -1 && (string.startsWith("MP3") || string.startsWith("VORBIS"))) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "x");
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                d = Math.round(Integer.parseInt(string3) / 1000);
            } else {
                int n4 = this.getBitRate();
                d = n4 > 0 ? (double)(n3 * 8 / n4) : (double)((float)n3 / ((float)n2 * f));
            }
            this.trace(2, this.getClass().getName(), "Type=" + string + " Encoding=" + string2 + " FL=" + n + " FS=" + n2 + " SR=" + f + " FR=" + f2 + " TL=" + n3, " lenghtInSecond=" + d);
        }
        if (d < 0.0) {
            d = 0.0;
        }
        return d;
    }

    public int getBitRate() {
        int n = 0;
        if (this.getAudioFileFormat() != null) {
            int n2 = this.getAudioFileFormat().getFrameLength();
            int n3 = this.getAudioFormat().getFrameSize();
            float f = this.getAudioFormat().getSampleRate();
            float f2 = this.getAudioFormat().getFrameRate();
            int n4 = this.getAudioFileFormat().getByteLength();
            String string = this.getAudioFileFormat().getType().toString();
            String string2 = this.getAudioFormat().getEncoding().toString();
            if (string != null && (string.startsWith("MP3") || string.startsWith("VORBIS"))) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "x");
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    String string3 = stringTokenizer.nextToken();
                    n = Math.round(Integer.parseInt(string3));
                }
            } else {
                n = Math.round((float)n3 * f2 * 8.0f);
            }
            this.trace(2, this.getClass().getName(), "Type=" + string + " Encoding=" + string2 + " FL=" + n2 + " FS=" + n3 + " SR=" + f + " FR=" + f2 + " TL=" + n4, " bitRate=" + n);
        }
        if (n <= 0 && this.m_line != null) {
            n = Math.round((float)this.m_line.getFormat().getFrameSize() * this.m_line.getFormat().getFrameRate() * 8.0f);
        }
        return n;
    }

    protected InputStream openInput(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return bufferedInputStream;
    }

    private void trace(int n, String string, String string2) {
        Debug debug = Debug.getInstance();
        debug.log(n, string + ":" + string2);
    }

    private void trace(int n, String string, String string2, String string3) {
        Debug debug = Debug.getInstance();
        debug.log(n, string + ":" + string2 + "," + string3);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

