/*
 * Decompiled with CFR 0.152.
 */
package vscript.message;

import java.util.HashMap;
import java.util.Iterator;
import vscript.VScriptRunner;
import vscript.message.Messagable;
import vscript.message.Message;
import vscript.parser.Parser;

public class MessageNode {
    private String fullName = "vsr_root";
    private String shortName;
    Messagable messagableObject;
    private HashMap childNodeMap = new HashMap(4);
    private Object interpretedObject;
    private MessageNode parentNode;
    private Object container;

    public MessageNode(MessageNode messageNode, String string) {
        this.shortName = string;
        if (messageNode != null) {
            this.parentNode = messageNode;
            this.parentNode.addChildNode(this);
        }
        if (messageNode != null) {
            StringBuffer stringBuffer = new StringBuffer(40);
            stringBuffer.append(messageNode.getFullName());
            stringBuffer.append('.');
            stringBuffer.append(string);
            this.fullName = stringBuffer.toString();
        }
    }

    String getShortName() {
        return this.shortName;
    }

    public String getFullName() {
        return this.fullName;
    }

    void addChildNode(MessageNode messageNode) {
        this.childNodeMap.put(messageNode.getShortName(), messageNode);
    }

    public void addInterpretedObject(Object object) {
        this.interpretedObject = object;
        if (object instanceof Messagable) {
            this.messagableObject = (Messagable)object;
        }
    }

    public Object getInterpretedObject() {
        return this.interpretedObject;
    }

    public void setContainer(Object object) {
        this.container = object;
    }

    public Object getContainer() {
        return this.container;
    }

    public void passMessage(Message message) {
        int n;
        String string = null;
        string = message.getNextDestination(false);
        if (string != null && (n = string.indexOf(42)) != -1) {
            boolean bl = false;
            message.removeNextDestination();
            Iterator iterator = this.childNodeMap.values().iterator();
            while (iterator.hasNext()) {
                MessageNode messageNode = (MessageNode)iterator.next();
                if (!this.checkWildCard(string, messageNode.getShortName(), n)) continue;
                int n2 = message.getNextDestIndex();
                messageNode.passMessage(message);
                message.setNextDestIndex(n2);
                bl = true;
            }
            message.resetDestination();
            if (!bl && this.parentNode != null) {
                this.parentNode.passMessage(message);
            }
            return;
        }
        MessageNode messageNode = this.nextDestination(message);
        if (messageNode == this) {
            if (this.messagableObject != null) {
                String string2 = message.getMessageString();
                if (string2 == null) {
                    return;
                }
                if (string2.equals("passmsg")) {
                    String[] stringArray = message.getArguments();
                    if (stringArray.length == 1) {
                        Message message2 = Parser.parseMessage(stringArray[0]);
                        message2.setSourceMessageNode(this);
                        VScriptRunner vScriptRunner = VScriptRunner.getVScriptRunner();
                        message2.prepareMessage(this);
                        this.passMessage(message2);
                    }
                } else {
                    this.messagableObject.handleMessage(message);
                }
            }
            message.resetDestination();
        } else if (messageNode != null) {
            messageNode.passMessage(message);
        } else {
            message.resetDestination();
            System.out.println("Destination Not Reachable: " + message.toString());
        }
    }

    public Object getObject(Message message) {
        MessageNode messageNode = this.nextDestination(message);
        if (messageNode == this) {
            return this.interpretedObject;
        }
        if (messageNode != null) {
            return messageNode.getObject(message);
        }
        System.out.println("Wrong Name:" + message.toString());
        return null;
    }

    private MessageNode nextDestination(Message message) {
        String string = message.getNextDestination(true);
        if (string == null) {
            return this;
        }
        if (this.childNodeMap.containsKey(string)) {
            message.removeNextDestination();
            return (MessageNode)this.childNodeMap.get(string);
        }
        return this.parentNode;
    }

    private boolean checkWildCard(String string, String string2, int n) {
        if (string2.startsWith(string.substring(0, n))) {
            return string2.endsWith(string.substring(n + 1));
        }
        return false;
    }

    public void removeChildNode(String string) {
        this.childNodeMap.remove(string);
    }
}

