/*
 * Decompiled with CFR 0.152.
 */
package vscript.GUI;

import java.awt.BorderLayout;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import vscript.VSRHelper;
import vscript.interpreter.EventTagManager;
import vscript.interpreter.TagInterpreter;
import vscript.message.Messagable;
import vscript.message.Message;

public class VTextPane
extends JPanel
implements Messagable,
HyperlinkListener,
Runnable {
    private EventTagManager etm;
    private JEditorPane textPane = new JEditorPane();
    private JScrollPane jsp = new JScrollPane(this.textPane);
    private boolean html;
    private boolean editable;
    private URL url;

    public VTextPane(String string, String string2, String string3, boolean bl, String string4, boolean bl2) {
        TagInterpreter.processBorder(this.jsp, string4);
        TagInterpreter.processBColor(this.textPane, string2);
        TagInterpreter.processFColor(this.textPane, string3);
        this.textPane.setCaretColor(this.textPane.getForeground());
        TagInterpreter.processBColor(this.jsp.getVerticalScrollBar(), string2);
        TagInterpreter.processBColor(this.jsp.getHorizontalScrollBar(), string2);
        this.textPane.setEditable(bl);
        this.html = bl2;
        this.editable = bl;
        if (string != null && string.length() > 0) {
            this.textPane.setText(string);
        }
        this.setLayout(new BorderLayout());
        this.add(this.jsp);
        this.textPane.addHyperlinkListener(this);
    }

    public void handleMessage(Message message) {
        String string = message.getMessageString();
        if (string != null) {
            if (string.equals("border")) {
                TagInterpreter.handleMessageGUI(this.jsp, message);
            } else if (string.equals("bcolor") || string.equals("fcolor")) {
                TagInterpreter.handleMessageGUI(this.textPane, message);
            } else if (string.equals("scrolldown")) {
                Document document = this.textPane.getDocument();
                this.textPane.setCaretPosition(document.getLength());
            } else if (string.equals("clear")) {
                if (this.html) {
                    this.textPane.setDocument(new HTMLDocument());
                } else {
                    this.textPane.setDocument(new DefaultStyledDocument());
                }
            } else if (string.equals("display")) {
                String[] stringArray = message.getArguments();
                if (stringArray.length > 0) {
                    try {
                        if (this.html) {
                            this.textPane.setContentType("text/html");
                        }
                        this.textPane.setText(stringArray[0]);
                    }
                    catch (Exception exception) {
                        System.out.println(exception.toString());
                    }
                }
            } else if (string.equals("insert")) {
                String[] stringArray = message.getArguments();
                if (stringArray.length > 0) {
                    this.insert(stringArray[0], false);
                }
            } else if (string.equals("newline")) {
                this.insert("\n", true);
            } else if (string.equals("append")) {
                String[] stringArray = message.getArguments();
                if (stringArray.length > 0) {
                    this.insert(stringArray[0], true);
                }
            } else if (string.equals("loadfile")) {
                String[] stringArray = message.getArguments();
                if (stringArray.length > 0) {
                    try {
                        URL uRL;
                        this.url = uRL = VSRHelper.getVSRHelper().getLoadURL(null, stringArray[0]);
                        SwingUtilities.invokeLater(this);
                    }
                    catch (Exception exception) {
                        System.out.println(exception.toString());
                    }
                }
            } else {
                TagInterpreter.handleMessageGUI(this, message);
            }
        }
    }

    public void run() {
        try {
            this.textPane.setPage(this.url);
            Document document = this.textPane.getDocument();
            if (document instanceof HTMLDocument) {
                ((HTMLDocument)this.textPane.getDocument()).setBase(this.url);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    private void insert(String string, boolean bl) {
        try {
            Document document = this.textPane.getDocument();
            int n = bl ? document.getLength() : this.textPane.getCaretPosition();
            if (this.html) {
                HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)this.textPane.getEditorKit();
                if (this.editable) {
                    if (n > 0) {
                        hTMLEditorKit.insertHTML((HTMLDocument)document, n, string, 1, 1, null);
                    }
                } else {
                    hTMLEditorKit.insertHTML((HTMLDocument)document, n, string, 1, 1, null);
                }
            } else {
                document.insertString(n, string, null);
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public void setEventTagManager(EventTagManager eventTagManager) {
    }

    public String getDataValue(String string) {
        String string2 = null;
        if (string != null) {
            if (string.equals("data")) {
                string2 = this.textPane.getText();
            } else if (string.equals("content")) {
                try {
                    if (this.html) {
                        HTMLDocument hTMLDocument = (HTMLDocument)this.textPane.getDocument();
                        string2 = hTMLDocument.getText(0, hTMLDocument.getLength());
                    } else {
                        string2 = this.textPane.getText();
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
        return string2;
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane jEditorPane = (JEditorPane)hyperlinkEvent.getSource();
            if (hyperlinkEvent instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent hTMLFrameHyperlinkEvent = (HTMLFrameHyperlinkEvent)hyperlinkEvent;
                HTMLDocument hTMLDocument = (HTMLDocument)jEditorPane.getDocument();
                hTMLDocument.processHTMLFrameHyperlinkEvent(hTMLFrameHyperlinkEvent);
            } else {
                try {
                    jEditorPane.setPage(hyperlinkEvent.getURL());
                }
                catch (Throwable throwable) {
                    System.out.println(throwable.toString());
                }
            }
        }
    }
}

