/*
 * DAComponent.java
 *
 * Created on September 5, 2002, 4:32 PM
 */

package demo;
import com.develop.jawin.*;
import com.develop.io.*;
import com.develop.jawin.win32.*;
import DirectAnimation.*;
import java.awt.*;

/**
 *
 * @author  Cyril
 */
public class DAComponent extends AXComponent {
    public int skip = 0;
    public IDA3ViewerControl davControl = null;
    public IDA3Statics daStatics = null;
    public IDAImage sourceImg = null;
    public IDAImage sourceImg0 = null;
    public IDAImage sourceImg1 = null;
    public IDAImage bkImg = null;
    public IDABbox2 daBbox = null;
    public IDANumber xSize = null;
    public IDANumber ySize = null;
    public IDANumber ratio = null;
    public IDANumber wndXSize = null;
    public IDANumber wndYSize = null;
    public IDANumber xScale = null;
    public IDANumber yScale = null;
    public IDAImage finalImage = null;
    public IDAImage txtImg = null;
    private boolean sizeCalculated = false;
    private int currSel = 0;
    
    /** Creates a new instance of DAComponent */
    public DAComponent() throws COMException {
        super(DAViewerControl.progID);
    }
    
    void calcSize(int w, int h) throws COMException {
        if(w > 0 && h > 0 && sourceImg0 != null && daStatics != null) {
            daBbox = new IDABbox2(sourceImg0.getBoundingBox());
            xSize = daStatics.Mul(daBbox.getMin().getX(), daStatics.DANumber(-2.));
            ySize = daStatics.Mul(daBbox.getMin().getY(), daStatics.DANumber(-2.));
            ratio = daStatics.Div(ySize, xSize);
            wndXSize = daStatics.DANumber(w);
            wndYSize = daStatics.DANumber(h);
            wndYSize = daStatics.Mul(ratio, wndXSize);
            xScale = daStatics.Div(daStatics.Mul(wndXSize, daStatics.getPixel()), xSize);
            yScale = daStatics.Div(daStatics.Mul(wndYSize, daStatics.getPixel()), ySize);
            sizeCalculated = true;
        }
    }
    
    public void componentResized(java.awt.event.ComponentEvent componentEvent) {
        super.componentResized(componentEvent);
        try{
            calcSize(getWidth(), getHeight());
        } catch (COMException e){}
    }
    
    protected void initInstance() throws COMException {
        davControl = new IDA3ViewerControl(getControl());
        daStatics = new IDA3Statics(davControl.getMeterLibrary());
        String imgPath = ClassPath.getClassPath(JDATest.class);
        sourceImg0 = daStatics.ImportImage(imgPath + "cedar.jpg");
        sourceImg1 = daStatics.ImportImage(imgPath + "lefgada.jpg");
        bkImg = daStatics.SolidColorImage(daStatics.ColorRgb(1,1,1));
        calcSize(getWidth(), getHeight());
        finalImage = new IDAImage(daStatics.ModifiableBehavior(new IDABehavior(daStatics.getEmptyImage())));
        makeAbout();
        davControl.setImage(finalImage);
        davControl.Start();
        selectFilter(currSel);
    }
    
    public DispatchPtr wrapTransformer(String progID, String copyRight[]) throws COMException {
        DispatchPtr retval = null;
        try {
            String strGUID = Ole32.CLSIDFromProgID(progID).GUID2String();
            retval = new DispatchPtr(progID);
            //String strCopyright = "Copyright MetaCreations Corp. 1998.  Unauthorized duplication of this string is illegal. ";
            //copyRight[0] = new String(strCopyright + strGUID.toUpperCase());
        }catch(COMException e){}
        return retval;
    }
    
    public void makeAbout() throws COMException {
        // Create an animated color
        IDANumber num1 = daStatics.DANumber(0.4);
        IDANumber num2 = daStatics.DANumber(0.4);
        IDAColor clr = daStatics.ColorHslAnim(
        daStatics.Mul(daStatics.getLocalTime(), daStatics.DANumber(0.123)), num1, num2);
        // Contstruct a 12pt font and a text image
        IDAFontStyle Font = daStatics.Font("ms sans serif", 10, clr);
        txtImg = daStatics.StringImage("NewJawin API Demo1", Font);
        // Move the text image across the page
        IDANumber pos = daStatics.Mul(daStatics.Sin(daStatics.getLocalTime()), daStatics.DANumber(0.02));
        IDANumber scl = daStatics.Add(daStatics.DANumber(2), daStatics.Abs(daStatics.Mul(
        daStatics.Sin(daStatics.getLocalTime()), daStatics.DANumber(3))));
        IDATransform2 xf = daStatics.Compose2(daStatics.Translate2Anim(daStatics.DANumber(0), pos),
        daStatics.Scale2UniformAnim(scl));
        txtImg = txtImg.Transform(xf);
        IDATransform2 bgr = daStatics.Rotate3RateDegrees(daStatics.Vector3(1, 1, 1), 45).ParallelTransform2();
        txtImg = txtImg.Transform(bgr);
    }
    
    public synchronized void selectFilter(int i) throws COMException {
        currSel = i;
        if(i > 1)
            i += skip;
        DispatchPtr filter = null;
        String[] strCopyright = new String[1];
        davControl.Pause();
        switch(i) {
            case 0:
                finalImage = davControl.getImage();
                finalImage.SwitchTo(new IDABehavior(txtImg));
                break;
            case 1:
                if(davControl != null) {
                    IDAImage sourceImg = new IDAImage(sourceImg0);
                    if(sizeCalculated)
                        sourceImg = sourceImg.Transform(daStatics.Scale2Anim(xScale, yScale));
                    sourceImg = new IDA3Image(sourceImg).ImageQuality(256);
                    sourceImg = daStatics.Overlay(sourceImg, bkImg);
                    finalImage.SwitchTo(new IDABehavior(sourceImg));
                }
                break;
            case 2:
                filter = wrapTransformer("DXImageTransform.MetaCreations.BurnFilm", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 3:
                filter = wrapTransformer("DXImageTransform.MetaCreations.CenterCurls", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 4:
                filter = wrapTransformer("DXImageTransform.MetaCreations.ColorFade", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 5:
                filter = wrapTransformer("DXImageTransform.MetaCreations.Curls", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 6:
                filter = wrapTransformer("DXImageTransform.MetaCreations.Curtains", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 7:
                filter = wrapTransformer("DXImageTransform.MetaCreations.FadeWhite", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 8:
                filter = wrapTransformer("DXImageTransform.MetaCreations.FlowMotion", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 9:
                filter = wrapTransformer("DXImageTransform.MetaCreations.GlassBlock", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 10:
                filter = wrapTransformer("DXImageTransform.MetaCreations.Grid", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 11:
                filter = wrapTransformer("DXImageTransform.MetaCreations.Jaws", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 12:
                filter = wrapTransformer("DXImageTransform.MetaCreations.Lens", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 13:
                filter = wrapTransformer("DXImageTransform.MetaCreations.LightWipe", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 14:
                filter = wrapTransformer("DXImageTransform.MetaCreations.Liquid", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 15:
                filter = wrapTransformer("DXImageTransform.MetaCreations.PageCurl", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 16:
                filter = wrapTransformer("DXImageTransform.MetaCreations.PeelABCD", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 17:
                filter = wrapTransformer("DXImageTransform.MetaCreations.Ripple", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 18:
                filter = wrapTransformer("DXImageTransform.MetaCreations.RollDown", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 19:
                filter = wrapTransformer("DXImageTransform.MetaCreations.Threshold", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 20:
                filter = wrapTransformer("DXImageTransform.MetaCreations.Twister", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 21:
                filter = wrapTransformer("DXImageTransform.MetaCreations.Vacuum", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 22:
                filter = wrapTransformer("DXImageTransform.MetaCreations.Water", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 23:
                filter = wrapTransformer("DXImageTransform.MetaCreations.Wormhole", strCopyright);
                //filter.put("Copyright", strCopyright[0]);
                break;
            case 24:
                filter = new DispatchPtr("DXImageTransform.Microsoft.CrBarn");
                break;
            case 25:
                filter = new DispatchPtr("DXImageTransform.Microsoft.CrBlinds");
                break;
            case 26:
                filter = new DispatchPtr("DXImageTransform.Microsoft.Fade");
                break;
            case 27:
                filter = new DispatchPtr("DXImageTransform.Microsoft.CrInset");
                break;
            case 28:
                filter = new DispatchPtr("DXImageTransform.Microsoft.CrIris");
                break;
            case 29:
                filter = new DispatchPtr("DXImageTransform.Microsoft.Pixelate");
                break;
            case 30:
                filter = new DispatchPtr("DXImageTransform.Microsoft.CrRadialWipe");
                break;
            case 31:
                filter = new DispatchPtr("DXImageTransform.Microsoft.CrSlide");
                break;
            case 32:
                filter = new DispatchPtr("DXImageTransform.Microsoft.CrSpiral");
                break;
            case 33:
                filter = new DispatchPtr("DXImageTransform.Microsoft.CrStretch");
                break;
            case 34:
                filter = new DispatchPtr("DXImageTransform.Microsoft.CrWheel");
                break;
            case 35:
                filter = new DispatchPtr("DXImageTransform.Microsoft.Wipe");
                break;
            case 36:
                filter = new DispatchPtr("DXImageTransform.Microsoft.CrZigZag");
                break;
            default:
                break;
        }
        if(filter != null) {
            RunFilter(filter);
        }
        davControl.Resume();
    }
    
    private void RunFilter(DispatchPtr filter) throws COMException {
        if(filter == null || davControl == null)
            return;
        IDA3Statics daStatics = new IDA3Statics(davControl.getMeterLibrary());
        IDAImage sourceImg = null;
        Object[] safeArray = new Object[2];
        safeArray[0] = sourceImg0;
        safeArray[1] = sourceImg1;
        IDABehavior daBehavior = daStatics.Sequence(daStatics.DANumber(0).Duration(2),
        daStatics.Sequence(new IDABehavior(daStatics.Interpolate(0, 1, 10)),
        new IDABehavior(daStatics.Interpolate(1, 0, 10)))).RepeatForever();
        sourceImg = new IDAImage(daStatics.ApplyDXTransform(filter, safeArray, daBehavior).getOutputBvr());
        sourceImg = new IDA3Image(sourceImg).ImageQuality(256);
        if(sizeCalculated)
            sourceImg = sourceImg.Transform(daStatics.Scale2Anim(xScale, yScale));
        sourceImg = daStatics.Overlay(sourceImg, bkImg);
        finalImage = davControl.getImage();
        finalImage.SwitchTo(new IDABehavior(sourceImg));
    }
}
