/*
 * WebBrowserComponent.java
 *
 * Created on December 11, 2002, 10:51 AM
 */

import com.develop.jawin.*;
import com.develop.io.*;
import com.develop.jawin.win32.*;
import java.awt.*;
import SHDocVw.*;

interface CommandStateChangeConstants {
    final static int CSC_UPDATECOMMANDS = 0xFFFFFFFF;
    final static int CSC_NAVIGATEFORWARD = 0x00000001;
    final static int CSC_NAVIGATEBACK = 0x00000002;
};


/**
 *
 * @author  Cyril
 */
public class WebBrowserComponent extends AXComponent
implements DWebBrowserEvents2,
com.develop.jawin.constants.DispatchConstants {
    
    boolean bMayNavBack = false;
    boolean bMayNavForward = false;
    public IWebBrowser2 control;
    private Object parent;
    private Object listener;
    
    /** Creates a new instance of WebBrowserComponent */
    public WebBrowserComponent(Object parent)  throws COMException {
        super(WebBrowser.clsID);
        this.parent = parent;
    }
    
    public void initInstance() throws COMException {
        control = new IWebBrowser2(getControl());
        //control.toGITRef();
        listener = control.addEventListener(DWebBrowserEvents2.class, this);
        Navigate("http://www.simtel.net");
    }
    
    public void exitInstance() throws COMException {
        control.close();
    }
    
    public void Navigate(java.lang.String URL) {
        try{
            if(control != null)
                control.Navigate(URL);
        }catch(COMException e) {
            e.printStackTrace();
        }
    }
    
    public void outputBody() {
        try{
            MSHTML.IHTMLDocument2 doc = new MSHTML.IHTMLDocument2(control.getDocument());
            //MSHTML.IHTMLElementCollection ecol = doc.getplugins();
            //int len = ecol.getlength();
            //for(int i = 0; i < len; i++) {
            //    System.out.println(ecol.item(new Integer(i)));
            //}
            MSHTML.DispHTMLBody body = new MSHTML.DispHTMLBody(doc.getbody());
            String str = body.getouterHTML();
            System.out.println(str);
        }catch(COMException e) {
            e.printStackTrace();
        }
    }
    
    public void GoForward() {
        try{
            if(bMayNavBack)
                control.GoForward();
        }catch(COMException e){
            e.printStackTrace();
        }
    }
    
    public void GoBack() {
        try{
            if(bMayNavBack)
                control.GoBack();
        }catch(COMException e){
            e.printStackTrace();
        }
    }
    
    public void Print() {
        try{
            control.ExecWB(OLECMDID.OLECMDID_PRINTPREVIEW, OLECMDEXECOPT.OLECMDEXECOPT_DODEFAULT);
        }catch(COMException e){
            e.printStackTrace();
        }
    }
    
    public void BeforeNavigate(Object srcObj, java.lang.String URL, int Flags, java.lang.String TargetFrameName, java.lang.Object PostData, java.lang.String Headers, ObjectRef Cancel) throws COMException {
        ((WebBrowserExample)parent).urlField.setText(URL);
    }
    
    public void CommandStateChange(Object srcObj, int Command, boolean Enable) throws COMException {
        String strCommand = "";
        try{
            switch(Command) {
                case CommandStateChangeConstants.CSC_UPDATECOMMANDS:
                    strCommand = "CSC_UPDATECOMMANDS";
                    break;
                case CommandStateChangeConstants.CSC_NAVIGATEFORWARD:
                    strCommand = "CSC_NAVIGATEFORWARD";
                    bMayNavForward = Enable;
                    ((WebBrowserExample)parent).forwardButton.enable(bMayNavForward);
                    break;
                case CommandStateChangeConstants.CSC_NAVIGATEBACK:
                    strCommand = "CSC_NAVIGATEBACK";
                    bMayNavBack = Enable;
                    ((WebBrowserExample)parent).backButton.enable(bMayNavBack);
                    break;
                default:
                    break;
            }
        }catch(Exception e){}
    }
    
    public void DownloadBegin(Object srcObj) throws COMException {
        System.out.println("DownloadBegin");
    }
    
    public void DownloadComplete(Object srcObj) throws COMException {
        System.out.println("DownloadComplete");
    }
    
    public void FrameBeforeNavigate(Object srcObj, java.lang.String URL, int Flags, java.lang.String TargetFrameName, java.lang.Object PostData, java.lang.String Headers, ObjectRef Cancel) throws COMException {
        System.out.println("FrameBeforeNavigate");
    }
    
    public void FrameNavigateComplete(Object srcObj, java.lang.String URL) throws COMException {
        System.out.println("FrameNavigateComplete");
    }
    
    public void FrameNewWindow(Object srcObj, java.lang.String URL, int Flags, java.lang.String TargetFrameName, java.lang.Object PostData, java.lang.String Headers, ObjectRef Processed) throws COMException {
        System.out.println("FrameNewWindow");
    }
    
    public void NavigateComplete(Object srcObj, java.lang.String URL) throws COMException {
        System.out.println("NavigateComplete");
    }
    
    public void NewWindow(Object srcObj, java.lang.String URL, int Flags, java.lang.String TargetFrameName, java.lang.Object PostData, java.lang.String Headers, ObjectRef Processed) throws COMException {
        System.out.println("NewWindow");
    }
    
    public void ProgressChange(Object srcObj, int Progress, int ProgressMax) throws COMException {
        System.out.println("ProgressChange");
    }
    
    public void PropertyChange(Object srcObj, java.lang.String Property) throws COMException {
        System.out.println("PropertyChange");
    }
    
    public void Quit(Object srcObj, ObjectRef Cancel) throws COMException {
        System.out.println("Quit");
    }
    
    public void StatusTextChange(Object srcObj, java.lang.String Text) throws COMException {
        System.out.println("StatusTextChange");
    }
    
    public void TitleChange(Object srcObj, java.lang.String Text) throws COMException {
        System.out.println("TitleChange");
    }
    
    public void WindowActivate(Object srcObj) throws COMException {
        System.out.println("WindowActivate");
    }
    
    public void WindowMove(Object srcObj) throws COMException {
        System.out.println("WindowMove");
    }
    
    public void WindowResize(Object srcObj) throws COMException {
        System.out.println("WindowResize");
    }
    
    public void BeforeNavigate2(Object srcObj, DispatchPtr pDisp, ObjectRef  URL, ObjectRef  Flags, ObjectRef  TargetFrameName, ObjectRef  PostData, ObjectRef  Headers, ObjectRef  Cancel) throws COMException {
        System.out.println("BeforeNavigate2");
    }
    
    public void DocumentComplete(Object srcObj, DispatchPtr pDisp, java.lang.Object URL) throws COMException {
        System.out.println("DocumentComplete");
    }
    
    public void NavigateComplete2(Object srcObj, DispatchPtr pDisp, java.lang.Object URL) throws COMException {
        System.out.println("NavigateComplete2");
    }
    
    public void NewWindow2(Object srcObj, ObjectRef ppDisp, ObjectRef Cancel) throws COMException {
        System.out.println("NewWindow2");
        //        Cancel.setRef(new Boolean(true));
    }
    
    public void OnFullScreen(Object srcObj, boolean FullScreen) throws COMException {
        System.out.println("OnFullScreen");
    }
    
    public void OnMenuBar(Object srcObj, boolean MenuBar) throws COMException {
        System.out.println("OnMenuBar");
    }
    
    public void OnQuit(Object srcObj) throws COMException {
        System.out.println("OnQuit");
    }
    
    public void OnStatusBar(Object srcObj, boolean StatusBar) throws COMException {
        System.out.println("OnStatusBar");
    }
    
    public void OnTheaterMode(Object srcObj, boolean TheaterMode) throws COMException {
        System.out.println("OnTheaterMode");
    }
    
    public void OnToolBar(Object srcObj, boolean ToolBar) throws COMException {
        System.out.println("OnToolBar");
    }
    
    public void OnVisible(Object srcObj, boolean Visible) throws COMException {
        System.out.println("OnVisible");
    }
    
    public void ClientToHostWindow(Object srcObj, ObjectRef CX, ObjectRef CY) throws COMException {
    }
    
    public void DocumentComplete(Object srcObj, DispatchPtr pDisp, ObjectRef URL) throws COMException {
    }
    
    public void FileDownload(Object srcObj, ObjectRef Cancel) throws COMException {
        System.out.println("OnVisible");
    }
    
    public void NavigateComplete2(Object srcObj, DispatchPtr pDisp, ObjectRef URL) throws COMException {
    }
    
    public void NavigateError(Object srcObj, DispatchPtr pDisp, ObjectRef URL, ObjectRef Frame, ObjectRef StatusCode, ObjectRef Cancel) throws COMException {
    }
    
    public void PrintTemplateInstantiation(Object srcObj, DispatchPtr pDisp) throws COMException {
    }
    
    public void PrintTemplateTeardown(Object srcObj, DispatchPtr pDisp) throws COMException {
    }
    
    public void PrivacyImpactedStateChange(Object srcObj, boolean bImpacted) throws COMException {
    }
    
    public void SetSecureLockIcon(Object srcObj, int SecureLockIcon) throws COMException {
    }
    
    public void UpdatePageStatus(Object srcObj, DispatchPtr pDisp, ObjectRef nPage, ObjectRef fDone) throws COMException {
    }
    
    public void WindowClosing(Object srcObj, boolean IsChildWindow, ObjectRef Cancel) throws COMException {
    }
    
    public void WindowSetHeight(Object srcObj, int Height) throws COMException {
    }
    
    public void WindowSetLeft(Object srcObj, int Left) throws COMException {
    }
    
    public void WindowSetResizable(Object srcObj, boolean Resizable) throws COMException {
    }
    
    public void WindowSetTop(Object srcObj, int Top) throws COMException {
    }
    
    public void WindowSetWidth(Object srcObj, int Width) throws COMException {
    }
    
}
