/*
 * Decompiled with CFR 0.152.
 */
package com.develop.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianInputStream
extends FilterInputStream
implements DataInput {
    public LittleEndianInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public final int read(byte[] byArray) throws IOException {
        return this.in.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public final void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        InputStream inputStream = this.in;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = inputStream.read(byArray, n + n3, n2 - n3);
            if (n4 < 0) {
                throw new EOFException();
            }
            n3 += n4;
        }
    }

    public final int skipBytes(int n) throws IOException {
        InputStream inputStream = this.in;
        int n2 = 0;
        int n3 = 0;
        while (n2 < n && (n3 = (int)inputStream.skip(n - n2)) > 0) {
            n2 += n3;
        }
        return n2;
    }

    public final boolean readBoolean() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n != 0;
    }

    public final byte readByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public final int readUnsignedByte() throws IOException {
        int n = this.in.read();
        if (n < 0) {
            throw new EOFException();
        }
        return n;
    }

    public final short readShort() throws IOException {
        InputStream inputStream = this.in;
        int n = inputStream.read();
        int n2 = inputStream.read();
        if ((n2 | n) < 0) {
            throw new EOFException();
        }
        return (short)((n2 << 8) + (n << 0));
    }

    public final int readUnsignedShort() throws IOException {
        InputStream inputStream = this.in;
        int n = inputStream.read();
        int n2 = inputStream.read();
        if ((n2 | n) < 0) {
            throw new EOFException();
        }
        return (n2 << 8) + (n << 0);
    }

    public final char readChar() throws IOException {
        InputStream inputStream = this.in;
        int n = inputStream.read();
        int n2 = inputStream.read();
        if ((n2 | n) < 0) {
            throw new EOFException();
        }
        return (char)((n2 << 8) + (n << 0));
    }

    public final int readInt() throws IOException {
        InputStream inputStream = this.in;
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if ((n4 | n3 | n2 | n) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }

    public final long readLong() throws IOException {
        InputStream inputStream = this.in;
        int n = this.readInt();
        int n2 = this.readInt();
        return ((long)n2 << 32) + ((long)n & 0xFFFFFFFFL);
    }

    public final String readUnicodeSz(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(n);
        char c = this.readChar();
        while (c != '\u0000') {
            stringBuffer.append(c);
            c = this.readChar();
        }
        return stringBuffer.toString();
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readLine() throws IOException {
        throw new IllegalStateException("No support for LittleEndian readUTF");
    }

    public final String readUTF() throws IOException {
        throw new IllegalStateException("No support for LittleEndian readUTF");
    }

    public static final String readUTF(DataInput dataInput) throws IOException {
        throw new IllegalStateException("No support for LittleEndian readUTF");
    }

    public String readStringUnicode() throws IOException {
        byte by = this.readByte();
        if (by == 0) {
            return null;
        }
        int n = this.readInt();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(this.readChar());
            ++n2;
        }
        return stringBuffer.toString();
    }

    public byte[] readCurrency() throws IOException {
        int n = 8;
        byte[] byArray = new byte[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            byArray[n2] = this.readByte();
            --n2;
        }
        return byArray;
    }
}

