/*
 * Created on Nov 5, 2003
 */
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import com.standbysoft.datepicker.DateSelectionModel;
import com.standbysoft.datepicker.JMonthView;
import com.standbysoft.datepicker.DateSelectionModel.SelectionMode;
import com.standbysoft.datepicker.event.DateSelectionAdapter;
import com.standbysoft.datepicker.event.DateSelectionEvent;

/**
 * This demo shows how to listen for selection changes and how
 * to change the selection type use by the selection model.
 */
public class SimpleSelectionDemo extends JPanel {
	private JMonthView monthView;
	private JLabel selectionTypeLabel;
	private JComboBox selectionTypeComboBox;
	private JTextArea selectionTextArea;
	private JButton clearSelectionButton;

	public SimpleSelectionDemo() {
		selectionTypeLabel = new JLabel("Selection Type:");
		selectionTypeComboBox = new JComboBox(new String[]{"SINGLE", "SINGLE_INTERVAL", "MULTIPLE_INTERVAL"});
		selectionTextArea = new JTextArea(7, 30);
		selectionTextArea.setEditable(false);
		monthView = new JMonthView();
		monthView.addDateSelectionListener(new DateSelectionHandler(selectionTextArea));		
		selectionTypeComboBox.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent evt) {
				String item = (String)evt.getItem();
				
				if (evt.getStateChange() == ItemEvent.SELECTED) {
					if (item.equals("SINGLE")) {
						monthView.getDateSelectionModel().setSelectionMode(SelectionMode.SINGLE);
					} else if (item.equals("SINGLE_INTERVAL")) {
						monthView.getDateSelectionModel().setSelectionMode(SelectionMode.SINGLE_INTERVAL);
					} else if (item.equals("MULTIPLE_INTERVAL")) {
						monthView.getDateSelectionModel().setSelectionMode(SelectionMode.MULTIPLE_INTERVAL);
					}
				}
			}
		});
		selectionTypeComboBox.setSelectedItem("MULTIPLE_INTERVAL");
		clearSelectionButton = new JButton("Clear Text");
		clearSelectionButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				selectionTextArea.setText("");
			}
		});

		setLayout(new GridBagLayout());
		add(monthView, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, GridBagConstraints.NORTH, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(selectionTypeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(selectionTypeComboBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
		add(new JScrollPane(selectionTextArea), new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, GridBagConstraints.CENTER, GridBagConstraints.BOTH, new Insets(0, 5, 5, 5), 0, 0));
		add(clearSelectionButton, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, GridBagConstraints.CENTER, GridBagConstraints.HORIZONTAL, new Insets(0, 5, 5, 5), 0, 0));
	}
	
	private static void createAndShowGUI() {
		//Create and set up the window.
		JFrame frame = new JFrame("SimpleMonthViewSelectionDemo");
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

		//Create and set up the content pane.
		SimpleSelectionDemo newContentPane = new SimpleSelectionDemo();
		newContentPane.setOpaque(true); //content panes must be opaque
		frame.setContentPane(newContentPane);

		//Display the window.
		frame.pack();
		frame.setVisible(true);	
	}

	public static void main(String[] args) {
		//Schedule a job for the event-dispatching thread:
		//creating and showing this application's GUI.
		javax.swing.SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				createAndShowGUI();
			}
		});
	}
	
	class DateSelectionHandler extends DateSelectionAdapter {
		private JTextArea messageArea;
		
		public DateSelectionHandler(JTextArea messageArea) {
			this.messageArea = messageArea;
		}
		
		public void dateSelectionChanged(DateSelectionEvent evt) {
			messageArea.append("[" + evt.getFirstDate() + ", " + evt.getLastDate() + "]");
			messageArea.append("\n");
		}

		public void selectionModeChanged(DateSelectionEvent evt) {
			JMonthView mv = (JMonthView)evt.getSource();
			DateSelectionModel model = mv.getDateSelectionModel();
			
			messageArea.append("----------Mode: " + model.getSelectionMode() + "----------");
			messageArea.append("\n");
		}
	}
}