/*
 * Decompiled with CFR 0.152.
 */
import com.standbysoft.datepicker.DateSelectionModel;
import com.standbysoft.datepicker.JMonthView;
import com.standbysoft.datepicker.event.DateSelectionAdapter;
import com.standbysoft.datepicker.event.DateSelectionEvent;
import com.standbysoft.datepicker.event.DateSelectionListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SimpleSelectionDemo
extends JPanel {
    private JMonthView monthView;
    private JLabel selectionTypeLabel = new JLabel("Selection Type:");
    private JComboBox selectionTypeComboBox = new JComboBox<String>(new String[]{"SINGLE", "SINGLE_INTERVAL", "MULTIPLE_INTERVAL"});
    private JTextArea selectionTextArea = new JTextArea(7, 30);
    private JButton clearSelectionButton;

    public SimpleSelectionDemo() {
        this.selectionTextArea.setEditable(false);
        this.monthView = new JMonthView();
        this.monthView.addDateSelectionListener((DateSelectionListener)new DateSelectionHandler(this.selectionTextArea));
        this.selectionTypeComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                String string = (String)itemEvent.getItem();
                if (itemEvent.getStateChange() == 1) {
                    if (string.equals("SINGLE")) {
                        SimpleSelectionDemo.this.monthView.getDateSelectionModel().setSelectionMode(DateSelectionModel.SelectionMode.SINGLE);
                    } else if (string.equals("SINGLE_INTERVAL")) {
                        SimpleSelectionDemo.this.monthView.getDateSelectionModel().setSelectionMode(DateSelectionModel.SelectionMode.SINGLE_INTERVAL);
                    } else if (string.equals("MULTIPLE_INTERVAL")) {
                        SimpleSelectionDemo.this.monthView.getDateSelectionModel().setSelectionMode(DateSelectionModel.SelectionMode.MULTIPLE_INTERVAL);
                    }
                }
            }
        });
        this.selectionTypeComboBox.setSelectedItem("MULTIPLE_INTERVAL");
        this.clearSelectionButton = new JButton("Clear Text");
        this.clearSelectionButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SimpleSelectionDemo.this.selectionTextArea.setText("");
            }
        });
        this.setLayout(new GridBagLayout());
        this.add((Component)this.monthView, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 11, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.selectionTypeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.selectionTypeComboBox, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)new JScrollPane(this.selectionTextArea), new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.clearSelectionButton, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
    }

    private static void createAndShowGUI() {
        JFrame jFrame = new JFrame("SimpleMonthViewSelectionDemo");
        jFrame.setDefaultCloseOperation(3);
        SimpleSelectionDemo simpleSelectionDemo = new SimpleSelectionDemo();
        simpleSelectionDemo.setOpaque(true);
        jFrame.setContentPane(simpleSelectionDemo);
        jFrame.pack();
        ((Component)jFrame).setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SimpleSelectionDemo.createAndShowGUI();
            }
        });
    }

    class DateSelectionHandler
    extends DateSelectionAdapter {
        private JTextArea messageArea;

        public DateSelectionHandler(JTextArea jTextArea) {
            this.messageArea = jTextArea;
        }

        public void dateSelectionChanged(DateSelectionEvent dateSelectionEvent) {
            this.messageArea.append("[" + dateSelectionEvent.getFirstDate() + ", " + dateSelectionEvent.getLastDate() + "]");
            this.messageArea.append("\n");
        }

        public void selectionModeChanged(DateSelectionEvent dateSelectionEvent) {
            JMonthView jMonthView = (JMonthView)dateSelectionEvent.getSource();
            DateSelectionModel dateSelectionModel = jMonthView.getDateSelectionModel();
            this.messageArea.append("----------Mode: " + dateSelectionModel.getSelectionMode() + "----------");
            this.messageArea.append("\n");
        }
    }
}

