/*
 * Decompiled with CFR 0.152.
 */
package javazoom.download;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javazoom.download.DownloadFolderSource;
import javazoom.download.DownloadListener;
import javazoom.download.DownloadSource;
import javazoom.download.DownloadZipSource;
import javazoom.download.util.Base64;
import javazoom.download.util.Config;
import javazoom.download.util.ConfigHandler;
import javazoom.download.util.DatabaseConfig;
import javazoom.download.util.Debug;
import javazoom.download.util.FileInfo;
import javazoom.download.util.FolderConfig;
import javazoom.download.util.MimeHandler;
import javazoom.download.util.ZipConfig;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DownloadImpl {
    public static String REALM = "Download4J Realm";
    public static String DEFAULTCONTENTTYPE = "application/unknown";
    public static String ZIPCONTENTTYPE = "application/zip";
    public static String DEFAULTCONTENTDISPOSITION = "";
    public static String LOGFILENAME = "download4j";
    public static String LOGFILEEXTENSION = ".log";
    public static String LOGFILEDATEFORMAT = "-yyyy-MM-dd_HH-mm";
    public static int UNKNOWN = -1;
    public static int FOLDER = 0;
    public static int ZIP = 1;
    public static int DATABASE = 2;
    private Config _$502 = null;
    private DownloadSource _$505 = null;
    private Properties _$507 = null;
    private DownloadListener _$509 = null;
    static /* synthetic */ Class class$javazoom$download$util$Config;

    public DownloadImpl(String string, String string2, DownloadListener downloadListener) throws IOException, ParserConfigurationException, SAXException {
        String string3;
        this._$509 = downloadListener;
        string2 = string2.replace('\\', '/').replace('/', File.separatorChar);
        string = string.replace('\\', '/').replace('/', File.separatorChar);
        String string4 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string))).append(File.separatorChar).append(string2)));
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        ConfigHandler configHandler = new ConfigHandler(string);
        sAXParser.parse(new File(string4), (DefaultHandler)configHandler);
        Debug debug = Debug.getInstance();
        debug.setLogLevel(configHandler.getLogLevel());
        String string5 = configHandler.getLogFolder();
        if (string5 != null) {
            string5 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string5))).append("/").append(LOGFILENAME).append(new SimpleDateFormat(LOGFILEDATEFORMAT).format(new Date())).append(LOGFILEEXTENSION)));
            string5 = string5.replace('\\', '/').replace('/', File.separatorChar);
            debug.setFileWriter(string5);
        }
        this._$502 = configHandler.getConfig();
        if (this._$502 instanceof FolderConfig) {
            this._$505 = new DownloadFolderSource(this._$502);
        } else if (this._$502 instanceof ZipConfig) {
            this._$505 = new DownloadZipSource(this._$502);
        } else if (this._$502 instanceof DatabaseConfig) {
            try {
                string3 = ((DatabaseConfig)this._$502).getImplementation();
                this._$505 = this._$543(string3);
                this._$544(Debug.INFO, String.valueOf(String.valueOf(string3)).concat(" loaded"));
            }
            catch (Exception exception) {
                this._$544(0, exception.getMessage());
            }
        }
        string3 = String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this._$502.getProperties().getProperty("PATH")))).append(File.separatorChar).append(this._$502.getProperties().getProperty("CONTENT-TYPE-FILE"))));
        string3 = string3.replace('\\', '/').replace('/', File.separatorChar);
        MimeHandler mimeHandler = new MimeHandler();
        sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(new File(string3), (DefaultHandler)mimeHandler);
        this._$507 = mimeHandler.getMimes();
        if (downloadListener != null) {
            downloadListener.update(this._$502.getFiles());
        }
        this._$544(Debug.DEBUG, "DownloadImpl initialized successfully");
    }

    public void process(String string, Properties properties, HttpServletResponse httpServletResponse) throws IOException {
        String string2;
        String string3;
        int n;
        String string4;
        Object object;
        int n2;
        String string5 = properties.getProperty("Authorization");
        String string6 = properties.getProperty("RemoteAddr");
        FileInfo fileInfo = null;
        Vector vector = this._$502.getFiles();
        for (n2 = 0; n2 < vector.size(); ++n2) {
            object = (FileInfo)vector.elementAt(n2);
            if (!((FileInfo)object).getUrlMapping().equals(string)) continue;
            fileInfo = object;
            break;
        }
        if (fileInfo == null) {
            Properties properties2 = this._$502.getProperties();
            object = this._$507.getProperty(FileInfo.getExtension(string));
            if (object == null) {
                object = DEFAULTCONTENTTYPE;
            }
            if ((string4 = properties2.getProperty("CONTENT-DISPOSITION")) == null) {
                string4 = "";
            }
            n = 0;
            string3 = properties2.getProperty("ZIP");
            if (string3 != null && string3.equalsIgnoreCase("enabled")) {
                n = 1;
            }
            string2 = null;
            if (this._$502 instanceof FolderConfig) {
                string2 = ((FolderConfig)this._$502).getPath();
            } else if (this._$502 instanceof ZipConfig) {
                string2 = ((ZipConfig)this._$502).getPath();
            }
            fileInfo = new FileInfo(string2, string, string, (String)object, string4, n != 0, -1, properties2.getProperty("LOGIN"), properties2.getProperty("PASSWORD"));
            vector.addElement(fileInfo);
        }
        string = fileInfo.getFilename();
        if (string5 != null && string5.toLowerCase().startsWith("basic")) {
            string5 = string5.substring(string5.lastIndexOf(" ") + 1, string5.length());
        }
        if ((n2 = this.checkAuth(string5, fileInfo)) != -1) {
            this._$544(Debug.INFO, String.valueOf(String.valueOf(new StringBuffer("WWW-Authenticate for ").append(string).append(" [").append(string6).append(",").append(string5).append("]"))));
            if (n2 == 1) {
                httpServletResponse.setHeader("WWW-Authenticate", String.valueOf(String.valueOf(new StringBuffer("BASIC realm=\"").append(REALM).append("\""))));
                httpServletResponse.sendError(401);
                return;
            }
        }
        if (fileInfo.getMaxDownload() > 0 && fileInfo.getTotalDownload() >= fileInfo.getMaxDownload()) {
            httpServletResponse.sendError(403, "Downloads limit reached");
            return;
        }
        object = fileInfo.getContentType();
        if (object == null && (object = this._$507.getProperty(FileInfo.getExtension(string))) == null) {
            object = DEFAULTCONTENTTYPE;
        }
        if ((string4 = fileInfo.getContentDisposition()) == null) {
            string4 = DEFAULTCONTENTDISPOSITION;
        }
        if (fileInfo.isZipEnabled()) {
            object = ZIPCONTENTTYPE;
        }
        if ((n = this.getDataLength(fileInfo)) > 0) {
            try {
                string3 = "".concat(String.valueOf(String.valueOf(n)));
                httpServletResponse.setContentType((String)object);
                if (string4 != null && !string4.equals("")) {
                    httpServletResponse.setHeader("Content-Disposition", String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(string4))).append(";filename=").append(fileInfo.getFilename()))));
                }
                if (!fileInfo.isZipEnabled()) {
                    httpServletResponse.setContentLength(n);
                } else {
                    string3 = "- zipped on the fly - ???";
                }
                this._$544(Debug.INFO, String.valueOf(String.valueOf(new StringBuffer("Start downloading : ").append(string).append(" ").append(string3).append(" bytes (").append((String)object).append(") ").append(string4))));
                string2 = httpServletResponse.getOutputStream();
                this.download(fileInfo, (OutputStream)((Object)string2));
                this._$601(fileInfo, true);
                this._$544(Debug.INFO, String.valueOf(String.valueOf(new StringBuffer("Download successfull [").append(fileInfo.getTotalDownload()).append("] : ").append(string))));
            }
            catch (IOException iOException) {
                this._$544(Debug.INFO, String.valueOf(String.valueOf(new StringBuffer("Download ").append(string).append(" cancelled : ").append(iOException.getMessage()))));
                this._$601(fileInfo, false);
            }
        } else if (n == 0) {
            httpServletResponse.sendError(204);
        } else {
            this._$544(Debug.DEBUG, String.valueOf(String.valueOf(new StringBuffer("Download ").append(string).append(" failed : Not exist or not readable"))));
            httpServletResponse.sendError(404);
        }
    }

    public int checkAuth(String string, FileInfo fileInfo) {
        String string2 = fileInfo.getLogin();
        String string3 = fileInfo.getPassword();
        return this.checkAuth(string, string2, string3);
    }

    public int checkAuth(String string, String string2, String string3) {
        if (string2 != null && !string2.equals("") && string3 != null && !string3.equals("")) {
            if (string != null && !string.equals("")) {
                String string4 = new String(Base64.decode(string));
                StringTokenizer stringTokenizer = new StringTokenizer(string4, ":");
                String string5 = null;
                String string6 = null;
                if (stringTokenizer.hasMoreTokens()) {
                    string5 = stringTokenizer.nextToken();
                }
                if (stringTokenizer.hasMoreTokens()) {
                    string6 = stringTokenizer.nextToken();
                }
                if (string5 != null && string5.equals(string2) && string6 != null && string6.equals(string3)) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }
        return -1;
    }

    public int getDataLength(FileInfo fileInfo) {
        if (this._$505 == null) {
            return -1;
        }
        return this._$505.getDataLength(fileInfo);
    }

    public void download(FileInfo fileInfo, OutputStream outputStream) throws IOException {
        if (this._$505 != null) {
            this._$505.download(fileInfo, outputStream);
        }
    }

    private void _$601(FileInfo fileInfo, boolean bl) {
        if (bl) {
            fileInfo.addDownload();
        } else {
            fileInfo.addIncompleteDownload();
        }
        if (this._$509 != null) {
            this._$509.updateFilename(fileInfo.getFilename());
        }
    }

    private DownloadSource _$543(String string) throws Exception {
        if (string != null) {
            Class<?> clazz = Class.forName(string);
            Class<?> clazz2 = clazz.getSuperclass();
            if (clazz2.getName().equals("javazoom.download.DownloadSource")) {
                Class[] classArray = new Class[]{class$javazoom$download$util$Config == null ? (class$javazoom$download$util$Config = DownloadImpl.class$("javazoom.download.util.Config")) : class$javazoom$download$util$Config};
                Constructor<?> constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{this._$502};
                DownloadSource downloadSource = (DownloadSource)constructor.newInstance(objectArray);
                return downloadSource;
            }
            throw new Exception("Wrong super class : ".concat(String.valueOf(String.valueOf(string))));
        }
        return null;
    }

    private void _$544(int n, String string) {
        Debug.getInstance().trace(n, String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(this.getClass().getName()))).append(": ").append(string))));
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

