<%
' These variables will be available to all scripts.

Dim mb, si
Dim ai ' PDA only
Dim at, ci, da
Dim fi, flt, fly
Dim fn ' WAP only
Dim hb ' PDA only
Dim km
Dim mdy, hm ' WAP only
Dim mi
Dim mo, dy, yr ' PDA only
Dim mn, mt, pg, pge, pn
Dim rb, rc, re, rs, rt, ry
Dim st
Dim objStatusMessage, strParamsText
Dim objSession, objFolder, objTopPublicFolder
Dim objRenderApplication, objRenderer
Dim errorCode
Dim blnCanRead, blnCanReadMessages, blnCanReadFolders, blnCanModifyObject, blnCanCreateInFolder

CONST OPWCMN = 1 : CONST OPWCMR = 2 : CONST OPWCMA = 4 : CONST OPWCMF = 8 : CONST OPWCME = 16
CONST OPWMTMASK = 31
CONST OPWFRMB = 32 : CONST OPWFRFO = 64 : CONST OPWFRMR = 128

timeZones = Array(24, 19, 14, 46, 38, 7, 9, _
 29, 26, 22, 45, 4, 35, 23, 18, 32, 49, _
 33, 11, 44, 10, 5, 39, 40, 1, 43, 50, _
 15, 42, 21, 34, 47, 27, 48, 2, 41, 52, _
 37, 30, 16, 31, 51, 12, 28, 0, 13, 3, _
 6, 8, 36, 25, 20, 16385, 17)

timeZoneOffsets = Array(4, 9.5, -9, 6, -7, 2, -4, _
 -1, 3, 7, 8, 1, -5, 5.5, 10, -3, 2, _
 -4, -6, 9.5, -5, 2, -12, 12, 0, 10, 2, _
 -10, 10, 8, -5, 5, 2, 4.5, 0, 11, 0, _
 -6, -2, -11, 0, 3, -7, -3.5, 12, -8, 1, _
 1, -3, -6, 3.5, 9, 0, 12)

Dim blnTopFolderFound

Function checkTopFolder(inFolderID, inDefaultFolderNum)

  Dim locObjFolder, locObjDefaultFolder

  blnTopFolderFound = False
  Set locObjFolder = objSession.GetFolder(inFolderID)
  If Not locObjFolder.IsSameAs(objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder) Then
    Set locObjDefaultFolder = objSession.GetDefaultFolder(inDefaultFolderNum)
    If locObjFolder.IsSameAs(locObjDefaultFolder) Then
      blnTopFolderFound = True
    Else
      If Not(objSession.GetFolder(locObjFolder.FolderID).IsSameAs(objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder)) Then
        checkTopFolder objSession.GetFolder(locObjFolder.FolderID).ID, inDefaultFolder
      End If
    End If
    Set locObjDefaultFolder = Nothing
  End If
  Set locObjFolder = Nothing
  checkTopFolder = blnTopFolderFound

End Function

Sub clearObjects

  Set objAddressEntries = Nothing
  Set objAddressEntry = Nothing
  Set objAttachment = Nothing
  Set objField = Nothing
  Set objFilter = Nothing
  Set objFolder = Nothing
  Set objFolder2 = Nothing
  Set objFolders = Nothing
  Set objFolders2 = Nothing
  Set objGAL = Nothing
  Set objMessage = Nothing
  Set objMessages = Nothing
  Set objOneRecip = Nothing
  Set objTopPublicFolder = Nothing

End Sub

Function compressID(inID)

  inID = Replace(inID, "00000000", "g")
  inID = Replace(inID, "000000", "h")
  inID = Replace(inID, "0000", "i")
  inID = Replace(inID, "00", "j")
  inID = Replace(inID, "11", "k")
  inID = Replace(inID, "22", "l")
  inID = Replace(inID, "33", "m")
  inID = Replace(inID, "44", "n")
  inID = Replace(inID, "55", "o")
  inID = Replace(inID, "66", "p")
  inID = Replace(inID, "77", "q")
  inID = Replace(inID, "88", "r")
  inID = Replace(inID, "99", "s")
  inID = Replace(inID, "AA", "t")
  inID = Replace(inID, "BB", "u")
  inID = Replace(inID, "CC", "v")
  inID = Replace(inID, "DD", "w")
  inID = Replace(inID, "EE", "x")
  inID = Replace(inID, "FFFF", "y")
  inID = Replace(inID, "FF", "z")
  compressID = inID

End Function

Function daysInMonth(inMonth, inYear)

  daysInMonth = Day(DateAdd("d", -1, DateSerial(inYear, inMonth + 1, 1)))

End Function

Function displayEncode(textIn)

  ' Not doing &nbsp; to save page space.
  textIn = Server.HTMLEncode(textIn)
  textIn = Replace(textIn, "'", "&apos;")
  textIn = Replace(textIn, "$", "$$")
  textIn = Replace(textIn, vbCrLf, "<br/>" & vbCrLf)
  displayEncode = textIn

End Function

Function doFolderCaption(inFolder)

  locCaption = inFolder.Name
  locUnread = inFolder.Fields.Item(&H36030003) ' CdoPR_CONTENT_UNREAD
  If locUnread > 0 Then
    locCaption = locCaption & "(" & locUnread & ")"
  End If
  doFolderCaption = locCaption

End Function

Function expandID(inID)

  inID = Replace(inID, "g", "00000000")
  inID = Replace(inID, "h", "000000")
  inID = Replace(inID, "i", "0000")
  inID = Replace(inID, "j", "00")
  inID = Replace(inID, "k", "11")
  inID = Replace(inID, "l", "22")
  inID = Replace(inID, "m", "33")
  inID = Replace(inID, "n", "44")
  inID = Replace(inID, "o", "55")
  inID = Replace(inID, "p", "66")
  inID = Replace(inID, "q", "77")
  inID = Replace(inID, "r", "88")
  inID = Replace(inID, "s", "99")
  inID = Replace(inID, "t", "AA")
  inID = Replace(inID, "u", "BB")
  inID = Replace(inID, "v", "CC")
  inID = Replace(inID, "w", "DD")
  inID = Replace(inID, "x", "EE")
  inID = Replace(inID, "y", "FFFF")
  inID = Replace(inID, "z", "FF")
  expandID = inID

End Function

Dim locFolderCounter

Sub findFolder

  Dim locFi

  If OPWDEBUG Then rwbc "Getting Folder: " & fi
  If (Len(fi) = 3) And (Left(fi, 2) = "DF") Then
    locFi = Replace(fi, "DF", "")
    Set objFolder = objSession.GetDefaultFolder(locFi)
  Else
    If CStr(fi) = "0" Then
      Set objFolder = objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder
    Else
      If Len(fi) > 10 Then
        Set objFolder = objSession.GetFolder(fi)

        ' Need to correctly identify Calendar folder !
        If objFolder.IsSameAs(objSession.GetDefaultFolder(0)) Then Set objFolder = objSession.GetDefaultFolder(0)
      Else
        locFolderCounter = 0
        Set locObjFolder = objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder
        findFolder2 locObjFolder, True
        Set locObjFolder = Nothing
      End If
    End If
  End If
  If objFolder Is Nothing Then
    rwbc "Can't get folder."
    Response.End
  End If
  getAccess(objFolder)

End Sub

Sub findFolder2(inObjFolder, inBlnFirstIteration)

  Dim locLngObjectACL, locBlnCanRead, locObjFolder

  locFolderCounter = locFolderCounter + 1

  ' Check access to folder (Exchange 5.5 fails without this).
  locLngObjectACL = inObjFolder.Fields(&H0FF40003) ' CdoPR_ACCESS
  locBlnCanRead = (locLngObjectACL And &H00000002) <> 0 ' MAPI_ACCESS_READ
  If locBlnCanRead Then
    If locFolderCounter = fi Then
      Set objFolder = inObjFolder
    Else
      For Each locObjFolder In inObjFolder.Folders
        If inBlnFirstIteration Then

          ' Need to correctly identify Calendar folder !
          If locObjFolder.IsSameAs(objSession.GetDefaultFolder(0)) Then Set locObjFolder = objSession.GetDefaultFolder(0)
        End If
        findFolder2 locObjFolder, False
      Next
      Set locObjFolder = Nothing
    End If
  End If

End Sub

Dim locFolderNumber

Function findFolderNumber(inFolderID)

  Dim locObjFolders, locObjFolder

  If USELONGFOLDERIDS Then
    locFolderNumber = inFolderID
  Else
    If inFolderID = objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder.ID Then
      locFolderNumber = 0
    Else
      locFolderCounter = 0
      Set locObjFolder = objSession.GetInfoStore(objSession.Inbox.StoreID).RootFolder
      findFolderNumber2 locObjFolder, inFolderID
      Set locObjFolder = Nothing
    End If
  End If
  findFolderNumber = locFolderNumber

End Function

Sub findFolderNumber2(inFolder, inFolderID)

  Dim locLngObjectACL, locBlnCanRead, locObjFolder

  locFolderCounter = locFolderCounter + 1
  If inFolder.ID = inFolderID Then locFolderNumber = locFolderCounter
  ' Check access to folder (Exchange 5.5 fails without this).
  locLngObjectACL = inFolder.Fields(&H0FF40003) ' CdoPR_ACCESS
  locBlnCanRead = (locLngObjectACL And &H00000002) <> 0 ' MAPI_ACCESS_READ
  If locBlnCanRead Then
    ' inFolder.Folders sometimes returned MAPI_E_NOT_FOUND(8004010F) error on THK E5.5 server
    locT = 0
    If SHOWERRORS Then On Error Resume Next
    locT = inFolder.Folders.Count
    If SHOWERRORS Then On Error Goto 0
    If locT > 0 Then
      For Each locObjFolder In inFolder.Folders
        findFolderNumber2 locObjFolder, inFolderID
      Next
    End If
  End If

End Sub

Sub findPFolder

  On Error Resume Next

  findTopPublicFolder
  If CStr(fi) = "0" Then
    Set objFolder = objTopPublicFolder
  Else
    If Len(fi) > 10 Then
      For Each locObjInfoStore In objSession.InfoStores
        Set objFolder = objSession.GetFolder(fi, locObjInfoStore.ID)
        If Not(objFolder Is Nothing) Then Exit For
      Next
    Else
      locFolderCounter = 0
      Set locObjFolder = objTopPublicFolder
      findFolder2 locObjFolder, True
      Set locObjFolder = Nothing
    End If
  End if
  If objFolder Is Nothing Then
    rwbc "Can't get folder."
    Response.End
  End If
  getAccess(objFolder)

End Sub

Function findPFolderNumber(inFolderID)

  Dim locObjFolders, locObjFolder

  If USELONGPFOLDERIDS Then
    locFolderNumber = inFolderID
  Else
    locFolderNumber = 0 ' Sometimes can't find a match!
    If inFolderID = objTopPublicFolder.ID Then
      locFolderNumber = 0
    Else
      locFolderCounter = 0
      findFolderNumber2 objTopPublicFolder, inFolderID
    End If
  End If
  findPFolderNumber = locFolderNumber

End Function

Sub findTopPublicFolder

  Dim locObjInfoStores, locObjInfoStore, locStrRootID

  Set locObjInfoStores = objSession.InfoStores
  For Each locObjInfoStore In locObjInfoStores
    Err.Clear
    locStrRootID = locObjInfoStore.Fields(&H66310102).Value
    If Err.Number = 0 Then

      ' Get root folder
      Set objTopPublicFolder = objSession.GetFolder(locStrRootID, locObjInfoStore.ID)
      Exit For
    End If
  Next
  Set locObjInfoStores = Nothing

End Sub

Sub getAccess(inObject)

  If Not(inObject Is Nothing) Then
    locLngObjectACL = inObject.Fields(&H0FF40003) ' CdoPR_ACCESS
    blnCanRead = (locLngObjectACL And &H00000002) <> 0 ' MAPI_ACCESS_READ
    blnCanModifyObject = (locLngObjectACL And &H00000001) <> 0 ' MAPI_ACCESS_MODIFY
    If inObject.Class = 2 Then
      If SHOWERRORS Then On Error Resume Next
      locD = inObject.Messages.Count
      locErrorCode = Err.Number
      If SHOWERRORS Then On Error Goto 0
      blnCanReadMessages = False : If locErrorCode = 0 Then blnCanReadMessages = True
      If SHOWERRORS Then On Error Resume Next
      locD = inObject.Folders.Count
      locErrorCode = Err.Number
      If SHOWERRORS Then On Error Goto 0
      blnCanReadFolders = False : If locErrorCode = 0 Then blnCanReadFolders = True
      blnCanCreateInFolder = (locLngObjectACL And &H00000010) <> 0 ' MAPI_ACCESS_CREATE_CONTENTS
    Else
      locLngObjectACL = objSession.GetFolder(inObject.folderID).Fields(&H0FF40003)
      blnCanCreateInFolder = (locLngObjectACL And &H00000010) <> 0
    End If
  End If

End Sub

Function getMessage(inMessageID)

  Dim locObjMessage, locObjMessage2

  On Error Resume Next

  Set locObjMessage = objSession.GetMessage(inMessageID)
  If locObjMessage Is Nothing Then
    For Each locObjInfoStore In objSession.InfoStores
      Set locObjMessage = objSession.GetMessage(inMessageID, locObjInfoStore.ID)
      If Not(locObjMessage Is Nothing) Then Exit For
    Next
  End If

  getAccess(locObjMessage)

  Set getMessage = locObjMessage

End Function

Function getMessageRecipient(inMessage)

  If USERENDERER Then
    objRenderer.DataSource = inMessage
    getMessageRecipient = objRenderer.RenderProperty(&H0E04001E, 0)
  Else
    getMessageRecipient = inMessage.Fields(&H0E04001E)
  End If

End Function

Function getMessageSender(inMessage)

  If USERENDERER Then
    objRenderer.DataSource = inMessage
    getMessageSender = objRenderer.RenderProperty(&H0C1A001E, 0)
  Else

    ' Message may have no visible sender
    If SHOWERRORS Then On Error Resume Next
    getMessageSender = inMessage.Fields(&H0C1A001E)
    If SHOWERRORS Then On Error Goto 0
  End If

End Function

Function getMessageText(inMessage)

  Dim strLocMessageText, strLocMessageText2, blnLocAddChar, intLocX, intLocN, chrLocT

  On Error Resume Next

  Err.Clear
  strLocMessageText = inMessage.Text
  If Err.Number <> 0 And USERENDERER Then
    objRenderer.DataSource = inMessage
    strLocMessageText2 = objRenderer.RenderProperty(&H10090102, 0)
    blnLocAddChar = True
    intLocX = Len(strLocMessageText2)
    For intLocN = 1 To intLocX
      chrLocT = Mid(strLocMessageText2, intLocN, 1)
      If chrLocT = "<" Then
        blnLocAddChar = False
      ElseIf chrLocT = ">" Then
        blnLocAddChar = True
      Else
        If blnLocAddChar Then
          strLocMessageText = strLocMessageText & chrLocT
        End If
      End If
    Next
    strLocMessageText = Replace(strLocMessageText, "&nbsp;", " ")
    strLocMessageText = Replace(strLocMessageText, "&lt;", "<")
    strLocMessageText = Replace(strLocMessageText, "&gt;", ">")
    strLocMessageText = Replace(strLocMessageText, "&quot;", """")
  End If
  getMessageText = strLocMessageText

End Function

Function getMessageTimeSent(inMessage)

  If USERENDERER Then
    objRenderer.DataSource = inMessage
    getMessageTimeSent = objRenderer.RenderProperty(&H00390040, 0)
  Else
    getMessageTimeSent = inMessage.Fields(&H00390040)
  End If

End Function

Function getParam(inParam, inSave)

  If OPWDEBUG Then rw "Getting Parameter: " & inParam
  locStrStart = "#OPW" & inParam & "#"
  locStrEnd = "#END" & inParam & "#"
  locT = Request.QueryString(inParam)
  If (locT = "") And (Request.QueryString(inParam).Count = 0) Then
    locT = Request.Form(inParam)
    If (locT = "") And (Request.Form(inParam).Count = 0) Then
      locT2 = objStatusMessage.Text
      locP = Instr(locT2, locStrStart)
      If locP <> 0 Then
        locP2 = Instr(locP, locT2, locStrEnd)
        locT3 = Mid(locT2, locP, locP2 - locP)
        locT = Replace(locT3, locStrStart, "")
      End If
    End if
  End If
  If inSave Then
    locStrValue = locStrStart & locT & locStrEnd
    strParamsText = strParamsText & locStrValue & vbCrLf
  End If
  getParam = locT
  If OPWDEBUG Then rwbc " = " & getParam

End Function

Sub setParam(inParam, inValue)

  Dim locStrStart, locStrEnd, locT, locT2, locP, locP2, locP3

  locStrStart = "#OPW" & inParam & "#"
  locStrEnd = "#END" & inParam & "#"
  locStrValue = locStrStart & inValue & locStrEnd
  locT = objStatusMessage.Text
  locP = Instr(locT, locStrStart)
  If locP <> 0 Then
    locP2 = Instr(locP, locT, locStrEnd)
    locT2 = Mid(locT, locP, locP2 - locP)
    locT = Replace(locT, locT2, locStrValue)
  Else
    locT = locT & locStrValue
  End If
  objStatusMessage.Text = locT
  objStatusMessage.Update(True)

End Sub

Sub getParams

  If OPWDEBUG Then rwbc "Getting Parameters."

  Set locObjFolder = objSession.Inbox
  Set locObjMessages = locObjFolder.HiddenMessages
  Set locObjFilter = locObjMessages.Filter
  If si = "" Then

    If OPWDEBUG Then rwbc "Application status messages:"
    locObjFilter.Fields(&H0037001E) = "OWA FOR WAP USER STATUS"
    locCount = locObjMessages.Count
    For locN = locCount To 1 Step -1
      Set locObjMessage = locObjMessages(locN)
      locCreated = locObjMessage.Fields(&H30080040)
      locDateDiff = DateDiff("h", Now, locCreated)
      If OPWDEBUG Then rw locCreated & " - " & locDateDiff & "hrs"
      If locDateDiff < -24 Then
        If OPWDEBUG Then rw " - will delete"
        locObjMessage.Delete False
      End If
      If OPWDEBUG Then rwbc ""
    Next
    If OPWDEBUG Then rwbc "Creating Status Message."
    Randomize
    si = Int(100000 * Rnd)
    Set objStatusMessage = locObjMessages.Add
    objStatusMessage.Subject =  "OWA FOR WAP USER STATUS " & si
    objStatusMessage.Update(True)
    If OPWDEBUG Then rwbc "Finished creating Status Message."

  Else
    If OPWDEBUG Then rwbc "Getting Status Message."
    locCount = locObjMessages.Count
    For locN = 1 To locCount
      If locObjMessages(locN).Subject = "OWA FOR WAP USER STATUS " & si Then
        Set objStatusMessage = locObjMessages(locN)
        Exit For
      End If
    Next
    If Not IsObject(objStatusMessage) Then
      rwbc "Can't find status message."
      Response.End
    End If
    If OPWDEBUG Then rwbc "Finished getting Status Message."
  End If

  at = getParam("at", True)
  ci = getParam("ci", True) : If ci <> "" Then ci = expandID(ci)
  da = getParam("da", False)

  fi = getParam("fi", True)
  If fi <> "" Then fi = expandID(fi)
  If IsNumeric(fi) Then fi = CInt(fi)
  If fi = "" Then fi = 0

  fn = getParam("fn", True)
  If IsNumeric(fn) Then fn = CInt(fn)
  If fn = "" Then fn = 0

  flt = getParam("flt", True)
  fly = getParam("fly", True)
  km = getParam("km", False)

  lastFi = getParam("lastFi", True)
  If IsNumeric(lastFi) Then lastFi = CInt(lastFi)
  If lastFi = "" Then lastFi = 0

  mdy = getParam("mdy", True)
  If mdy = "" Then
    dy = Day(Date) : mo = Month(Date) : yr = Year(Date)
    mdy = mo & "/" & dy & "/" & yr
  End If
  arrDate = Split(mdy, "/")
  If UBound(arrDate) = 2 Then
    mo = arrDate(0) : dy = arrDate(1) : yr = arrDate(2)
  End If

  mi = getParam("mi", True) : If mi <> "" Then mi = expandID(mi)

  mn = getParam("mn", True)
  If IsNumeric(mn) Then mn = CInt(mn)
  If mn = "" Then mn = 0

  mt = getParam("mt", True) : If IsNumeric(mt) Then mt = CInt(mt)
  pg = getParam("pg", False)
  If Int(pg) < 1 Then pg = 1
  rs = getParam("rs", True)
  ry = getParam("ry", True) : If IsNumeric(ry) Then ry = Int(ry)
  st = getParam("st", True)

  If OPWDEBUG Then
    rwbc "User status:"
    rwbc displayEncode(strParamstext)
  End If

  objStatusMessage.Text = strParamsText
  objStatusMessage.Update(True)
  Set locObjFilter = Nothing
  Set locObjMessages = Nothing
  Set locObjFolder = Nothing

  If fi <> lastFi Then
    fn = 0 : setParam "fn", fn
    mn = 0 : setParam "mn", mn
    fly = "" : setParam "fly", fly
    flt = "" : setParam "flt", flt
    lastFi = fi : setParam "lastFi", lastFi
  End If

End Sub

Sub login

  If OPWDEBUG Then rwbc "Logging in."

  If USERENDERER Then
    If Not IsObject(Application("RenderingApplication")) Then
      Set objRenderApplication = Server.CreateObject("AMHTML.Application")
      If Err.Number = 0 Then
        Set Application("RenderingApplication") = objRenderApplication
        Set objRenderApplication = Nothing
      End If
    End If
  End If

  mb = Request.QueryString("mb")
  If mb = "" Then mb = Request.Form("mb")
  If mb = "" Then mb = Session("mb")
  si = Request.QueryString("si")
  If si = "" Then si = Request.Form("si")
  If si = "" Then si = Session("si")

  Set objSession = Server.CreateObject("MAPI.Session")
  lstrProfile = SERVERNAME & vbLf & mb
  objSession.Logon "", "", False, True, 0, True, lstrProfile
  On Error Resume Next
  Err.Clear
  Set lobjFolder = objSession.Inbox
  errorCode = Err.Number
  If errorCode <> 0 Then
    rwbc UNABLETOOPENMAILBOXTEXT & COLONSPACETEXT & mb
    rwbc ERRORTEXT & COLONSPACETEXT & Err.Description
    rwbc EXCHANGESERVERNAMETEXT & COLONSPACETEXT & SERVERNAME
    rwbc USERNAMETEXT & COLONSPACETEXT & Request.ServerVariables("LOGON_USER")
  End If
  On Error Goto 0
  Set lobjFolder = Nothing

  ' Check if HTTP protocol is disabled for the current mailbox
  On Error Resume Next
  blnHTTPDisabled = False
  protocols = objSession.CurrentUser.Fields(&H81B6101F)
  For Each strProtocol in protocols
    If Instr(1, strProtocol, "HTTP", vbTextCompare) Then
      If "0" = Mid(strProtocol, 6, 1) Then blnHTTPDisabled = True
      Exit For
    End If
  Next
  On Error Goto 0
  If blnHTTPDisabled Then
    rwbc HTTPDISABLEDFORMAILBOXTEXT

    ' Bypass the remaining page output
    errorCode = 1
  End If

  If errorCode = 0 Then
    If USERENDERER Then
      Set objRenderApplication = Application("RenderingApplication")
      Set objRenderer = objRenderApplication.CreateRenderer(2)
    End If
    getParams
  End If

End Sub

Sub logoff

  If USERENDERER Then
    Set objRenderApplication = Nothing
    Set objRenderer = Nothing
  End If

  Set objStatusMessage = Nothing

  objSession.Logoff
  Set objSession = Nothing

End Sub

Sub rw(inText)

  Response.Write inText

End Sub

Sub rwbc(inText)

  rwc inText & "<br/>"

End Sub

Sub rwc(inText)

  rw inText & vbCrLf

End Sub

Function timeZoneGetOffset

  locT = objSession.GetOption("TimeZone")
  locT = locT And Not(&H00004000)
  For locN = 0 To UBound(timeZones) - 1
    If locT = timeZones(locN) Then
      locT2 = timeZoneOffsets(locN)
      Exit For
    End If
  Next
  timeZoneGetOffset = locT2

End Function

Function timeZoneGetZone(inOffset)

  For locN = 0 To UBound(timeZoneOffsets) - 1
    If inOffset = timeZoneOffsets(locN) Then
      locT = timeZones(locN)
      Exit For
    End If
  Next
  timeZoneGetZone = locT

End Function

Function validDate(inDay, inMonth, inYear)

  If Int(inDay) > daysInMonth(inMonth, inYear) Then
    validDate = False
  Else
    validDate = True
  End If

End Function

Sub writeLinkWParams(inTarget, inTitle, inParamList)

  If ci <> "" Then locCi = ci : locCi = compressID(locCi)
  If fi <> "" Then locFi = fi : locFi = compressID(locFi)
  If mi <> "" Then locMi = mi : locMi = compressID(locMi)
  If mmfi <> "" Then locMmfi = mmfi : locMmfi = compressID(locMmfi)

  rw "<a href='" & inTarget
  rw "?mb=" & Server.URLEncode(mb) & AMPCHARS & "si=" & si

  If inParamList <> "" Then
    If writeLinkWParams2("act", inParamList) Then rw AMPCHARS & "act=" & Server.URLEncode(act)
    If writeLinkWParams2("ai", inParamList) Then rw AMPCHARS & "ai=" & Server.URLEncode(ai)
    If writeLinkWParams2("at", inParamList) Then rw AMPCHARS & "at=" & Server.URLEncode(at)
    If writeLinkWParams2("ci", inParamList) Then rw AMPCHARS & "ci=" & Server.URLEncode(locCi)
    If writeLinkWParams2("da", inParamList) Then rw AMPCHARS & "da=" & Server.URLEncode(da)
    If writeLinkWParams2("fi", inParamList) Then rw AMPCHARS & "fi=" & Server.URLEncode(locFi)
    If writeLinkWParams2("fn", inParamList) Then rw AMPCHARS & "fn=" & Server.URLEncode(fn)
    If writeLinkWParams2("fu", inParamList) Then rw AMPCHARS & "fu=" & Server.URLEncode(fu)
    If writeLinkWParams2("hb", inParamList) Then rw AMPCHARS & "hb=" & Server.URLEncode(hb)
    If writeLinkWParams2("km", inParamList) Then rw AMPCHARS & "km=" & Server.URLEncode(km)

    If writeLinkWParams2("mdy", inParamList) Then rw AMPCHARS & "mdy=" & Server.URLEncode(mdy)

    If writeLinkWParams2("mn", inParamList) Then rw AMPCHARS & "mn=" & Server.URLEncode(mn)
    If writeLinkWParams2("mi", inParamList) Then rw AMPCHARS & "mi=" & Server.URLEncode(locMi)
    If writeLinkWParams2("mmfi", inParamList) Then rw AMPCHARS & "mmfi=" & Server.URLEncode(locMmfi)
    If writeLinkWParams2("mmfn", inParamList) Then rw AMPCHARS & "mmfn=" & Server.URLEncode(mmfn)
    If writeLinkWParams2("mt", inParamList) Then rw AMPCHARS & "mt=" & Server.URLEncode(mt)
    If writeLinkWParams2("pg", inParamList) Then rw AMPCHARS & "pg=" & Server.URLEncode(pg)
    If writeLinkWParams2("pge", inParamList) Then rw AMPCHARS & "pge=" & Server.URLEncode(pge)
    If writeLinkWParams2("pn", inParamList) Then rw AMPCHARS & "pn=" & Server.URLEncode(pn)
    If writeLinkWParams2("ry", inParamList) Then rw AMPCHARS & "ry=" & Server.URLEncode(ry)
    If writeLinkWParams2("st", inParamList) Then rw AMPCHARS & "st=" & Server.URLEncode(st)

    If writeLinkWParams2("d_filter", inParamList) Then rw AMPCHARS & "filter=$(filter)"
    If writeLinkWParams2("d_mdy", inParamList) Then rw AMPCHARS & "mdy=$(mdy)"
  End If

  If RANDOMURLPARAM Then
    Randomize
    rw AMPCHARS & "r=" & Int(100000 * Rnd)
  End If

  rw "'>"

  If writeLinkWParams2("BOLD", inParamList) Then locBoldFlag = True
  If locBoldFlag Then rw "<b>"

  rw displayEncode(inTitle)

  If locBoldFlag Then rw "</b>"

  rw "</a>"

  If writeLinkWParams2("NOBR", inParamList) Then locNoLineBreak = True
  If Not locNoLineBreak Then
    rwbc ""
  Else
    rwc " "
  End If

End Sub

Function writeLinkWParams2(inParam, inParamList)

  locFound = False
  locParams = Split(inParamList, ",")
  For locN = 0 To UBound(locParams)
    If UCase(Trim(locParams(locN))) = UCase(inParam) Then locFound = True
  Next
  writeLinkWParams2 = locFound

End Function

Sub writeMailboxLink

  writeLinkWParams "MBX.asp", TOMAILBOXTEXT, ""

End Sub

Sub writePageEnd

  rwc "</p>" & vbCrLf & "</card>" & vbCrLf & "</wml>"

End Sub

Sub writePageStart(inTitle)

  Response.ContentType = "text/vnd.wap.wml"
  Response.Buffer = True
  Response.AddHeader "Cache-control", "no-cache, must-revalidate"
  rwc "<?xml version='1.0'?>"
  rwc "<!DOCTYPE wml PUBLIC '-//WAPFORUM//DTD WML 1.1//EN' 'http://www.wapforum.org/DTD/wml_1.1.xml'>"
  rwc "<wml>"
  rw "<card title='" & inTitle & "' newcontext='true'"
  If gotoMailbox Then rw " ontimer='MBX.asp?mb=" & displayEncode(mb) & "'"
  rwc ">"
  If gotoMailbox Then rwc "<timer value='1'/>"
  If centred Then
    rwc "<p align='center'>"
  Else
    rwc "<p>"
  End If

End Sub

Sub writePostfields

  rwc "<postfield name='mb' value='" & Server.HTMLEncode(mb) & "'/>"
  rwc "<postfield name='si' value='" & Server.HTMLEncode(si) & "'/>"

End Sub

Sub writeTitle(title)

 rwbc title

End Sub

Sub writeUnderline

 rwbc "---------------"

End Sub
%>
