/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.util.SymbolTable;

public final class SynchronizedSymbolTable
extends SymbolTable {
    protected SymbolTable fSymbolTable;

    public SynchronizedSymbolTable(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
    }

    public SynchronizedSymbolTable() {
        this.fSymbolTable = new SymbolTable();
    }

    public SynchronizedSymbolTable(int size) {
        this.fSymbolTable = new SymbolTable(size);
    }

    public String addSymbol(String symbol) {
        SymbolTable symbolTable = this.fSymbolTable;
        synchronized (symbolTable) {
            String string = this.fSymbolTable.addSymbol(symbol);
            return string;
        }
    }

    public String addSymbol(char[] buffer, int offset, int length) {
        SymbolTable symbolTable = this.fSymbolTable;
        synchronized (symbolTable) {
            String string = this.fSymbolTable.addSymbol(buffer, offset, length);
            return string;
        }
    }

    public boolean containsSymbol(String symbol) {
        SymbolTable symbolTable = this.fSymbolTable;
        synchronized (symbolTable) {
            boolean bl = this.fSymbolTable.containsSymbol(symbol);
            return bl;
        }
    }

    public boolean containsSymbol(char[] buffer, int offset, int length) {
        SymbolTable symbolTable = this.fSymbolTable;
        synchronized (symbolTable) {
            boolean bl = this.fSymbolTable.containsSymbol(buffer, offset, length);
            return bl;
        }
    }
}

