/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd;

import org.apache.xerces.impl.dtd.XMLAttributeDecl;
import org.apache.xerces.impl.dtd.XMLContentSpec;
import org.apache.xerces.impl.dtd.XMLDTDDescription;
import org.apache.xerces.impl.dtd.XMLElementDecl;
import org.apache.xerces.impl.dtd.XMLEntityDecl;
import org.apache.xerces.impl.dtd.XMLNotationDecl;
import org.apache.xerces.impl.dtd.models.CMAny;
import org.apache.xerces.impl.dtd.models.CMBinOp;
import org.apache.xerces.impl.dtd.models.CMLeaf;
import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.dtd.models.CMUniOp;
import org.apache.xerces.impl.dtd.models.ContentModelValidator;
import org.apache.xerces.impl.dtd.models.DFAContentModel;
import org.apache.xerces.impl.dtd.models.MixedContentModel;
import org.apache.xerces.impl.dtd.models.SimpleContentModel;
import org.apache.xerces.impl.dv.dtd.DatatypeValidator;
import org.apache.xerces.impl.validation.EntityState;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;

public abstract class AbstractDTDGrammar
implements EntityState,
Grammar {
    public static final int TOP_LEVEL_SCOPE = -1;
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private static final short LIST_FLAG = 128;
    private static final short LIST_MASK = -129;
    private SymbolTable fSymbolTable;
    protected XMLDTDDescription fGrammarDescription = null;
    private String fTargetNamespace;
    private int fElementDeclCount = 0;
    private QName[][] fElementDeclName = new QName[4][];
    private short[][] fElementDeclType = new short[4][];
    private String[][] fElementDeclDefaultValue = new String[4][];
    private short[][] fElementDeclDefaultType = new short[4][];
    private DatatypeValidator[][] fElementDeclDatatypeValidator = new DatatypeValidator[4][];
    private int[][] fElementDeclContentSpecIndex = new int[4][];
    private ContentModelValidator[][] fElementDeclContentModelValidator = new ContentModelValidator[4][];
    private int[][] fElementDeclFirstAttributeDeclIndex = new int[4][];
    private int[][] fElementDeclLastAttributeDeclIndex = new int[4][];
    private int fAttributeDeclCount = 0;
    private QName[][] fAttributeDeclName = new QName[4][];
    private short[][] fAttributeDeclType = new short[4][];
    private String[][][] fAttributeDeclEnumeration = new String[4][][];
    private short[][] fAttributeDeclDefaultType = new short[4][];
    private DatatypeValidator[][] fAttributeDeclDatatypeValidator = new DatatypeValidator[4][];
    private String[][] fAttributeDeclDefaultValue = new String[4][];
    private String[][] fAttributeDeclNonNormalizedDefaultValue = new String[4][];
    private int[][] fAttributeDeclNextAttributeDeclIndex = new int[4][];
    private int fContentSpecCount = 0;
    private short[][] fContentSpecType = new short[4][];
    private Object[][] fContentSpecValue = new Object[4][];
    private Object[][] fContentSpecOtherValue = new Object[4][];
    private int fEntityCount = 0;
    private String[][] fEntityName = new String[4][];
    private String[][] fEntityValue = new String[4][];
    private String[][] fEntityPublicId = new String[4][];
    private String[][] fEntitySystemId = new String[4][];
    private String[][] fEntityBaseSystemId = new String[4][];
    private String[][] fEntityNotation = new String[4][];
    private byte[][] fEntityIsPE = new byte[4][];
    private byte[][] fEntityInExternal = new byte[4][];
    private int fNotationCount = 0;
    private String[][] fNotationName = new String[4][];
    private String[][] fNotationPublicId = new String[4][];
    private String[][] fNotationSystemId = new String[4][];
    private String[][] fNotationBaseSystemId = new String[4][];
    private TupleHashtable fScopeMapping = new TupleHashtable();
    private QName fQName1 = new QName();
    private QName fQName2 = new QName();
    protected XMLAttributeDecl fAttributeDecl = new XMLAttributeDecl();
    private int fLeafCount = 0;
    private int fEpsilonIndex = -1;

    protected AbstractDTDGrammar(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fGrammarDescription = new XMLDTDDescription();
    }

    public XMLGrammarDescription getGrammarDescription() {
        return this.fGrammarDescription;
    }

    public abstract boolean isNamespaceAware();

    public SymbolTable getSymbolTable() {
        return this.fSymbolTable;
    }

    public String getTargetNamespace() {
        return this.fTargetNamespace;
    }

    public int getFirstElementDeclIndex() {
        return this.fElementDeclCount > 0 ? this.fElementDeclCount : -1;
    }

    public int getNextElementDeclIndex(int elementDeclIndex) {
        return elementDeclIndex < this.fElementDeclCount - 1 ? elementDeclIndex + 1 : -1;
    }

    public int getElementDeclIndex(String elementDeclName, int scope) {
        int mapping = this.fScopeMapping.get(scope, elementDeclName, null);
        return mapping;
    }

    public int getElementDeclIndex(QName elementDeclQName, int scope) {
        int mapping = this.fScopeMapping.get(scope, elementDeclQName.localpart, elementDeclQName.uri);
        return mapping;
    }

    public boolean getElementDecl(int elementDeclIndex, XMLElementDecl elementDecl) {
        if (elementDeclIndex < 0 || elementDeclIndex >= this.fElementDeclCount) {
            return false;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        elementDecl.name.setValues(this.fElementDeclName[chunk][index]);
        if (this.fElementDeclType[chunk][index] == -1) {
            elementDecl.type = (short)-1;
            elementDecl.simpleType.list = false;
        } else {
            elementDecl.type = (short)(this.fElementDeclType[chunk][index] & 0xFFFFFF7F);
            boolean bl = elementDecl.simpleType.list = (this.fElementDeclType[chunk][index] & 0x80) != 0;
        }
        if (elementDecl.type == 3 || elementDecl.type == 2) {
            elementDecl.contentModelValidator = this.getElementContentModelValidator(elementDeclIndex);
        }
        elementDecl.simpleType.datatypeValidator = this.fElementDeclDatatypeValidator[chunk][index];
        elementDecl.simpleType.defaultType = this.fElementDeclDefaultType[chunk][index];
        elementDecl.simpleType.defaultValue = this.fElementDeclDefaultValue[chunk][index];
        return true;
    }

    public int getFirstAttributeDeclIndex(int elementDeclIndex) {
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fElementDeclFirstAttributeDeclIndex[chunk][index];
    }

    public int getNextAttributeDeclIndex(int attributeDeclIndex) {
        int chunk = attributeDeclIndex >> 8;
        int index = attributeDeclIndex & 0xFF;
        return this.fAttributeDeclNextAttributeDeclIndex[chunk][index];
    }

    public int getAttributeDeclIndex(int elementDeclIndex, String attributeDeclName) {
        return -1;
    }

    public boolean getAttributeDecl(int attributeDeclIndex, XMLAttributeDecl attributeDecl) {
        boolean isList;
        short attributeType;
        if (attributeDeclIndex < 0 || attributeDeclIndex >= this.fAttributeDeclCount) {
            return false;
        }
        int chunk = attributeDeclIndex >> 8;
        int index = attributeDeclIndex & 0xFF;
        attributeDecl.name.setValues(this.fAttributeDeclName[chunk][index]);
        if (this.fAttributeDeclType[chunk][index] == -1) {
            attributeType = -1;
            isList = false;
        } else {
            attributeType = (short)(this.fAttributeDeclType[chunk][index] & 0xFFFFFF7F);
            isList = (this.fAttributeDeclType[chunk][index] & 0x80) != 0;
        }
        attributeDecl.simpleType.setValues(attributeType, this.fAttributeDeclName[chunk][index].localpart, this.fAttributeDeclEnumeration[chunk][index], isList, this.fAttributeDeclDefaultType[chunk][index], this.fAttributeDeclDefaultValue[chunk][index], this.fAttributeDeclNonNormalizedDefaultValue[chunk][index], this.fAttributeDeclDatatypeValidator[chunk][index]);
        return true;
    }

    public boolean isCDATAAttribute(QName elName, QName atName) {
        int elDeclIdx = this.getElementDeclIndex(elName, -1);
        int atDeclIdx = this.getAttributeDeclIndex(elDeclIdx, atName.rawname);
        return !this.getAttributeDecl(elDeclIdx, this.fAttributeDecl) || this.fAttributeDecl.simpleType.type == 0;
    }

    public int getFirstEntityDeclIndex() {
        throw new RuntimeException("implement Grammar#getFirstEntityDeclIndex():int");
    }

    public int getNextEntityDeclIndex(int elementDeclIndex) {
        throw new RuntimeException("implement Grammar#getNextEntityDeclIndex(int):int");
    }

    public int getEntityDeclIndex(String entityDeclName) {
        if (entityDeclName == null) {
            return -1;
        }
        int i = 0;
        while (i < this.fEntityCount) {
            int chunk = i >> 8;
            int index = i & 0xFF;
            if (this.fEntityName[chunk][index] == entityDeclName || entityDeclName.equals(this.fEntityName[chunk][index])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean getEntityDecl(int entityDeclIndex, XMLEntityDecl entityDecl) {
        if (entityDeclIndex < 0 || entityDeclIndex >= this.fEntityCount) {
            return false;
        }
        int chunk = entityDeclIndex >> 8;
        int index = entityDeclIndex & 0xFF;
        entityDecl.setValues(this.fEntityName[chunk][index], this.fEntityPublicId[chunk][index], this.fEntitySystemId[chunk][index], this.fEntityBaseSystemId[chunk][index], this.fEntityNotation[chunk][index], this.fEntityValue[chunk][index], this.fEntityIsPE[chunk][index] != 0, this.fEntityInExternal[chunk][index] != 0);
        return true;
    }

    public int getFirstNotationDeclIndex() {
        throw new RuntimeException("implement Grammar#getFirstNotationDeclIndex():int");
    }

    public int getNextNotationDeclIndex(int elementDeclIndex) {
        throw new RuntimeException("implement Grammar#getNextNotationDeclIndex(int):int");
    }

    public int getNotationDeclIndex(String notationDeclName) {
        if (notationDeclName == null) {
            return -1;
        }
        int i = 0;
        while (i < this.fNotationCount) {
            int chunk = i >> 8;
            int index = i & 0xFF;
            if (this.fNotationName[chunk][index] == notationDeclName || notationDeclName.equals(this.fNotationName[chunk][index])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean getNotationDecl(int notationDeclIndex, XMLNotationDecl notationDecl) {
        if (notationDeclIndex < 0 || notationDeclIndex >= this.fNotationCount) {
            return false;
        }
        int chunk = notationDeclIndex >> 8;
        int index = notationDeclIndex & 0xFF;
        notationDecl.setValues(this.fNotationName[chunk][index], this.fNotationPublicId[chunk][index], this.fNotationSystemId[chunk][index], this.fNotationBaseSystemId[chunk][index]);
        return true;
    }

    public boolean getContentSpec(int contentSpecIndex, XMLContentSpec contentSpec) {
        if (contentSpecIndex < 0 || contentSpecIndex >= this.fContentSpecCount) {
            return false;
        }
        int chunk = contentSpecIndex >> 8;
        int index = contentSpecIndex & 0xFF;
        contentSpec.type = this.fContentSpecType[chunk][index];
        contentSpec.value = this.fContentSpecValue[chunk][index];
        contentSpec.otherValue = this.fContentSpecOtherValue[chunk][index];
        return true;
    }

    public String getContentSpecAsString(int elementDeclIndex) {
        if (elementDeclIndex < 0 || elementDeclIndex >= this.fElementDeclCount) {
            return null;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        int contentSpecIndex = this.fElementDeclContentSpecIndex[chunk][index];
        XMLContentSpec contentSpec = new XMLContentSpec();
        if (this.getContentSpec(contentSpecIndex, contentSpec)) {
            StringBuffer str = new StringBuffer();
            int parentContentSpecType = contentSpec.type & 0xF;
            switch (parentContentSpecType) {
                case 0: {
                    str.append('(');
                    if (contentSpec.value == null && contentSpec.otherValue == null) {
                        str.append("#PCDATA");
                    } else {
                        str.append(contentSpec.value);
                    }
                    str.append(')');
                    break;
                }
                case 1: {
                    this.getContentSpec(((int[])contentSpec.value)[0], contentSpec);
                    short nextContentSpec = contentSpec.type;
                    if (nextContentSpec == 0) {
                        str.append('(');
                        str.append(contentSpec.value);
                        str.append(')');
                    } else if (nextContentSpec == 3 || nextContentSpec == 2 || nextContentSpec == 1) {
                        str.append('(');
                        this.appendContentSpec(contentSpec, str, true, parentContentSpecType);
                        str.append(')');
                    } else {
                        this.appendContentSpec(contentSpec, str, true, parentContentSpecType);
                    }
                    str.append('?');
                    break;
                }
                case 2: {
                    this.getContentSpec(((int[])contentSpec.value)[0], contentSpec);
                    short nextContentSpec = contentSpec.type;
                    if (nextContentSpec == 0) {
                        str.append('(');
                        if (contentSpec.value == null && contentSpec.otherValue == null) {
                            str.append("#PCDATA");
                        } else if (contentSpec.otherValue != null) {
                            str.append("##any:uri=" + contentSpec.otherValue);
                        } else if (contentSpec.value == null) {
                            str.append("##any");
                        } else {
                            this.appendContentSpec(contentSpec, str, true, parentContentSpecType);
                        }
                        str.append(')');
                    } else if (nextContentSpec == 3 || nextContentSpec == 2 || nextContentSpec == 1) {
                        str.append('(');
                        this.appendContentSpec(contentSpec, str, true, parentContentSpecType);
                        str.append(')');
                    } else {
                        this.appendContentSpec(contentSpec, str, true, parentContentSpecType);
                    }
                    str.append('*');
                    break;
                }
                case 3: {
                    this.getContentSpec(((int[])contentSpec.value)[0], contentSpec);
                    short nextContentSpec = contentSpec.type;
                    if (nextContentSpec == 0) {
                        str.append('(');
                        if (contentSpec.value == null && contentSpec.otherValue == null) {
                            str.append("#PCDATA");
                        } else if (contentSpec.otherValue != null) {
                            str.append("##any:uri=" + contentSpec.otherValue);
                        } else if (contentSpec.value == null) {
                            str.append("##any");
                        } else {
                            str.append(contentSpec.value);
                        }
                        str.append(')');
                    } else if (nextContentSpec == 3 || nextContentSpec == 2 || nextContentSpec == 1) {
                        str.append('(');
                        this.appendContentSpec(contentSpec, str, true, parentContentSpecType);
                        str.append(')');
                    } else {
                        this.appendContentSpec(contentSpec, str, true, parentContentSpecType);
                    }
                    str.append('+');
                    break;
                }
                case 4: 
                case 5: {
                    this.appendContentSpec(contentSpec, str, true, parentContentSpecType);
                    break;
                }
                case 6: {
                    str.append("##any");
                    if (contentSpec.otherValue == null) break;
                    str.append(":uri=");
                    str.append(contentSpec.otherValue);
                    break;
                }
                case 7: {
                    str.append("##other:uri=");
                    str.append(contentSpec.otherValue);
                    break;
                }
                case 8: {
                    str.append("##local");
                    break;
                }
                default: {
                    str.append("???");
                }
            }
            return str.toString();
        }
        return null;
    }

    public void printElements() {
        int elementDeclIndex = 0;
        XMLElementDecl elementDecl = new XMLElementDecl();
        while (this.getElementDecl(elementDeclIndex++, elementDecl)) {
            System.out.println("element decl: " + elementDecl.name + ", " + elementDecl.name.rawname);
        }
    }

    public void printAttributes(int elementDeclIndex) {
        int attributeDeclIndex = this.getFirstAttributeDeclIndex(elementDeclIndex);
        System.out.print(elementDeclIndex);
        System.out.print(" [");
        while (attributeDeclIndex != -1) {
            System.out.print(' ');
            System.out.print(attributeDeclIndex);
            this.printAttribute(attributeDeclIndex);
            attributeDeclIndex = this.getNextAttributeDeclIndex(attributeDeclIndex);
            if (attributeDeclIndex == -1) continue;
            System.out.print(",");
        }
        System.out.println(" ]");
    }

    protected ContentModelValidator getElementContentModelValidator(int elementDeclIndex) {
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        ContentModelValidator contentModel = this.fElementDeclContentModelValidator[chunk][index];
        if (contentModel != null) {
            return contentModel;
        }
        short contentType = this.fElementDeclType[chunk][index];
        if (contentType == 4) {
            return null;
        }
        int contentSpecIndex = this.fElementDeclContentSpecIndex[chunk][index];
        XMLContentSpec contentSpec = new XMLContentSpec();
        this.getContentSpec(contentSpecIndex, contentSpec);
        if (contentType == 2) {
            ChildrenList children = new ChildrenList();
            this.contentSpecTree(contentSpecIndex, contentSpec, children);
            contentModel = new MixedContentModel(children.qname, children.type, 0, children.length, false, this.isDTD());
        } else if (contentType == 3) {
            contentModel = this.createChildModel(contentSpecIndex);
        } else {
            throw new RuntimeException("Unknown content type for a element decl in getElementContentModelValidator() in AbstractDTDGrammar class");
        }
        this.fElementDeclContentModelValidator[chunk][index] = contentModel;
        return contentModel;
    }

    protected int createElementDecl() {
        int chunk = this.fElementDeclCount >> 8;
        int index = this.fElementDeclCount & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        this.fElementDeclName[chunk][index] = new QName();
        this.fElementDeclType[chunk][index] = -1;
        this.fElementDeclDatatypeValidator[chunk][index] = null;
        this.fElementDeclContentModelValidator[chunk][index] = null;
        this.fElementDeclFirstAttributeDeclIndex[chunk][index] = -1;
        this.fElementDeclLastAttributeDeclIndex[chunk][index] = -1;
        this.fElementDeclDefaultValue[chunk][index] = null;
        this.fElementDeclDefaultType[chunk][index] = -1;
        return this.fElementDeclCount++;
    }

    protected void setElementDecl(int elementDeclIndex, XMLElementDecl elementDecl) {
        if (elementDeclIndex < 0 || elementDeclIndex >= this.fElementDeclCount) {
            return;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        int scope = elementDecl.scope;
        this.fElementDeclName[chunk][index].setValues(elementDecl.name);
        this.fElementDeclType[chunk][index] = elementDecl.type;
        this.fElementDeclDatatypeValidator[chunk][index] = elementDecl.simpleType.datatypeValidator;
        this.fElementDeclDefaultType[chunk][index] = elementDecl.simpleType.defaultType;
        this.fElementDeclDefaultValue[chunk][index] = elementDecl.simpleType.defaultValue;
        this.fElementDeclContentModelValidator[chunk][index] = elementDecl.contentModelValidator;
        if (elementDecl.simpleType.list) {
            short[] sArray = this.fElementDeclType[chunk];
            int n = index;
            sArray[n] = (short)(sArray[n] | 0x80);
        }
        if (this.isDTD()) {
            this.fScopeMapping.put(scope, elementDecl.name.rawname, null, elementDeclIndex);
        } else {
            this.fScopeMapping.put(scope, elementDecl.name.localpart, elementDecl.name.uri, elementDeclIndex);
        }
    }

    protected void putElementNameMapping(QName name, int scope, int elementDeclIndex) {
    }

    protected void setFirstAttributeDeclIndex(int elementDeclIndex, int newFirstAttrIndex) {
        if (elementDeclIndex < 0 || elementDeclIndex >= this.fElementDeclCount) {
            return;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.fElementDeclFirstAttributeDeclIndex[chunk][index] = newFirstAttrIndex;
    }

    protected void setContentSpecIndex(int elementDeclIndex, int contentSpecIndex) {
        if (elementDeclIndex < 0 || elementDeclIndex >= this.fElementDeclCount) {
            return;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        this.fElementDeclContentSpecIndex[chunk][index] = contentSpecIndex;
    }

    protected int createAttributeDecl() {
        int chunk = this.fAttributeDeclCount >> 8;
        int index = this.fAttributeDeclCount & 0xFF;
        this.ensureAttributeDeclCapacity(chunk);
        this.fAttributeDeclName[chunk][index] = new QName();
        this.fAttributeDeclType[chunk][index] = -1;
        this.fAttributeDeclDatatypeValidator[chunk][index] = null;
        this.fAttributeDeclEnumeration[chunk][index] = null;
        this.fAttributeDeclDefaultType[chunk][index] = 0;
        this.fAttributeDeclDefaultValue[chunk][index] = null;
        this.fAttributeDeclNonNormalizedDefaultValue[chunk][index] = null;
        this.fAttributeDeclNextAttributeDeclIndex[chunk][index] = -1;
        return this.fAttributeDeclCount++;
    }

    protected void setAttributeDecl(int elementDeclIndex, int attributeDeclIndex, XMLAttributeDecl attributeDecl) {
        int attrChunk = attributeDeclIndex >> 8;
        int attrIndex = attributeDeclIndex & 0xFF;
        this.fAttributeDeclName[attrChunk][attrIndex].setValues(attributeDecl.name);
        this.fAttributeDeclType[attrChunk][attrIndex] = attributeDecl.simpleType.type;
        if (attributeDecl.simpleType.list) {
            short[] sArray = this.fAttributeDeclType[attrChunk];
            int n = attrIndex;
            sArray[n] = (short)(sArray[n] | 0x80);
        }
        this.fAttributeDeclEnumeration[attrChunk][attrIndex] = attributeDecl.simpleType.enumeration;
        this.fAttributeDeclDefaultType[attrChunk][attrIndex] = attributeDecl.simpleType.defaultType;
        this.fAttributeDeclDatatypeValidator[attrChunk][attrIndex] = attributeDecl.simpleType.datatypeValidator;
        this.fAttributeDeclDefaultValue[attrChunk][attrIndex] = attributeDecl.simpleType.defaultValue;
        this.fAttributeDeclNonNormalizedDefaultValue[attrChunk][attrIndex] = attributeDecl.simpleType.nonNormalizedDefaultValue;
        int elemChunk = elementDeclIndex >> 8;
        int elemIndex = elementDeclIndex & 0xFF;
        int index = this.fElementDeclFirstAttributeDeclIndex[elemChunk][elemIndex];
        while (index != -1) {
            if (index == attributeDeclIndex) break;
            attrChunk = index >> 8;
            attrIndex = index & 0xFF;
            index = this.fAttributeDeclNextAttributeDeclIndex[attrChunk][attrIndex];
        }
        if (index == -1) {
            if (this.fElementDeclFirstAttributeDeclIndex[elemChunk][elemIndex] == -1) {
                this.fElementDeclFirstAttributeDeclIndex[elemChunk][elemIndex] = attributeDeclIndex;
            } else {
                index = this.fElementDeclLastAttributeDeclIndex[elemChunk][elemIndex];
                attrChunk = index >> 8;
                attrIndex = index & 0xFF;
                this.fAttributeDeclNextAttributeDeclIndex[attrChunk][attrIndex] = attributeDeclIndex;
            }
            this.fElementDeclLastAttributeDeclIndex[elemChunk][elemIndex] = attributeDeclIndex;
        }
    }

    protected int createContentSpec() {
        int chunk = this.fContentSpecCount >> 8;
        int index = this.fContentSpecCount & 0xFF;
        this.ensureContentSpecCapacity(chunk);
        this.fContentSpecType[chunk][index] = -1;
        this.fContentSpecValue[chunk][index] = null;
        this.fContentSpecOtherValue[chunk][index] = null;
        return this.fContentSpecCount++;
    }

    protected void setContentSpec(int contentSpecIndex, XMLContentSpec contentSpec) {
        int chunk = contentSpecIndex >> 8;
        int index = contentSpecIndex & 0xFF;
        this.fContentSpecType[chunk][index] = contentSpec.type;
        this.fContentSpecValue[chunk][index] = contentSpec.value;
        this.fContentSpecOtherValue[chunk][index] = contentSpec.otherValue;
    }

    protected int createEntityDecl() {
        int chunk = this.fEntityCount >> 8;
        int index = this.fEntityCount & 0xFF;
        this.ensureEntityDeclCapacity(chunk);
        this.fEntityIsPE[chunk][index] = 0;
        this.fEntityInExternal[chunk][index] = 0;
        return this.fEntityCount++;
    }

    protected void setEntityDecl(int entityDeclIndex, XMLEntityDecl entityDecl) {
        int chunk = entityDeclIndex >> 8;
        int index = entityDeclIndex & 0xFF;
        this.fEntityName[chunk][index] = entityDecl.name;
        this.fEntityValue[chunk][index] = entityDecl.value;
        this.fEntityPublicId[chunk][index] = entityDecl.publicId;
        this.fEntitySystemId[chunk][index] = entityDecl.systemId;
        this.fEntityBaseSystemId[chunk][index] = entityDecl.baseSystemId;
        this.fEntityNotation[chunk][index] = entityDecl.notation;
        this.fEntityIsPE[chunk][index] = entityDecl.isPE ? (byte)1 : 0;
        this.fEntityInExternal[chunk][index] = entityDecl.inExternal ? (byte)1 : 0;
    }

    protected int createNotationDecl() {
        int chunk = this.fNotationCount >> 8;
        int index = this.fNotationCount & 0xFF;
        this.ensureNotationDeclCapacity(chunk);
        return this.fNotationCount++;
    }

    protected void setNotationDecl(int notationDeclIndex, XMLNotationDecl notationDecl) {
        int chunk = notationDeclIndex >> 8;
        int index = notationDeclIndex & 0xFF;
        this.fNotationName[chunk][index] = notationDecl.name;
        this.fNotationPublicId[chunk][index] = notationDecl.publicId;
        this.fNotationSystemId[chunk][index] = notationDecl.systemId;
        this.fNotationBaseSystemId[chunk][index] = notationDecl.baseSystemId;
    }

    protected void setTargetNamespace(String targetNamespace) {
        this.fTargetNamespace = targetNamespace;
    }

    protected boolean isDTD() {
        return true;
    }

    private void appendContentSpec(XMLContentSpec contentSpec, StringBuffer str, boolean parens, int parentContentSpecType) {
        int thisContentSpec = contentSpec.type & 0xF;
        switch (thisContentSpec) {
            case 0: {
                if (contentSpec.value == null && contentSpec.otherValue == null) {
                    str.append("#PCDATA");
                    break;
                }
                if (contentSpec.value == null && contentSpec.otherValue != null) {
                    str.append("##any:uri=" + contentSpec.otherValue);
                    break;
                }
                if (contentSpec.value == null) {
                    str.append("##any");
                    break;
                }
                str.append(contentSpec.value);
                break;
            }
            case 1: {
                if (parentContentSpecType == 3 || parentContentSpecType == 2 || parentContentSpecType == 1) {
                    this.getContentSpec(((int[])contentSpec.value)[0], contentSpec);
                    str.append('(');
                    this.appendContentSpec(contentSpec, str, true, thisContentSpec);
                    str.append(')');
                } else {
                    this.getContentSpec(((int[])contentSpec.value)[0], contentSpec);
                    this.appendContentSpec(contentSpec, str, true, thisContentSpec);
                }
                str.append('?');
                break;
            }
            case 2: {
                if (parentContentSpecType == 3 || parentContentSpecType == 2 || parentContentSpecType == 1) {
                    this.getContentSpec(((int[])contentSpec.value)[0], contentSpec);
                    str.append('(');
                    this.appendContentSpec(contentSpec, str, true, thisContentSpec);
                    str.append(')');
                } else {
                    this.getContentSpec(((int[])contentSpec.value)[0], contentSpec);
                    this.appendContentSpec(contentSpec, str, true, thisContentSpec);
                }
                str.append('*');
                break;
            }
            case 3: {
                if (parentContentSpecType == 3 || parentContentSpecType == 2 || parentContentSpecType == 1) {
                    str.append('(');
                    this.getContentSpec(((int[])contentSpec.value)[0], contentSpec);
                    this.appendContentSpec(contentSpec, str, true, thisContentSpec);
                    str.append(')');
                } else {
                    this.getContentSpec(((int[])contentSpec.value)[0], contentSpec);
                    this.appendContentSpec(contentSpec, str, true, thisContentSpec);
                }
                str.append('+');
                break;
            }
            case 4: 
            case 5: {
                if (parens) {
                    str.append('(');
                }
                short type = contentSpec.type;
                int otherValue = ((int[])contentSpec.otherValue)[0];
                this.getContentSpec(((int[])contentSpec.value)[0], contentSpec);
                this.appendContentSpec(contentSpec, str, contentSpec.type != type, thisContentSpec);
                if (type == 4) {
                    str.append('|');
                } else {
                    str.append(',');
                }
                this.getContentSpec(otherValue, contentSpec);
                this.appendContentSpec(contentSpec, str, true, thisContentSpec);
                if (!parens) break;
                str.append(')');
                break;
            }
            case 6: {
                str.append("##any");
                if (contentSpec.otherValue == null) break;
                str.append(":uri=");
                str.append(contentSpec.otherValue);
                break;
            }
            case 7: {
                str.append("##other:uri=");
                str.append(contentSpec.otherValue);
                break;
            }
            case 8: {
                str.append("##local");
                break;
            }
            default: {
                str.append("???");
            }
        }
    }

    private void printAttribute(int attributeDeclIndex) {
        XMLAttributeDecl attributeDecl = new XMLAttributeDecl();
        if (this.getAttributeDecl(attributeDeclIndex, attributeDecl)) {
            System.out.print(" { ");
            System.out.print(attributeDecl.name.localpart);
            System.out.print(" }");
        }
    }

    private ContentModelValidator createChildModel(int contentSpecIndex) {
        XMLContentSpec contentSpec = new XMLContentSpec();
        this.getContentSpec(contentSpecIndex, contentSpec);
        if ((contentSpec.type & 0xF) != 6 && (contentSpec.type & 0xF) != 7 && (contentSpec.type & 0xF) != 8) {
            XMLContentSpec contentSpecLeft;
            if (contentSpec.type == 0) {
                if (contentSpec.value == null && contentSpec.otherValue == null) {
                    throw new RuntimeException("ImplementationMessages.VAL_NPCD");
                }
                this.fQName1.setValues(null, (String)contentSpec.value, (String)contentSpec.value, (String)contentSpec.otherValue);
                return new SimpleContentModel(contentSpec.type, this.fQName1, null, this.isDTD());
            }
            if (contentSpec.type == 4 || contentSpec.type == 5) {
                contentSpecLeft = new XMLContentSpec();
                XMLContentSpec contentSpecRight = new XMLContentSpec();
                this.getContentSpec(((int[])contentSpec.value)[0], contentSpecLeft);
                this.getContentSpec(((int[])contentSpec.otherValue)[0], contentSpecRight);
                if (contentSpecLeft.type == 0 && contentSpecRight.type == 0) {
                    this.fQName1.setValues(null, (String)contentSpecLeft.value, (String)contentSpecLeft.value, (String)contentSpecLeft.otherValue);
                    this.fQName2.setValues(null, (String)contentSpecRight.value, (String)contentSpecRight.value, (String)contentSpecRight.otherValue);
                    return new SimpleContentModel(contentSpec.type, this.fQName1, this.fQName2, this.isDTD());
                }
            } else if (contentSpec.type == 1 || contentSpec.type == 2 || contentSpec.type == 3) {
                contentSpecLeft = new XMLContentSpec();
                this.getContentSpec(((int[])contentSpec.value)[0], contentSpecLeft);
                if (contentSpecLeft.type == 0) {
                    this.fQName1.setValues(null, (String)contentSpecLeft.value, (String)contentSpecLeft.value, (String)contentSpecLeft.otherValue);
                    return new SimpleContentModel(contentSpec.type, this.fQName1, null, this.isDTD());
                }
            } else {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        this.fLeafCount = 0;
        this.fLeafCount = 0;
        CMNode cmn = this.buildSyntaxTree(contentSpecIndex, contentSpec);
        return new DFAContentModel(cmn, this.fLeafCount, this.isDTD(), false);
    }

    private final CMNode buildSyntaxTree(int startNode, XMLContentSpec contentSpec) {
        CMNode nodeRet = null;
        this.getContentSpec(startNode, contentSpec);
        if ((contentSpec.type & 0xF) == 6) {
            nodeRet = new CMAny(contentSpec.type, (String)contentSpec.otherValue, this.fLeafCount++);
        } else if ((contentSpec.type & 0xF) == 7) {
            nodeRet = new CMAny(contentSpec.type, (String)contentSpec.otherValue, this.fLeafCount++);
        } else if ((contentSpec.type & 0xF) == 8) {
            nodeRet = new CMAny(contentSpec.type, null, this.fLeafCount++);
        } else if (contentSpec.type == 0) {
            this.fQName1.setValues(null, (String)contentSpec.value, (String)contentSpec.value, (String)contentSpec.otherValue);
            nodeRet = new CMLeaf(this.fQName1, this.fLeafCount++);
        } else {
            int leftNode = ((int[])contentSpec.value)[0];
            int rightNode = ((int[])contentSpec.otherValue)[0];
            if (contentSpec.type == 4 || contentSpec.type == 5) {
                nodeRet = new CMBinOp(contentSpec.type, this.buildSyntaxTree(leftNode, contentSpec), this.buildSyntaxTree(rightNode, contentSpec));
            } else if (contentSpec.type == 2) {
                nodeRet = new CMUniOp(contentSpec.type, this.buildSyntaxTree(leftNode, contentSpec));
            } else if (contentSpec.type == 2 || contentSpec.type == 1 || contentSpec.type == 3) {
                nodeRet = new CMUniOp(contentSpec.type, this.buildSyntaxTree(leftNode, contentSpec));
            } else {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        return nodeRet;
    }

    private void contentSpecTree(int contentSpecIndex, XMLContentSpec contentSpec, ChildrenList children) {
        this.getContentSpec(contentSpecIndex, contentSpec);
        if (contentSpec.type == 0 || (contentSpec.type & 0xF) == 6 || (contentSpec.type & 0xF) == 8 || (contentSpec.type & 0xF) == 7) {
            if (children.length == children.qname.length) {
                QName[] newQName = new QName[children.length * 2];
                System.arraycopy(children.qname, 0, newQName, 0, children.length);
                children.qname = newQName;
                int[] newType = new int[children.length * 2];
                System.arraycopy(children.type, 0, newType, 0, children.length);
                children.type = newType;
            }
            children.qname[children.length] = new QName(null, (String)contentSpec.value, (String)contentSpec.value, (String)contentSpec.otherValue);
            children.type[children.length] = contentSpec.type;
            ++children.length;
            return;
        }
        int leftNode = contentSpec.value != null ? ((int[])contentSpec.value)[0] : -1;
        int rightNode = -1;
        if (contentSpec.otherValue == null) {
            return;
        }
        rightNode = ((int[])contentSpec.otherValue)[0];
        if (contentSpec.type == 4 || contentSpec.type == 5) {
            this.contentSpecTree(leftNode, contentSpec, children);
            this.contentSpecTree(rightNode, contentSpec, children);
            return;
        }
        if (contentSpec.type == 1 || contentSpec.type == 2 || contentSpec.type == 3) {
            this.contentSpecTree(leftNode, contentSpec, children);
            return;
        }
        throw new RuntimeException("Invalid content spec type seen in contentSpecTree() method of Grammar class : " + contentSpec.type);
    }

    private boolean ensureElementDeclCapacity(int chunk) {
        try {
            return this.fElementDeclName[chunk][0] == null;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.fElementDeclName = AbstractDTDGrammar.resize(this.fElementDeclName, this.fElementDeclName.length * 2);
            this.fElementDeclType = AbstractDTDGrammar.resize(this.fElementDeclType, this.fElementDeclType.length * 2);
            this.fElementDeclDatatypeValidator = AbstractDTDGrammar.resize(this.fElementDeclDatatypeValidator, this.fElementDeclDatatypeValidator.length * 2);
            this.fElementDeclContentModelValidator = AbstractDTDGrammar.resize(this.fElementDeclContentModelValidator, this.fElementDeclContentModelValidator.length * 2);
            this.fElementDeclContentSpecIndex = AbstractDTDGrammar.resize(this.fElementDeclContentSpecIndex, this.fElementDeclContentSpecIndex.length * 2);
            this.fElementDeclFirstAttributeDeclIndex = AbstractDTDGrammar.resize(this.fElementDeclFirstAttributeDeclIndex, this.fElementDeclFirstAttributeDeclIndex.length * 2);
            this.fElementDeclLastAttributeDeclIndex = AbstractDTDGrammar.resize(this.fElementDeclLastAttributeDeclIndex, this.fElementDeclLastAttributeDeclIndex.length * 2);
            this.fElementDeclDefaultValue = AbstractDTDGrammar.resize(this.fElementDeclDefaultValue, this.fElementDeclDefaultValue.length * 2);
            this.fElementDeclDefaultType = AbstractDTDGrammar.resize(this.fElementDeclDefaultType, this.fElementDeclDefaultType.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fElementDeclName[chunk] = new QName[256];
        this.fElementDeclType[chunk] = new short[256];
        this.fElementDeclDatatypeValidator[chunk] = new DatatypeValidator[256];
        this.fElementDeclContentModelValidator[chunk] = new ContentModelValidator[256];
        this.fElementDeclContentSpecIndex[chunk] = new int[256];
        this.fElementDeclFirstAttributeDeclIndex[chunk] = new int[256];
        this.fElementDeclLastAttributeDeclIndex[chunk] = new int[256];
        this.fElementDeclDefaultValue[chunk] = new String[256];
        this.fElementDeclDefaultType[chunk] = new short[256];
        return true;
    }

    private boolean ensureAttributeDeclCapacity(int chunk) {
        try {
            return this.fAttributeDeclName[chunk][0] == null;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.fAttributeDeclName = AbstractDTDGrammar.resize(this.fAttributeDeclName, this.fAttributeDeclName.length * 2);
            this.fAttributeDeclType = AbstractDTDGrammar.resize(this.fAttributeDeclType, this.fAttributeDeclType.length * 2);
            this.fAttributeDeclEnumeration = AbstractDTDGrammar.resize(this.fAttributeDeclEnumeration, this.fAttributeDeclEnumeration.length * 2);
            this.fAttributeDeclDefaultType = AbstractDTDGrammar.resize(this.fAttributeDeclDefaultType, this.fAttributeDeclDefaultType.length * 2);
            this.fAttributeDeclDatatypeValidator = AbstractDTDGrammar.resize(this.fAttributeDeclDatatypeValidator, this.fAttributeDeclDatatypeValidator.length * 2);
            this.fAttributeDeclDefaultValue = AbstractDTDGrammar.resize(this.fAttributeDeclDefaultValue, this.fAttributeDeclDefaultValue.length * 2);
            this.fAttributeDeclNonNormalizedDefaultValue = AbstractDTDGrammar.resize(this.fAttributeDeclNonNormalizedDefaultValue, this.fAttributeDeclNonNormalizedDefaultValue.length * 2);
            this.fAttributeDeclNextAttributeDeclIndex = AbstractDTDGrammar.resize(this.fAttributeDeclNextAttributeDeclIndex, this.fAttributeDeclNextAttributeDeclIndex.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fAttributeDeclName[chunk] = new QName[256];
        this.fAttributeDeclType[chunk] = new short[256];
        this.fAttributeDeclEnumeration[chunk] = new String[256][];
        this.fAttributeDeclDefaultType[chunk] = new short[256];
        this.fAttributeDeclDatatypeValidator[chunk] = new DatatypeValidator[256];
        this.fAttributeDeclDefaultValue[chunk] = new String[256];
        this.fAttributeDeclNonNormalizedDefaultValue[chunk] = new String[256];
        this.fAttributeDeclNextAttributeDeclIndex[chunk] = new int[256];
        return true;
    }

    private boolean ensureEntityDeclCapacity(int chunk) {
        try {
            return this.fEntityName[chunk][0] == null;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.fEntityName = AbstractDTDGrammar.resize(this.fEntityName, this.fEntityName.length * 2);
            this.fEntityValue = AbstractDTDGrammar.resize(this.fEntityValue, this.fEntityValue.length * 2);
            this.fEntityPublicId = AbstractDTDGrammar.resize(this.fEntityPublicId, this.fEntityPublicId.length * 2);
            this.fEntitySystemId = AbstractDTDGrammar.resize(this.fEntitySystemId, this.fEntitySystemId.length * 2);
            this.fEntityBaseSystemId = AbstractDTDGrammar.resize(this.fEntityBaseSystemId, this.fEntityBaseSystemId.length * 2);
            this.fEntityNotation = AbstractDTDGrammar.resize(this.fEntityNotation, this.fEntityNotation.length * 2);
            this.fEntityIsPE = AbstractDTDGrammar.resize(this.fEntityIsPE, this.fEntityIsPE.length * 2);
            this.fEntityInExternal = AbstractDTDGrammar.resize(this.fEntityInExternal, this.fEntityInExternal.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fEntityName[chunk] = new String[256];
        this.fEntityValue[chunk] = new String[256];
        this.fEntityPublicId[chunk] = new String[256];
        this.fEntitySystemId[chunk] = new String[256];
        this.fEntityBaseSystemId[chunk] = new String[256];
        this.fEntityNotation[chunk] = new String[256];
        this.fEntityIsPE[chunk] = new byte[256];
        this.fEntityInExternal[chunk] = new byte[256];
        return true;
    }

    private boolean ensureNotationDeclCapacity(int chunk) {
        try {
            return this.fNotationName[chunk][0] == null;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.fNotationName = AbstractDTDGrammar.resize(this.fNotationName, this.fNotationName.length * 2);
            this.fNotationPublicId = AbstractDTDGrammar.resize(this.fNotationPublicId, this.fNotationPublicId.length * 2);
            this.fNotationSystemId = AbstractDTDGrammar.resize(this.fNotationSystemId, this.fNotationSystemId.length * 2);
            this.fNotationBaseSystemId = AbstractDTDGrammar.resize(this.fNotationBaseSystemId, this.fNotationBaseSystemId.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fNotationName[chunk] = new String[256];
        this.fNotationPublicId[chunk] = new String[256];
        this.fNotationSystemId[chunk] = new String[256];
        this.fNotationBaseSystemId[chunk] = new String[256];
        return true;
    }

    private boolean ensureContentSpecCapacity(int chunk) {
        try {
            return this.fContentSpecType[chunk][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.fContentSpecType = AbstractDTDGrammar.resize(this.fContentSpecType, this.fContentSpecType.length * 2);
            this.fContentSpecValue = AbstractDTDGrammar.resize(this.fContentSpecValue, this.fContentSpecValue.length * 2);
            this.fContentSpecOtherValue = AbstractDTDGrammar.resize(this.fContentSpecOtherValue, this.fContentSpecOtherValue.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fContentSpecType[chunk] = new short[256];
        this.fContentSpecValue[chunk] = new Object[256];
        this.fContentSpecOtherValue[chunk] = new Object[256];
        return true;
    }

    private static byte[][] resize(byte[][] array, int newsize) {
        byte[][] newarray = new byte[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private static short[][] resize(short[][] array, int newsize) {
        short[][] newarray = new short[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private static int[][] resize(int[][] array, int newsize) {
        int[][] newarray = new int[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private static DatatypeValidator[][] resize(DatatypeValidator[][] array, int newsize) {
        DatatypeValidator[][] newarray = new DatatypeValidator[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private static ContentModelValidator[][] resize(ContentModelValidator[][] array, int newsize) {
        ContentModelValidator[][] newarray = new ContentModelValidator[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private static Object[][] resize(Object[][] array, int newsize) {
        Object[][] newarray = new Object[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private static QName[][] resize(QName[][] array, int newsize) {
        QName[][] newarray = new QName[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private static String[][] resize(String[][] array, int newsize) {
        String[][] newarray = new String[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    private static String[][][] resize(String[][][] array, int newsize) {
        String[][][] newarray = new String[newsize][][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }

    public boolean isEntityDeclared(String name) {
        return this.getEntityDeclIndex(name) != -1;
    }

    public boolean isEntityUnparsed(String name) {
        int entityIndex = this.getEntityDeclIndex(name);
        if (entityIndex > -1) {
            int chunk = entityIndex >> 8;
            int index = entityIndex & 0xFF;
            return this.fEntityNotation[chunk][index] != null;
        }
        return false;
    }

    protected static final class TupleHashtable {
        private static final int INITIAL_BUCKET_SIZE = 4;
        private static final int HASHTABLE_SIZE = 101;
        private Object[][] fHashTable = new Object[101][];

        protected TupleHashtable() {
        }

        public void put(int key1, String key2, String key3, int value) {
            int hash = (key1 + this.hash(key2) + this.hash(key3) + 2) % 101;
            Object[] bucket = this.fHashTable[hash];
            if (bucket == null) {
                bucket = new Object[17];
                bucket[0] = new int[]{1};
                bucket[1] = new int[]{key1};
                bucket[2] = key2;
                bucket[3] = key3;
                bucket[4] = new int[]{value};
                this.fHashTable[hash] = bucket;
            } else {
                int count = ((int[])bucket[0])[0];
                int offset = 1 + 4 * count;
                if (offset == bucket.length) {
                    int newSize = count + 4;
                    Object[] newBucket = new Object[1 + 4 * newSize];
                    System.arraycopy(bucket, 0, newBucket, 0, offset);
                    bucket = newBucket;
                    this.fHashTable[hash] = bucket;
                }
                boolean found = false;
                int j = 1;
                int i = 0;
                while (i < count) {
                    if (((int[])bucket[j])[0] == key1 && (String)bucket[j + 1] == key2 && (String)bucket[j + 2] == key3) {
                        ((int[])bucket[j + 3])[0] = value;
                        found = true;
                        break;
                    }
                    j += 4;
                    ++i;
                }
                if (!found) {
                    bucket[offset++] = new int[]{key1};
                    bucket[offset++] = key2;
                    bucket[offset++] = key3;
                    bucket[offset] = new int[]{value};
                    ((int[])bucket[0])[0] = ++count;
                }
            }
        }

        public int get(int key1, String key2, String key3) {
            int hash = (key1 + this.hash(key2) + this.hash(key3) + 2) % 101;
            Object[] bucket = this.fHashTable[hash];
            if (bucket == null) {
                return -1;
            }
            int count = ((int[])bucket[0])[0];
            int j = 1;
            int i = 0;
            while (i < count) {
                if (((int[])bucket[j])[0] == key1 && (String)bucket[j + 1] == key2 && (String)bucket[j + 2] == key3) {
                    return ((int[])bucket[j + 3])[0];
                }
                j += 4;
                ++i;
            }
            return -1;
        }

        protected int hash(String symbol) {
            if (symbol == null) {
                return 0;
            }
            int code = 0;
            int length = symbol.length();
            int i = 0;
            while (i < length) {
                code = code * 37 + symbol.charAt(i);
                ++i;
            }
            return code & 0x7FFFFFF;
        }
    }

    private static class ChildrenList {
        public int length = 0;
        public QName[] qname = new QName[2];
        public int[] type = new int[2];

        private ChildrenList() {
        }
    }
}

