/* insmacro.h */
/* Copyright 1996 Bent Lynggaard */

/* 1997-01-28. Version 1.00.
*/

/* Inserts macros into or deletes macros from help files. Lists current
   macros in a MessageBox window, copies them to the Clipboard, or writes
   them to a file.
   Based on an idea by Cub Lea <cublea@cyberstore.ca>.

   The program is a Dynamic Link Library (DLL) exporting several functions,
   see the declarations later in this file.

   All functions take the path to a help file as their first parameter. All
   but one take a flag "message" as their last parameter. If the the flag
   differs from 0, the function will show any error in a MessageBox, if the
   flag is 0, the function is "silent".

   The functions (less one) return 0 in case of success. They return an error
   code in case of failure:
	 100 Unknown function (outside range 0-2)
	 101 Too many macros defined in listbox
	 102 Insufficient local heap available
	 103 Not a Win3.1 or Win95 help file
	 104 Internal error
	 105 Insufficient global heap available
	 106 Could not open output file
	 107 Could not copy to Clipboard

	 201 Error in help file
	 202 Error in help file
	 203 Internal error
	 204 Error in help file
	 205 Error in help file
	 206 Error in help file
	 207 Error in help file
	 208 Could not open (not present/sharing violation/write protected?)
	 209 Not a help file
	 210 Unknown appendix to help file
	 212 Insufficient local heap available
	 213 Error in help file
	 214 Internal error
	 215 Error in help file
	 216 Disk full, file probably corrupted
	 220 RoboHelp appendix to help file
   This file defines a string for each error message. Errors 100, 103, 106,
   208, 209, 210, and 220 are predictable (and error 216 if the disk is almost
   full). The author will appreciate to be notified if any other error
   occurs and can be reached on Internet address bent.lynggaard@risoe.dk.

   The GetMacrosAsGlobal() function returns a valid GLOBALHANDLE for success,
   and returns NULL and displays en error message for failure.

   Most of the functions can be called from another help file if the functions
   are registered with the RegisterRoutine() macro. The RRs are listed as
   comments to the declarations of these routines. The returned value can be
   used to control an IfThen() or IfThenElse() macro in the calling help file.
   If the calling help file has the project macro (defined in [CONFIG]):
	 RR(`insmacro.dll',`InsertMacro',`i=SSu')
   it can invokes the macro:
IfThenElse(InsertMacro(`test.hlp',`CreateButton(`id_copy', `Cop&y', `CopyTopic()');CreateButton(`id_print',`&Print',`Print()')', 1, 1),`PI(qchPath,`id_error')',`PI(qchPath,`id_ok')')
   and thus insert the macro
CreateButton(`id_copy', `Cop&y', `CopyTopic()');CreateButton(`id_exit',`E&xit',`Exit()')
   into file test.hlp if it is present and writable, and one of the two
   topics `id_ok' or `id_error' pops up to indicate success or failure.
   It is recommended to use a non-zero "message" flag when the functions are
   called from a help file, because WinHelp cannot analyze the returned value,
   only react on its zero/non-zero value.
*/

#include <windows.h>

int FAR PASCAL _export InsertMacros(LPSTR lpFilename, HANDLE hwndMacrosList,
	WORD subfunction, int message);
/*	Do not call this function with a WinHelp macro, as you cannot pass a handle
	to a listbox.
	lpFilename: path to help file;
	hwndMacrosList: handle of Windows ListBox with macros as elements;
	subfunction:
		0: delete macros from the file's project macros;
		1: insert macros into the file's project macros list, no duplicates;
		2: insert macros into the file's project macros list, duplicates accepted;
		Deletes and duplicates are based on exact match on letter case, spacing,
		and type of quotes. "No duplicates" refers to macros currently defined
		in the help file, the program has no objections against two or more
		identical macros defined in the listbox parameter. However, all such
		macros are ignored if subfunction is 1 and one is already present in
		the help file.
	message:
		0: no error handling in insmacro.dll;
		not 0: show error number in MessageBox;
	return value:
		0: success;
		not 0: error number;
*/

int FAR PASCAL _export InsertMacro(LPSTR lpFilename, LPSTR lpMacro,
	WORD subfunction, int messsage);
/*  RR(`insmacro.dll', `InsertMacro', `i=SSui')
	lpFilename: path to help file;
	lpMacro: macro string (can be more semicolon-delimited macros);
	subfunction:
		0: delete macro from the file's project macros;
		1: insert macro into the file's project macros list, no duplicate;
		2: insert macro into the file's project macros list, duplicate accepted;
		See comment to InsertMacros().
	message: 0: no error handling; not 0: show error in MessageBox;
	return value: 0: success; not 0: error number;
*/

int FAR PASCAL _export ShowMacroMessagebox(LPSTR lpFilename, int message);
/*  RR(`insmacro.dll', `ShowMacroMessagebox', `i=Si')
	lpFilename: path to help file;
	message: 0: no error handling; not 0: show error in MessageBox;
	return value: 0: success; not 0: error number;
	The function shows the current macros in a MessageBox.
*/

int FAR PASCAL _export CopyMacrosToClipboard(LPSTR lpFilename, int message);
/*  RR(`insmacro.dll', `CopyMacroToClipboard', `i=Si')
	lpFilename: path to help file;
	message: 0: no error handling; not 0: show error in MessageBox;
	return value: 0: success; not 0: error number;
	The function copies the current macros to the Clipboard.
*/

int FAR PASCAL _export WriteMacrosToFile(LPSTR lpFilename, LPSTR lpOutFilename,
	LPSTR initialString, LPSTR finalString, LPSTR noneString, int message);
/*  RR(`insmacro.dll', `WriteMacrosToFile', `i=SSSSSi')
	lpFilename: path to help file;
	lpOutFilename: path to output file;
	initialString: string to insert at the beginning of the output file;
	finalString: string to insert at end of the output file if the help file
		has project macros;
	noneString: string to insert at end of the output file if the help file has
		no project macros;
		The function ignores NULL string pointers and empty strings, and appends
		CR/LF to all other strings.
	message: 0: no error handling; not 0: show error in a MessageBox;
	return value: 0: success; not 0: error number;
	The function writes the current macros to the specified output file.
*/

GLOBALHANDLE FAR PASCAL _export GetMacrosAsGlobal(LPSTR lpFilename);
/*	Do not call this function with a WinHelp macro, as you cannot release the
	memory it returns.
	lpFilename: path to help file;
	return value: NULL for failure, else the handle of global memory with the
		current macros.
	In case of failure the function displays an error message in a MessageBox.
	It is the user's responsibility to release the global memory after use.
	Example:
		GLOBALHANDLE hMem;
		LPSTR lpstrz;
		hMem = GetMacrosAsGlobal("myfile.hlp");
		if (hMem) {
			lpstrz = GlobalLock(hMem);
			// use the pointer, macros are separated by CR/LF ("\r\n")
			GlobalUnlock(hMem);
			GlobalFree(hMem);
		} // if (hMem)
		else {
			; // error handling (error number already reported in a MessageBox)
		}
*/

/* error message strings: */
#define IM_ERR100 "Unknown function (outside range 0-2)"
#define IM_ERR101 "Too many macros defined in listbox"
#define IM_ERR102 "Insufficient local heap available (102)"
#define IM_ERR103 "Not a Win3.1 or Win95 help file"
#define IM_ERR104 "Internal error (104)"
#define IM_ERR105 "Insufficient global heap available"
#define IM_ERR106 "Could not open output file"
#define IM_ERR107 "Could not copy to Clipboard"

#define IM_ERR201 "Error in help file (201)"
#define IM_ERR202 "Error in help file (202)"
#define IM_ERR203 "Internal error (203)"
#define IM_ERR204 "Error in help file (204)"
#define IM_ERR205 "Error in help file (205)"
#define IM_ERR206 "Error in help file (206)"
#define IM_ERR207 "Error in help file (207"
#define IM_ERR208 "Could not open (not present/sharing violation/write protected?)"
#define IM_ERR209 "Not a help file"
#define IM_ERR210 "Unknown appendix to help file"
#define IM_ERR212 "Insufficient local heap available (212)"
#define IM_ERR213 "Error in help file (213)"
#define IM_ERR214 "Internal error (214)"
#define IM_ERR215 "Error in help file (215)"
#define IM_ERR216 "Disk full, file probably corrupted"
#define IM_ERR220 "RoboHelp appendix to help file"


