// winbmp.h by Bill Buckels 1994

// menu ID constants - IDM - IDentifier Menu

#define IDM_LOAD    1001
#define IDM_SAVE    1002
#define IDM_IMPORT  1003
#define IDM_CONVERT 1004
#define IDM_DELETE  1005
#define IDM_EXIT    1006
#define IDM_PTX     1007

#define IDM_PASTE   2001
#define IDM_COPY    2002
#define IDM_CLIP    2003
#define IDM_REVERSE 2004
#define IDM_ENTRY   2005
#define IDM_COLOR   2006

// Fast Keys Bitmap Items
// bitmap 0 is not an active item. it is a menu information item.
#define IDM_BITMAP0            300
#define IDM_BITMAP1            3000
#define IDM_BITMAP2            3001
#define IDM_BITMAP3            3002
#define IDM_BITMAP4            3003
#define IDM_BITMAP5            3004
#define IDM_BITMAP6            3005
#define IDM_BITMAP7            3006
#define IDM_BITMAP8            3007
#define IDM_BITMAP9            3008
#define IDM_BITMAP10           3009
#define IDM_BITMAP11           3010
#define IDM_BITMAP12           3011

// accelerator fast keys
#define IDK_FASTSET1           500
#define IDK_FASTSET2           501
#define IDK_FASTSET3           502
#define IDK_FASTSET4           503
#define IDK_FASTSET5           504
#define IDK_FASTSET6           505
#define IDK_FASTSET7           506
#define IDK_FASTSET8           507
#define IDK_FASTSET9           508
#define IDK_FASTSET10          509

// more menu constants

#define IDM_ABOUT   4001
#define IDM_LICENCE 4002
#define IDM_HELP    4003

#define IDD_CANCEL   5000
#define IDD_EDITTEXT 5001

long far PASCAL WndProc (HWND, WORD, WORD, LONG);
BOOL FAR PASCAL EntryDlgProc(HWND, unsigned, WORD, LONG);

// Command Message Handlers

long far PASCAL MyLoad(HWND);
long far PASCAL MySave(HWND);
long far PASCAL MyConvert(HWND);
long far PASCAL MyImport(HWND, WORD);
long far PASCAL MyDelete(HWND);

long far PASCAL MyPaste(HWND);
long far PASCAL MyCopy(HWND);
long far PASCAL MyClip(HWND);
long far PASCAL MyReverse(HWND);
long far PASCAL MyColor(HWND);
long far PASCAL MyEntry(HWND);
long far PASCAL MyFastEntry(HWND,unsigned char);

long far PASCAL MyHelp(HWND);
long far PASCAL MyLicence(HWND);
long far PASCAL MyAbout(HWND);

long far PASCAL MyPaintMethod();

// Core Routines

// initialization
int InitPic(HANDLE);
int FreePic(HANDLE);

// conversion
int InitDialog(HWND,WORD);
int LoadPic(LPSTR);
int SavePic(LPSTR);
int ConvertPic(LPSTR);
int ConvertTxt(LPSTR);
int KillPic(LPSTR);
int ShowPic(WORD,WORD);
int ShowTitle(LPSTR, BYTE huge *);

// editing
int ColorFlip(WORD);
void RectClear(void);
int RectRestore(void);
int RectMove(int,int,int,int);
int PaintPic(WORD,WORD,int,int);
int PutLetter(int,int,unsigned char);
int PutFast(int, int,unsigned char);

#define DIR_ANY   0              // constants for directory search types
#define DIR_TEXT  1
#define DIR_BMP   2
#define DIR_BSV   3
#define DIR_PTX   4

#define MAXFILENAME 256          // maximum length of file pathname
#define MAXCUSTFILTER 40         // maximum size of custom filter buffer

#define INPUTSIZE 80              // max length of input - various cases

// constants for buffer sizes and screen control min-max calculations
#define C_WIDTH     8             // cell width
#define C_HEIGHT    19            // cell height
#define F_HEIGHT    16            // font cell height
#define C_ENDWIDTH  7             // right pixel in cell
#define C_ENDHEIGHT 18            // bottom pixel in cell
#define VGA_MAXY    480           // maximum height of the VGA
#define BMP_MAXY    475           // maximum supported bitmap height
#define BMP_MAXX    640           // maximum supported bitmap width
#define BUFPAD_MAXY 476           // safety margin for pointer out of bounds
#define BUF_MAXY    474           // maximum 0 based buffer height
#define BUF_MAXX    639           // maximum 0 based buffer width
#define ROW_MAX     25            // maximum text rows allowed
#define MONOMAP     8             // size in bytes of a mono rgbquad entry
