/*
 * sample 13
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mgui.h"

void ExitCB(MOBJECT obj, void *a, void *b)
{
	obj = MObjectShell(obj);
	MShellUnrealize(obj);
	MShellDestroy(obj);
	MGUITerm();
	exit(0);
}

void ScrolledListCB(MOBJECT p, LIST_ACT *la, void *v)
{
	char str[128];

	sprintf(str, "Row # %ld selected\n<%s>\nuser data: %ld", la->pos, la->item, la->u_data);
	MMessageDialog("", str, "Ok", NULL);
}

void MGUIMain(int argc, char **argv)
{
	MOBJECT pbutton, shell, slist;
	int i;
	char str[512];
	MTColor white, seagreen;

	white = MWhiteColor();
	seagreen = MAllocColor(0x70, 0xa5, 0xa0);

	shell = MCreateShell("Sample 11", SF_MODAL);

	slist = MCreateSList(shell, DEFAULT_FONT, 16, 10, 12);
	MSListSetCallback(slist, ScrolledListCB, slist);
	MSListSetSortCallback(slist, strcmp);

	MSBLSetHead(slist, "Title1   Title2 ");
	MSBLHeadSetColor(slist, seagreen, white);

	for (i=0; i<50; i++) {
		sprintf(str, "%c%c%03d cogn%04d", 'a'+i%26, 'a'+i%10, i, i);
		MSListAddItem(slist, str, (void *)i);
	}

	pbutton = MCreatePButton(shell, "Close", TIMES_L_FONT);
	MPButtonSetCallback(pbutton, ExitCB, NULL);
	MObjectSetResize(pbutton, False, False);

	MShellRealize(shell);

	MMainLoop();
}
