#include "fstream.h"
#include "ctype.h"
#include "csa.h"
#include "csdb.h"




////////////////////////////////////////////////////////////////////////
///////////////  Global declarations ///////////////////////////////////
////////////////////////////////////////////////////////////////////////


#define MAXWORDLENGTH  20



char   WordBuffer[MAXWORDLENGTH+1];
BTREEa bt;  // An instance of the BTREEa (strings) class.



////////////////////////////////////////////////////////////////////////
///////////////  Insert Words in BTREE	////////////////////////////////
////////////////////////////////////////////////////////////////////////

int InsertWord(char *p)
{

  long count;


  if(bt.search(p,&count))
  {
    // The word is already in the btree. Increase counter.
    count++;
  }
  else
  {
    // A new word.
    count=1;
  }


  return bt.insert(p,&count); // Returns TRUE on success.

}



////////////////////////////////////////////////////////////////////////
///////////////  Process input file ////////////////////////////////////
////////////////////////////////////////////////////////////////////////


int CountWords(char *fina)
{


  char	 c;
  char	*cp;
  int	 len;

  ifstream ins(fina);
  if(!ins)
  {

      cout<<"Error, can't open "<<fina<<'.'<<endl;
      return FALSE;
  }



  len=0;
  cp=WordBuffer;

  while(!ins.eof())
  {

    ins.get(c);


    if(isalnum(c) && len<MAXWORDLENGTH)
    {
     *cp++=c;
      len++;
    }
    else
    {
      if(len>0)
      {
	*cp=0;
	 InsertWord(WordBuffer);
	 cp=WordBuffer;
	 if(isalnum(c)) { len=1; *cp++=c; }
	 else		  len=0;
      }
    }

  }

  if(len>0) { *cp=0; InsertWord(WordBuffer); }

  return TRUE;


}


////////////////////////////////////////////////////////////////////////
///////////////  Display results ///////////////////////////////////////
////////////////////////////////////////////////////////////////////////

int DisplayCount(void)
{

  long counter;

  if(bt.first(WordBuffer,&counter))  // Read the first key.
  {				     // Fails only if the btree is empty.

    do
    {
      cout.width(24);
      cout.fill('.');
      cout.setf(ios::left, ios::adjustfield);
      cout<<WordBuffer<<"  "<<counter<<endl;
    }
    while(bt.next(1,WordBuffer,&counter));     // Next key.
  }

  return TRUE;
}



////////////////////////////////////////////////////////////////////////
///////////////  Display Intro screen //////////////////////////////////
////////////////////////////////////////////////////////////////////////

void help(void)
{
      cout<<endl<<endl;
      cout<<"EXAMPLE version 1.0 for "<<_CP_PLATFORM<<endl;
      cout<<"  Reads an ASCII input file and displays an"<<endl;
      cout<<"  alphabetical list with word frequencies."<<endl<<endl;
      cout<<"Copyright (c) ComBits, 1996"<<endl;
      cout<<"Compiled: "<<__DATE__<<",  "<<__TIME__<<endl<<endl;
      cout<<"SYNTAX:  demo <filename>     "<<endl;
      cout<<"  filename: The name of the input file.  "<<endl<<endl;
      cout<<"EXAMPLE: demo input.txt     "<<endl;
}

////////////////////////////////////////////////////////////////////////
///////////////  Main program //////////////////////////////////////////
////////////////////////////////////////////////////////////////////////



int main(int argc,char *argv[])
{


  if(argc!=2)
  {
    help();
    return 1;
  }




  if(!bt.define("demo.dbf",MAXWORDLENGTH,sizeof(long)))
  {
     cout<<"Error, can't create btree "<<"demo.dbf"<<'.'<<endl;
     return 8;
  }



  if(!bt.open("demo.dbf",100))  // Open with 100Kb buffers.
  {
     cout<<"Error, can't open btree "<<"demo.dbf"<<'.'<<endl;
     return 8;
  }


  // Process input file and count the words.
  CountWords(argv[1]);


  // Display Results.
  DisplayCount();


  bt.close();

  bt.display_error(); //Display errors IF ANY! Otherwise nothing is displayed.


//  remove("demo.dbf");  // Remove btree file.

  return 0;

}
