//
// EXE File Icon Whacker
// By: Mitch Howard - 10/95
//
#include <windows.h>
#include <commdlg.h>
#include <mmsystem.h>
#include <shellapi.h>
#include <stdlib.h>
#include <mem.h>
#include <dir.h>

#include "iconwack.h"
#include "iwhelp.h"

const char *appname = "IconWhack";
const char *HelpFileName = "ICONWACK.HLP";
const char *IniName = "ICONWACK.INI";
int SoundFlag;
HANDLE hInst;
HICON hicon;
HBITMAP hBmp[NBITMAPS];
HWND hwndBtn[NBUTTONS];

#pragma argsused
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdParam, int nCmdShow)
{
	WORD tx,ty;
	MSG msg;
	WNDCLASS wc;
	HWND hwnd;

	hInst = hInstance;  // Store Instance in Global variable
	hicon = LoadIcon(hInstance,"ICONWACK_ICON");  // Store Icon in Global var
	hBmp[0] = LoadBitmap(hInstance,"WACK_UP");
	hBmp[1] = LoadBitmap(hInstance,"WACK_DOWN");
	hBmp[2] = LoadBitmap(hInstance,"UNWACK_UP");
	hBmp[3] = LoadBitmap(hInstance,"UNWACK_DOWN");
	hBmp[4] = LoadBitmap(hInstance,"HELP_UP");
	hBmp[5] = LoadBitmap(hInstance,"HELP_DOWN");
	hBmp[6] = LoadBitmap(hInstance,"EXIT_UP");
	hBmp[7] = LoadBitmap(hInstance,"EXIT_DOWN");

	SoundFlag = FALSE;
	if (waveOutGetNumDevs() > 0)
		SoundFlag = TRUE;

	if (!hPrevInstance) {
		wc.style = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
		wc.lpfnWndProc = (WNDPROC) WndProc;
		wc.cbClsExtra = 0;
		wc.cbWndExtra = 0;
		wc.hInstance = hInstance;
		wc.hIcon = hicon;
		wc.hCursor = LoadCursor(NULL,IDC_ARROW);
		wc.hbrBackground = GetStockObject(WHITE_BRUSH);
		wc.lpszMenuName = "ICONWACK_MENU";
		wc.lpszClassName = appname;
		RegisterClass(&wc);
	}
	tx = GetSystemMetrics(SM_CXFRAME)*2 + (BMPHEIGHT * NBUTTONS) + NBUTTONS;
	ty = GetSystemMetrics(SM_CYFRAME)*2 + GetSystemMetrics(SM_CYMENU);
	ty += GetSystemMetrics(SM_CYCAPTION) + BMPHEIGHT + 1;
	hwnd = CreateWindow(appname,appname, WS_OVERLAPPEDWINDOW,
							CW_USEDEFAULT, CW_USEDEFAULT,
							tx, ty, NULL, NULL, hInstance, NULL);
	CenterDialog(hwnd);
	ShowWindow(hwnd,nCmdShow);
	UpdateWindow(hwnd);

	while (GetMessage(&msg,NULL,0,0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}

	return msg.wParam;
}

long FAR PASCAL WndProc(HWND hwnd, WORD message, WPARAM wParam, LPARAM lParam)
{
	WORD z;
	LPMEASUREITEMSTRUCT lpMeasure;
	LPDRAWITEMSTRUCT lpDraw;

	switch (message) {
		case WM_CREATE:
			for (z = 0; z < NBUTTONS; z++) {
				hwndBtn[z] = CreateWindow("button","",BS_OWNERDRAW | WS_CHILD | WS_VISIBLE | WS_BORDER,
												z * BMPWIDTH + 2,1,BMPWIDTH,BMPHEIGHT,hwnd,z+1,hInst,NULL);
			}
			return 0;
		case WM_DESTROY:
			WinHelp(hwnd,HelpFileName,HELP_QUIT,0L);
			for (z = 0; z < NBITMAPS; z++) {
				if (hBmp[z])
					DeleteObject(hBmp[z]);
			}
			PostQuitMessage(0);
			return 0;
		case WM_MEASUREITEM:
			lpMeasure = (LPMEASUREITEMSTRUCT) lParam;
			lpMeasure->CtlType = ODT_BUTTON;
			for (z = 0; z < NBUTTONS; z++) {
				if (wParam == hwndBtn[z]) {
					lpMeasure->CtlID = z+1;
					break;
				}
			}
			lpMeasure->itemID = 0;
			lpMeasure->itemWidth = BMPWIDTH;
			lpMeasure->itemHeight = BMPHEIGHT;
			lpMeasure->itemData = 0;
			return 0;
		case WM_DRAWITEM:
			lpDraw = (DRAWITEMSTRUCT FAR*) lParam;
			if ((lpDraw->itemAction == ODA_DRAWENTIRE) || (lpDraw->itemAction == ODA_SELECT)) {
				for (z = 0; z < NBUTTONS; z++) {
					if (lpDraw->CtlID == z+1) {
						if (lpDraw->itemState & ODS_SELECTED)
							DrawBitmap(lpDraw->hDC,hBmp[z+z+1],lpDraw->rcItem.left,lpDraw->rcItem.top);
						else
							DrawBitmap(lpDraw->hDC,hBmp[z+z],lpDraw->rcItem.left,lpDraw->rcItem.top);
					}
				}
			}
			return 0;
		case WM_COMMAND:
			if (LOWORD(lParam)) {		// From a Control
				switch (HIWORD(lParam)) {
					case BN_CLICKED:
						switch (wParam) {
							case 1:
								PostMessage(hwnd,WM_COMMAND,CM_WHACK,0L);
								break;
							case 2:
								PostMessage(hwnd,WM_COMMAND,CM_UNWHACK,0L);
								break;
							case 3:
								PostMessage(hwnd,WM_COMMAND,CM_HELP,0L);
								break;
							case 4:
								PostMessage(hwnd,WM_COMMAND,CM_EXIT,0L);
								break;
						}
				}
				return 0;
			}
			else {
				if (MyCommand(hwnd,wParam) == 0)
					return 0;
			}
			break;
	}
	return DefWindowProc(hwnd,message,wParam,lParam);
}

int MyCommand(HWND hwnd,WPARAM wParam)
{
//
// Handle WM_COMMAND messages
// Returns TRUE if the message was not handled
//
	DLGPROC dlgproc;

	switch (wParam) {
		case CM_WHACK:
			dlgproc = MakeProcInstance(DlgProc1, hInst);
			DialogBox(hInst,"ICONWACK_DLG1",hwnd,dlgproc);
			FreeProcInstance(dlgproc);
			break;
		case CM_UNWHACK:
			dlgproc = MakeProcInstance(DlgProc2, hInst);
			DialogBox(hInst,"ICONWACK_DLG2",hwnd,dlgproc);
			FreeProcInstance(dlgproc);
			break;
		case CM_HELPABOUT:
			dlgproc = MakeProcInstance(DlgProcAbout, hInst);
			DialogBox(hInst,"ICONWACK_ABOUT",hwnd,dlgproc);
			FreeProcInstance(dlgproc);
			break;
		case CM_HELP:
			WinHelp(hwnd,HelpFileName,HELP_CONTENTS,0L);
			break;
		case CM_EXIT:
			SendMessage(hwnd,WM_CLOSE,0,0L);
			break;
		default:
			return TRUE;
	}
	return FALSE;
}

BOOL FAR PASCAL _export DlgProc1(HWND hDlg,WORD message,WPARAM wParam,LPARAM lParam)
{
	char exename[MAX_FILELEN];
	char iconame[MAX_FILELEN];
	static char temp[MAX_FILELEN+20];
	int oldmode, iconum;
	HWND lbwh, icwh;
	HICON hic, nicons;
	WORD z, iw;
	UINT inum;
	HDC hdc;
	HPEN oldpen;
	LPMEASUREITEMSTRUCT lpMeasure;
	LPDRAWITEMSTRUCT lpDraw;
	RECT r;

	switch (message) {
		case WM_INITDIALOG:
			CenterDialog(hDlg);
			SendDlgItemMessage(hDlg,IDC_EDIT1,EM_LIMITTEXT,MAX_FILELEN,0L);
			SendDlgItemMessage(hDlg,IDC_EDIT2,EM_LIMITTEXT,MAX_FILELEN,0L);
			GetPrivateProfileString("WHACKDLG","DEST","",exename,MAX_FILELEN,IniName);
			SetDlgItemText(hDlg,IDC_EDIT1,exename);
			icwh = GetDlgItem(hDlg,IDC_ICONEXE);
			if (FileExists(exename)) {
				hic = ExtractIcon(hInst,exename,0);
				if (hic != NULL) {
					SendDlgItemMessage(hDlg,IDC_ICONEXE,STM_SETICON,(WPARAM) hic,0L);
					InvalidateRect(icwh,NULL,TRUE);
					UpdateWindow(icwh);
				}
				SetFocus(GetDlgItem(hDlg,IDC_EDIT2));
			}
			GetPrivateProfileString("WHACKDLG","SOURCE","",iconame,MAX_FILELEN,IniName);
			SetDlgItemText(hDlg,IDC_EDIT2,iconame);
			if (FileExists(iconame)) {
				lbwh = GetDlgItem(hDlg,IDC_ICONLB);
				nicons = ExtractIcon(hInst,iconame,-1);
				if (nicons != NULL) {
					SendMessage(lbwh,LB_RESETCONTENT,0,0L);
					for (z = 0; z < nicons; z++)
						SendMessage(lbwh,LB_ADDSTRING,0,z);
					SendMessage(lbwh,LB_SETCURSEL,0,0);
				}
				SetFocus(GetDlgItem(hDlg,IDC_ICONLB));
			}
			return TRUE;
		case WM_MEASUREITEM:
			lpMeasure = (LPMEASUREITEMSTRUCT) lParam;
			lpMeasure->CtlType = ODT_LISTBOX;
			lpMeasure->CtlID = IDC_ICONLB;
			lpMeasure->itemID = 0;
			lpMeasure->itemWidth = GetSystemMetrics(SM_CXICON) + 2;
			lpMeasure->itemHeight = GetSystemMetrics(SM_CYICON) + 2;
			lpMeasure->itemData = 0;
			return TRUE;
		case WM_DRAWITEM:
			lpDraw = (DRAWITEMSTRUCT FAR*) lParam;
			hdc = lpDraw->hDC;
			r = lpDraw->rcItem;
			inum = (UINT) lpDraw->itemData;
			switch (lpDraw->itemAction) {
				case ODA_DRAWENTIRE:
				case ODA_SELECT:
					GetDlgItemText(hDlg,IDC_EDIT2,iconame,MAX_FILELEN);
					hic = ExtractIcon(hInst,iconame,inum);
					if (hic != NULL) {
						DrawIcon(hdc,r.left+2,r.top+2,hic);
						DestroyIcon(hic);
					}
					return TRUE;
				case ODA_FOCUS:
					oldmode = SetBkMode(hdc,TRANSPARENT);
					if (lpDraw->itemState & ODS_FOCUS)
						oldpen = SelectObject(hdc,GetStockObject(BLACK_PEN));
					else
						oldpen = SelectObject(hdc,GetStockObject(WHITE_PEN));
					MoveTo(hdc,r.left,r.top);
					iw = GetSystemMetrics(SM_CXICON);
					LineTo(hdc,r.left+iw+3,r.top);
					LineTo(hdc,r.left+iw+3,r.bottom+1);
					LineTo(hdc,r.left,r.bottom+1);
					LineTo(hdc,r.left,r.top);
					SelectObject(hdc,oldpen);
					SetBkMode(hdc,oldmode);
					return TRUE;
			}
			return (FALSE);
		case WM_COMMAND:
			switch (wParam) {
				case IDC_HELP:
					WinHelp(hDlg,HelpFileName,HELP_CONTEXT,HLP_DLG1);
					return TRUE;
				case IDC_BROWSEEXE:
					if (BrowseFile(hDlg,0,exename)) {
						SetDlgItemText(hDlg,IDC_EDIT1,exename);
						icwh = GetDlgItem(hDlg,IDC_ICONEXE);
						if (FileExists(exename)) {
							hic = ExtractIcon(hInst,exename,0);
							if (hic == NULL)
								MessageBox(hDlg,"No icons in this EXE file.","Error",MB_OK);
							else {
								SendDlgItemMessage(hDlg,IDC_ICONEXE,STM_SETICON,(WPARAM) hic,0L);
								InvalidateRect(icwh,NULL,TRUE);
								UpdateWindow(icwh);
							}
							SetFocus(GetDlgItem(hDlg,IDC_EDIT2));
						}
						else
							SetFocus(GetDlgItem(hDlg,IDC_EDIT1));
					}
					else
						SetFocus(GetDlgItem(hDlg,IDC_EDIT1));
//					SendDlgItemMessage(hDlg, IDC_BROWSEEXE, BM_SETSTATE, FALSE, 0L);
					return TRUE;
				case IDC_BROWSEICO:
					if (BrowseFile(hDlg,1,iconame)) {
						lbwh = GetDlgItem(hDlg,IDC_ICONLB);
						if (FileExists(iconame)) {
							nicons = ExtractIcon(hInst,iconame,-1);
							if (nicons == NULL)
								MessageBox(hDlg,"No icons in this file.","Error",MB_OK);
							else {
								SetDlgItemText(hDlg,IDC_EDIT2,iconame);
								SendMessage(lbwh,LB_RESETCONTENT,0,0L);
								for (z = 0; z < nicons; z++)
									SendMessage(lbwh,LB_ADDSTRING,0,z);
								SendMessage(lbwh,LB_SETCURSEL,0,0);
							}
							SetFocus(GetDlgItem(hDlg,IDC_ICONLB));
						}
						else
							SetFocus(GetDlgItem(hDlg,IDC_EDIT2));
					}
					else
						SetFocus(GetDlgItem(hDlg,IDC_EDIT2));
					return TRUE;
				case IDC_EDIT1:
					switch (HIWORD(lParam)) {
						case EN_KILLFOCUS:
							GetDlgItemText(hDlg,IDC_EDIT1,exename,MAX_FILELEN);
							if (lstrcmp(exename,temp)) {
								icwh = GetDlgItem(hDlg,IDC_ICONEXE);
								if (FileExists(exename)) {
									hic = ExtractIcon(hInst,exename,0);
									if (hic == NULL)
										MessageBox(hDlg,"No icons in this EXE file.","Error",MB_OK);
									else {
										SendDlgItemMessage(hDlg,IDC_ICONEXE,STM_SETICON,(WPARAM) hic,0L);
										InvalidateRect(icwh,NULL,TRUE);
										UpdateWindow(icwh);
									}
								}
							}
							break;
						case EN_SETFOCUS:
							GetDlgItemText(hDlg,IDC_EDIT1,temp,MAX_FILELEN);
							break;
					}
					return TRUE;
				case IDC_EDIT2:
					switch (HIWORD(lParam)) {
						case EN_KILLFOCUS:
							GetDlgItemText(hDlg,IDC_EDIT2,iconame,MAX_FILELEN);
							if (lstrcmp(iconame,temp)) {
								lbwh = GetDlgItem(hDlg,IDC_ICONLB);
								if (FileExists(iconame)) {
									nicons = ExtractIcon(hInst,iconame,-1);
									if (nicons == NULL)
										MessageBox(hDlg,"No icons in this file.","Error",MB_OK);
									else {
										SendMessage(lbwh,LB_RESETCONTENT,0,0L);
										for (z = 0; z < nicons; z++)
											SendMessage(lbwh,LB_ADDSTRING,0,z);
										SendMessage(lbwh,LB_SETCURSEL,0,0);
									}
								}
								else
									SendMessage(lbwh,LB_RESETCONTENT,0,0L);
							}
							break;
						case EN_SETFOCUS:
							GetDlgItemText(hDlg,IDC_EDIT2,temp,MAX_FILELEN);
							break;
					}
					return TRUE;
				case IDOK:
					GetDlgItemText(hDlg,IDC_EDIT1,exename,MAX_FILELEN);
					GetDlgItemText(hDlg,IDC_EDIT2,iconame,MAX_FILELEN);
					if (FileExists(exename)) {
						if (FileExists(iconame)) {
							WritePrivateProfileString("WHACKDLG","DEST",exename,IniName);
							WritePrivateProfileString("WHACKDLG","SOURCE",iconame,IniName);
							WritePrivateProfileString(NULL,NULL,NULL,IniName);  // Flush INI file
							iconum = (int) SendDlgItemMessage(hDlg,IDC_ICONLB,LB_GETCURSEL,0,0L);
							if (iconum >= 0) {
								z = WhackExe(exename,iconame,iconum);
								if (z > 0) {
									LoadString(hInst,z,temp,60);
									MessageBox(hDlg,temp,"Msg",MB_OK);
								}
								else {
									wsprintf(temp,"Icon in %s has been Wacked.",(LPSTR) exename);
									MessageBox(hDlg,temp,"Successful Whack",MB_OK);
								}
								EndDialog(hDlg,0);
							}
						}
						else {
							MessageBox(hDlg,"You must specify an valid ICO/EXE/DLL file.","Error",MB_OK);
							SetFocus(GetDlgItem(hDlg,IDC_EDIT2));
						}
					}
					else {
						MessageBox(hDlg,"You must specify an existing .EXE file.","Error",MB_OK);
						SetFocus(GetDlgItem(hDlg,IDC_EDIT1));
					}
					return TRUE;
				case IDCANCEL:
					EndDialog(hDlg,0);
					return TRUE;
			}
			break;
	}
	return FALSE;
}

#pragma argsused
BOOL FAR PASCAL _export DlgProc2(HWND hDlg,WORD message,WPARAM wParam,LPARAM lParam)
{
	char wackname[MAX_FILELEN];

	switch (message) {
		case WM_INITDIALOG:
			CenterDialog(hDlg);
			SendDlgItemMessage(hDlg,IDC_WACKFILE,EM_LIMITTEXT,MAX_FILELEN,0L);
			GetPrivateProfileString("UNWHACKDLG","FILE","",wackname,MAX_FILELEN,IniName);
			SetDlgItemText(hDlg,IDC_WACKFILE,wackname);
			return TRUE;
		case WM_COMMAND:
			switch (wParam) {
				case IDC_HELP:
					WinHelp(hDlg,HelpFileName,HELP_CONTEXT,HLP_DLG2);
					return TRUE;
				case IDC_DLG2_BROWSE:
					if (BrowseFile(hDlg,2,wackname))
						SetDlgItemText(hDlg,IDC_WACKFILE,wackname);
					SetFocus(GetDlgItem(hDlg,IDC_WACKFILE));
					return TRUE;
				case IDOK:
					GetDlgItemText(hDlg,IDC_WACKFILE,wackname,MAX_FILELEN);
					if (FileExists(wackname)) {
						WritePrivateProfileString("UNWHACKDLG","FILE",wackname,IniName);
						WritePrivateProfileString(NULL,NULL,NULL,IniName);  // Flush INI file
						if (UnWhackExe(wackname))
							MessageBox(hDlg,"Cannot restore Icon in EXE","Error",MB_OK);
						else
							MessageBox(hDlg,"Original Icon restored.","Successful UnWhack",MB_OK);
						EndDialog(hDlg,0);
					}
					else {
						MessageBox(hDlg,"You must specify a valid .WCK file.","Error",MB_OK);
						SetFocus(GetDlgItem(hDlg,IDC_WACKFILE));
					}
					return TRUE;
				case IDCANCEL:
					EndDialog(hDlg,0);
					return TRUE;
			}
			break;
	}
	return FALSE;
}

#pragma argsused
BOOL FAR PASCAL _export DlgProcAbout(HWND hDlg,WORD message,WPARAM wParam,LPARAM lParam)
{
	switch (message) {
		case WM_INITDIALOG:
			CenterDialog(hDlg);
			return TRUE;
		case WM_COMMAND:
			switch (wParam) {
				case IDC_HELP:
					SetFocus(GetDlgItem(hDlg,IDOK));
					WinHelp(hDlg,HelpFileName,HELP_CONTEXT,HLP_DONATIONS);
					return TRUE;
				case IDOK:
				case IDCANCEL:
					EndDialog(hDlg,0);
					return TRUE;
			}
			break;
	}
	return FALSE;
}

void CenterDialog(HWND hwnd)
{
	WORD ww, wh;
	RECT rect, desktop;

	GetWindowRect(GetDesktopWindow(),&desktop);
	GetWindowRect(hwnd,&rect);
	ww = rect.right - rect.left;
	wh = rect.bottom - rect.top;
	MoveWindow(hwnd,(desktop.right-ww)/2,(desktop.bottom-wh)/2,ww,wh,TRUE);
	return;
}

int FileExists(const char *fname)
{
//
// Checks to see if a file exists
// Returns TRUE if it is found
//
	struct ffblk dirinfo;

	if (findfirst(fname,&dirinfo,0))
		return FALSE;
	return TRUE;
}

WORD SeekIcon(HFILE exefile,PIWICON piwicon,WORD iconum,BYTE cc,BYTE bw,BYTE bh)
{
//
// Seeks to a given Icon within an EXE or DLL
// Upon successful completion, the IWICON structure
// will be filled in with all relevant information.
//
	WORD sig, head, rshift, z, offset, icmatch, TrueIconCount, tempcount;
	LONG coffset, newpos, savepos;
	TYPEINFO rti;
	NAMEINFO nameinfo;
	ICONDIR icondir;
	ICONDIRENTRY icondirentry;

	memset(piwicon,0,sizeof(IWICON));

	if (_llseek(exefile,0L,0) == -1)
		return 3;
	if (_lread(exefile,&sig,sizeof(WORD)) != sizeof(WORD))
		return 3;
// Check DOS EXE signature
	if (sig != 0x5A4D)
		return 4;
	if (_llseek(exefile,0x18,0) == -1)
		return 3;
	if (_lread(exefile,&head,sizeof(WORD)) != sizeof(WORD))
		return 3;
	if (head < 0x40)
		return 4;		// Not an EXE that we can use
	if (_llseek(exefile,0x3CL,0) == -1)
		return 3;
	if (_lread(exefile,&head,sizeof(WORD)) != sizeof(WORD))
		return 3;
	if (_llseek(exefile,(LONG) head,0) == -1)
		return 3;
	if (_lread(exefile,&sig,sizeof(WORD)) != sizeof(WORD))
		return 3;
// Check Win EXE signature
	if (sig != 0x454E)
		return 6;
	if (_llseek(exefile,(LONG) head + 0x24L,0) == -1)
		return 3;
	if (_lread(exefile,&offset,sizeof(WORD)) != sizeof(WORD))
		return 3;
// Move to start of Resource Table
	if (_llseek(exefile,(LONG) offset + (LONG) head,0) == -1)
		return 3;
	if (_lread(exefile,&z,sizeof(WORD)) != sizeof(WORD))
		return 3;
	rshift = 1;
	if (z) {
		while (z-- > 0)
			rshift *= 2;
	}
// Read each TYPEINFO structure in Resource Table
// looking for 0x0E (RT_GROUP_ICON) first and then 0x03 (RT_ICON)
	icmatch = 0;
	do {
		if (_lread(exefile,&rti,sizeof(TYPEINFO)) != sizeof(TYPEINFO))
			return 3;
		if ((rti.rtTypeID == 0) || (rti.rtReserved))
			break;
		coffset = _llseek(exefile,0L,1);	// Save offset
		if ((rti.rtTypeID & 0x7FFF) == 14) {
			if (rti.rtResourceCount <= iconum)
				return 5;
			TrueIconCount = 0;
			for (z = 0; z <= iconum; z++) {
				if (_lread(exefile,&nameinfo,sizeof(NAMEINFO)) != sizeof(NAMEINFO))
					return 3;
				savepos = _llseek(exefile,0L,1);	// Save current offset
				newpos = (DWORD) rshift * (DWORD) nameinfo.rnOffset + 4L;
				if (_llseek(exefile,newpos,0) == -1)
					return 3;
				if (_lread(exefile,&tempcount,sizeof(WORD)) != sizeof(WORD))
					return 3;
				if (z < iconum)
					TrueIconCount += tempcount;
				if (_llseek(exefile,savepos,0) == -1)
					return 3;
			}
			piwicon->starticodir = newpos - 4L;
			if (_llseek(exefile,piwicon->starticodir,0) == -1)
				return 3;
			if (_lread(exefile,&icondir,sizeof(ICONDIR)) != sizeof(ICONDIR))
				return 3;
			for (z = 1; z <= icondir.idCount; z++) {
				if (_lread(exefile,&icondirentry,sizeof(ICONDIRENTRY)) != sizeof(ICONDIRENTRY))
					return 3;
				if ((icondirentry.bWidth == bw) && (icondirentry.bHeight == bh) && (icondirentry.bColorCount == cc)) {
					icmatch = z;
					break;
				}
			}
			if (icondirentry.dwBytesinRes >= MAX_ICONSIZE)
				return 10;
			piwicon->bWidth = icondirentry.bWidth;
			piwicon->bHeight = icondirentry.bHeight;
			piwicon->bColorCount = icondirentry.bColorCount;
			piwicon->dwBytesinRes = icondirentry.dwBytesinRes;
			break;
		}
		if (_llseek(exefile,coffset + (LONG) rti.rtResourceCount * (LONG) sizeof(NAMEINFO),0) == -1)
			return 3;
	} while (piwicon->starticodir == 0L);
	if (piwicon->starticodir == 0L)
		return 7;		// Cannot find Icons
//
// Look back thru Resource Table for the RT_ICON (0x03) Resource ID
//
	if (_llseek(exefile,(LONG) offset + (LONG) head + (LONG) sizeof(WORD),0) == -1)
		return 3;
	do {
		if (_lread(exefile,&rti,sizeof(TYPEINFO)) != sizeof(TYPEINFO))
			return 3;
		if ((rti.rtTypeID == 0) || (rti.rtReserved))
			break;
		coffset = _llseek(exefile,0L,1);	// Save offset
		if ((rti.rtTypeID & 0x7FFF) == 3) {
			if (rti.rtResourceCount <= TrueIconCount)
				return 5;
			if (_llseek(exefile,(LONG) TrueIconCount * (LONG) sizeof(NAMEINFO),1) == -1)
				return 3;
			if (_lread(exefile,&nameinfo,sizeof(NAMEINFO)) != sizeof(NAMEINFO))
				return 3;
			if ((icmatch > 1) && (rti.rtResourceCount > 1)) {
				if (icmatch > rti.rtResourceCount)
					return 11;
				for (z = 2; z <= icmatch; z++) {
					if (_lread(exefile,&nameinfo,sizeof(NAMEINFO)) != sizeof(NAMEINFO))
						return 3;
				}
			}
			piwicon->startico = (DWORD) rshift * (DWORD) nameinfo.rnOffset;
			break;
		}
		if (_llseek(exefile,coffset + (LONG) rti.rtResourceCount * (LONG) sizeof(NAMEINFO),0) == -1)
			return 3;
	} while (piwicon->startico == 0L);
	if (piwicon->startico == 0L)
		return 7;		// Cannot find Icons
	return 0;
}

WORD WhackExe(const char *exename,const char *iconame,WORD iconum)
{
	HFILE exefile, icofile, backupfile;
	char backupname[MAX_FILELEN];
	char tempname[MAX_FILELEN];
	char iconbuf[MAX_ICONSIZE];
	char savebuf[MAX_ICONSIZE];
	BYTE iw, ih, ic;
	WORD sig, err, z;
	DWORD wacksig;
	ICONDIR diskicondir;
	DISKICON diskicon;
	IWICON iwicon, tempiwicon;
	HDC hdc;

	if (SoundFlag)
//   		if (FileExists("WHACK.WAV"))
			sndPlaySound("WHACK.WAV",SND_ASYNC | SND_NODEFAULT);
	z = lstrlen(exename);
	if (z < 3)
		return 4;
	if (*(exename+z-1) != 'E')
		return 4;
	if (*(exename+z-2) != 'X')
		return 4;
	if (*(exename+z-3) != 'E')
		return 4;
	icofile = _lopen(iconame, READ);
	if (icofile == -1)
		return 1;		// Cannot open ICO file
	sig = 0;
	if (_lread(icofile,&sig,sizeof(WORD)) != sizeof(WORD))
		sig = 0;
	iw = (BYTE) GetSystemMetrics(SM_CXICON);
	ih = (BYTE) GetSystemMetrics(SM_CYICON);
	ic = 2;	// Minimum Icon colors
	hdc = GetDC(NULL);
	if (GetDeviceCaps(hdc,SIZEPALETTE) > 16)
		ic = 16;	// Max icon colors
	ReleaseDC(NULL, hdc);
	if (sig == 0x5A4D) { 	// An EXE or DLL, so extract ICON data
		err = SeekIcon(icofile,&tempiwicon,iconum,ic,iw,ih);
		if (err) {
			_lclose(icofile);
			return err;
		}
		if (_llseek(icofile,tempiwicon.startico,0) == -1) {
			_lclose(icofile);
			return 3;
		}
		if (_lread(icofile,&iconbuf[0],(WORD) tempiwicon.dwBytesinRes) != (WORD) tempiwicon.dwBytesinRes) {
			_lclose(icofile);
			return 3;
		}
		diskicondir.idReserved = 0;
		diskicondir.idType = 1;
		diskicondir.idCount = 1;
		memset(&diskicon,0,sizeof(DISKICON));
		diskicon.bWidth = tempiwicon.bWidth;
		diskicon.bHeight = tempiwicon.bHeight;
		diskicon.bColorCount = tempiwicon.bColorCount;
		diskicon.dwBytesinRes = tempiwicon.dwBytesinRes;
		diskicon.dwImageOffset = sizeof(DISKICON) + sizeof(ICONDIR);
	}
	else {
		_llseek(icofile,0L,0);
		if (_lread(icofile,&diskicondir,sizeof(ICONDIR)) != sizeof(ICONDIR)) {
			_lclose(icofile);
			return 3;
		}
		for (z = 1; z <= diskicondir.idCount; z++) {
			if (_lread(icofile,&diskicon,sizeof(DISKICON)) != sizeof(DISKICON)) {
				_lclose(icofile);
				return 3;
			}
			if ((diskicon.bColorCount == ic) && (diskicon.bWidth == iw) && (diskicon.bHeight == ih))
				break;
		}
		if (_llseek(icofile,diskicon.dwImageOffset,0) == -1) {
			_lclose(icofile);
			return 3;
		}
		if (_lread(icofile,&iconbuf[0],(WORD) diskicon.dwBytesinRes) != (WORD) diskicon.dwBytesinRes) {
			_lclose(icofile);
			return 3;
		}
	}
	_lclose(icofile);
// All Icon data is ready, so now write to EXE
	exefile = _lopen(exename, READ_WRITE);
	if (exefile == -1)
		return 2;
	err = SeekIcon(exefile,&iwicon,0,diskicon.bColorCount,diskicon.bWidth,diskicon.bHeight);
	if (err) {
		_lclose(exefile);
		return err;
	}
// Check Icon compatibility (size, colors, height, width)
	err = 0;
	if ((diskicon.bWidth != iwicon.bWidth) || (diskicon.bHeight != iwicon.bHeight))
		err = 13;
	if (diskicon.bColorCount != iwicon.bColorCount)
		err = 12;
	if (diskicon.dwBytesinRes != iwicon.dwBytesinRes)
		err = 11;
	if (err == 0) {
		if (_llseek(exefile,iwicon.startico,0) != -1) {
			// Save old data
			if (_lread(exefile,&savebuf[0],(WORD) diskicon.dwBytesinRes) == (WORD) diskicon.dwBytesinRes) {
				if (_llseek(exefile,iwicon.startico,0) != -1) {
					if (_lwrite(exefile,&iconbuf[0],(WORD) diskicon.dwBytesinRes) != (WORD) diskicon.dwBytesinRes)
						err = 3;
				}
				else
					err = 3;
			}
			else
				err = 3;
		}
		else
			err = 3;
	}
	_lclose(exefile);
	if (err)
		return err;
// Make backup file so that Icon change can be reversed
	lstrcpy(backupname,exename);
	memset(tempname,0,MAX_FILELEN);
	lstrcpy(tempname,exename);
	z = lstrlen(backupname);
	backupname[z-1] = 'K';
	backupname[z-2] = 'C';
	backupname[z-3] = 'W';
	if (FileExists(backupname) == FALSE) {
		backupfile = _lcreat(backupname, 0);
		if (backupfile != -1) {
			wacksig = WACK_SIG;
			if (_lwrite(backupfile,&wacksig,sizeof(DWORD)) == sizeof(DWORD)) {
				if (_lwrite(backupfile,&tempname[0],MAX_FILELEN) == MAX_FILELEN) {
					if (_lwrite(backupfile,&diskicon.dwBytesinRes,sizeof(DWORD)) == sizeof(DWORD)) {
						if (_lwrite(backupfile,&iwicon.startico,sizeof(DWORD)) == sizeof(DWORD))
							_lwrite(exefile,&savebuf[0],(WORD) diskicon.dwBytesinRes);
					}
				}
			}
			_lclose(backupfile);
		}
	}
	return 0;
}

WORD UnWhackExe(const char *wackname)
{
	HFILE wackfile, exefile;
	DWORD wacksig, icosize, icostart;
	char exename[MAX_FILELEN];
	char iconbuf[MAX_ICONSIZE];

	if (SoundFlag)
		sndPlaySound("UNWHACK.WAV",SND_ASYNC | SND_NODEFAULT);
	wackfile = _lopen(wackname,READ);
	if (wackfile == -1)
		return 2;
	if (_lread(wackfile,&wacksig,sizeof(DWORD)) != sizeof(DWORD)) {
		_lclose(wackfile);
		return 3;
	}
	if (wacksig != WACK_SIG) {
		_lclose(wackfile);
		return 4;
	}
	if (_lread(wackfile,exename,MAX_FILELEN) != MAX_FILELEN) {
		_lclose(wackfile);
		return 3;
	}
	if (_lread(wackfile,&icosize,sizeof(DWORD)) != sizeof(DWORD)) {
		_lclose(wackfile);
		return 3;
	}
	if (_lread(wackfile,&icostart,sizeof(DWORD)) != sizeof(DWORD)) {
		_lclose(wackfile);
		return 3;
	}

	if (_lread(wackfile,&iconbuf[0],(WORD) icosize) != (WORD) icosize) {
		_lclose(wackfile);
		return 3;
	}
	_lclose(wackfile);

	if (FileExists(exename) == FALSE)
		return 2;

	exefile = _lopen(exename, READ_WRITE);
	if (exefile == -1)
		return 2;

	if (_llseek(exefile,icostart,0) == -1) {
		_lclose(exefile);
		return 3;
	}
	if (_lwrite(exefile,&iconbuf[0],(WORD) icosize) != (WORD) icosize) {
		_lclose(exefile);
		return 3;
	}
	_lclose(exefile);
	return 0;
}

BOOL BrowseFile(HWND hwOwner,WORD btype,char *fnbuf)
{
	BOOL retval;
	WORD z;
	char szFile[128];
	char szFileTitle[128];
	char szFilter[140];
	OPENFILENAME ofn;

	switch (btype) {
		case 0:
			lstrcpy(szFilter,"Program Files (*.exe)|*.exe||");
			break;
		case 1:
			lstrcpy(szFilter,"All Files (exe,dll,ico)|*.exe;*.dll;*.ico|Program Files (*.exe)|*.exe|DLL Files (*.dll)|*.dll|Icon Files (*.ico)|*.ico||");
			break;
		case 2:
			lstrcpy(szFilter,"Whack Files (*.wck)|*.wck||");
			break;
		default:
			return FALSE;
	}
// Change all delimiters in Filter to nulls
	for (z = 0; szFilter[z] != '\0'; z++) {
		 if (szFilter[z] == '|')
			 szFilter[z] = '\0';
	}

	memset(&ofn, 0, sizeof(OPENFILENAME));  // Init & clear Structure

	szFile[0] = '\0';
	ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = hwOwner;
	ofn.lpstrFilter = szFilter;
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = sizeof(szFile);
	ofn.lpstrFileTitle = szFileTitle;
	ofn.nMaxFileTitle = sizeof(szFileTitle);
	switch (btype) {
		case 0:
			ofn.lpstrTitle = "Browse Executables";
			ofn.lpstrDefExt = "EXE";
			break;
		case 1:
			ofn.lpstrTitle = "Browse Icons";
			break;
		case 2:
			ofn.lpstrTitle = "Browse Whacked Files";
			ofn.lpstrDefExt = "WCK";
			break;
	}
	ofn.Flags = OFN_HIDEREADONLY | OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
	retval = GetOpenFileName(&ofn);
	if (retval)
		lstrcpy(fnbuf,szFile);
	return retval;
}

void DrawBitmap(HDC hdc,HBITMAP hBitmap,WORD xstart,WORD ystart)
{
	BITMAP tempbm;
	HBITMAP hOldBmp;
	HDC hdcmem;
	POINT ptsize, ptorg;

	if (hBitmap == NULL)
		return;
	hdcmem = CreateCompatibleDC(hdc);
	hOldBmp = SelectObject(hdcmem,hBitmap);
	SetMapMode(hdcmem,GetMapMode(hdc));
	GetObject(hBitmap,sizeof(BITMAP),(LPSTR) &tempbm);
	ptsize.x = tempbm.bmWidth;
	ptsize.y = tempbm.bmHeight;
	DPtoLP(hdc,&ptsize,1);
	ptorg.x = 0;
	ptorg.y = 0;
	DPtoLP(hdcmem,&ptorg,1);
	BitBlt(hdc,xstart,ystart,ptsize.x,ptsize.y,hdcmem,ptorg.x,ptorg.y,SRCCOPY);
	SelectObject(hdcmem,hOldBmp);
	DeleteDC(hdcmem);
	return;
}
