{ X10 Computer Interface Communications in Turbo Pascal
  Copyright 1988 by F.C. Wilczynski }

type
          all  =  string[80];
   HouseCodes  =  array[1..16] of char;
    ConvHouse  =  array[1..16] of integer;

const
    HouseCode:HouseCodes = ('A','B','C','D','E','F','G','H',
                            'I','J','K','L','M','N','O','P');
    HouseValue:ConvHouse = ($60,$E0,$20,$A0,$10,$90,$50,$D0,
                            $70,$F0,$30,$B0,$00,$80,$40,$C0);

    aoff = $00;    { all units off }
    alon = $01;    { all lights on }
      on = $02;    { on }
     off = $03;    { off }
    loff = $04;    { dim light to off }
     dim = $05;    { dim light to designated level }
     osw = $06;    { turn off wall switch lights and designated on }
      sw = $07;    { turn off wall switch lights }
var
                            stat,
                         checksum : byte;
                              inc : char;
                   linein,lineout : all;
                           buffer : array[1..2048] of char;
  a,t,u,av,bv,ck,portval,portadd,
                c1,c2,c3,c4,c5,c6 : integer;
                           recchr : boolean;

procedure SetBaud;
begin
  portadd := $3f8;
    case portval of
        2 : portadd := $2f8;
        3 : portadd := $3e8;
        4 : portadd := $2e8;
    end;
  port[portAdd+3]:=$80;  port[portAdd+1]:=0;   { set baud rate to 600      }
  port[portAdd]:=$c0;  port[PortAdd+3]:=$03;   { No parity, 8 bits, 1 stop }
end;

procedure OutPort(character:char);
begin
  while (port[PortAdd+5] and $40)=0 do begin end;
  port[PortAdd]:=ord(character);
  delay(2);
end;

procedure InPort;
begin
  inc:=chr(port[PortAdd]);
  recchr:=true;
end;

procedure StatusPort;
begin
  recchr:=false;
  stat:=port[PortAdd+5];
  if ((stat and $1) = $1) then inport;
end;

procedure Receive;
begin
  for t:=1 to 2048 do buffer[t]:=chr(0);
  t:=1; u:=0;
  while (u < 3200) do
    begin
      statusport;
      if recchr then
        begin
          buffer[t]:=inc; t:=succ(t); u:=0;
        end;
      u:=succ(u);
    end;
end;

procedure send(anystr:all;bytes:integer);
var    a : integer;
    part : string[18];
begin
  receive; part:='';
  for a:=1 to 16 do part:=part+chr($ff);
  if bytes>0 then
    begin
      checksum:=0; anystr:=part+anystr;
      for a:=length(anystr)-bytes to length(anystr) do
        checksum:=(checksum+ord(anystr[a])) and $ff;
      anystr:=anystr+chr(checksum);
    end;
  for A:=1 to length(anystr) do
    outport(anystr[a]);
  receive;
end;

Begin
  portval:=1; setbaud;
  lineout:=chr(1)+chr($f)+chr(0)+chr(0)+chr(0);

  { UNIT/HOUSECODE VALUE }
  linein:='A16';

  if (linein[1] < 'A') or (linein[1] > 'P') then
    begin
      writeln('Invalid house code'); exit;
    end;
  lineout[3]:=chr(housevalue[ord(linein[1])-64]);
  if length(linein)>1 then
    begin
      linein:=copy(linein,2,length(linein));
      val(linein,av,ck);
      if (av>16) or (av<1) then
        begin
          writeln('Invalid unit value'); exit;
        end;
      bv:=$80;
      if av>=9 then  lineout[4]:=chr((bv shr (av-9)))
        else
      lineout[5]:=chr(bv shr (av-1));
    end;

  { OPERATION ON UNIT/HOUSECODE }
  linein:='OFF';

  if linein = 'LIGHTOFF' then  lineout[2]:=chr(loff);
  if linein = 'OFF' then       lineout[2]:=chr(off);
  if linein = 'ON' then        lineout[2]:=chr(on);
  if linein = 'ALLOFF' then    lineout[2]:=chr(aoff);
  if linein = 'ALLON' then     lineout[2]:=chr(alon);
  if linein = 'SWITCH' then    lineout[2]:=chr(sw);
  if linein = 'ON/SWITCH' then lineout[2]:=chr(osw);

  if lineout[2]=chr(15) then  { NONE OF THE ABOVE IT'S A DIM VALUE; MAYBE }
    begin
      a:=0; val(linein,a,ck);
      if (a>16) or (a<1) then
        begin
          writeln('Dim value out of range'); exit;
        end
        else lineout[2]:=chr(dim+((16-a)*16));
    end;
  if lineout[2]<>chr(15) then send(lineout,5);
  receive;
end.
