/*===========================================================================
SOLARGO :: Module config.c
Original Author: Kevin Sartorelli <kevin@nui-wgtn.gen.nz>
Much code stolen from source for Solar by Kevi Houle

This software module has been placed in the public domain.
===========================================================================*/

/* Header Files */
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <stdlib.h>
#include "config.h"

/*
 * Function: load_config()
 * Purpose : Load SolarGo's configuration file.
 * Return  : 0 on success, non-zero on error and set _slrerr.
*/

int load_config(char *config_path)
{
	FILE *config_file = NULL;
	char buf[128];
	char delimiter = '=';
	char *path = NULL;

	/* Get path to config file if not already set */

	if (strcmp(config_path,"NONE") == 0)
	{
      if ((path = getenv("SOLARGO")) == NULL)
      {
         strcpy(_slrerr,"load_config(): environment variable SOLARGO not set.");
         goto ErrorExit;
      }
      strcpy(config_path,path);
	}

   if (verbose == YES)
      RPrintf("SolarGo config file: %s\n",config_path);

	if ((config_file = fopen(config_path,"rt")) == NULL)
	{
		sprintf(_slrerr,"load_config(): could not open %s for reading.",config_path);
		goto ErrorExit;
	}

	while (fgets(buf,128,config_file) != NULL)
	{

      /* Set path to write BATch file out */

		if (strnicmp(buf,"BATCHPATH",9) == 0)
		{
			strcpy(batch_path,extract_parm(buf,delimiter));
         if (verbose == YES)
	         RPrintf("BATch path set to: %s\n",batch_path);
		}

      /* Set path to BBS drop file */

      if (strnicmp(buf,"DROPPATH",8) == 0)
      {
         strcpy(drop_path,extract_parm(buf,delimiter));
         if (verbose == YES)
	         RPrintf("BBS drop file path set to: %s\n",drop_path);
      }

      /* Set path to userlist file */

      if (strnicmp(buf,"NAMEPATH",8) == 0)
      {
         strcpy(name_path,extract_parm(buf,delimiter));
         if (verbose == YES)
            RPrintf("Name list path set to: %s\n",name_path);
      }

      /* Set initial newsgroup */

      if (strnicmp(buf,"NEWSGROUP",9) == 0)
      {
         strcpy(newsgroup,extract_parm(buf,delimiter));
         if (verbose == YES)
            RPrintf("Initial newsgroup set to: %s\n",newsgroup);
      }
   }
	fclose(config_file);

	if (verbose == YES)
    RPrintf("Solar config file load OK\n\n");

GoodExit:
	return 0;
ErrorExit:
	if (config_file) fclose(config_file);
	return 1;
}

/*
 * Function: int load_static(char username[10])
 * Purpose : Load parameters from Waffle's static file.
 * Return  : 0 on success, non-zero on error and set _slrerr
*/

int load_static(void)
{
	FILE *static_file = NULL;

   char static_path[MAXPATH];
	char buffer[128];
	char delimiter = ':';
	char *path = NULL;

	/* Get path to static file and open it */

	if ((path = getenv("WAFFLE")) == NULL)
	{
		strcpy(_slrerr,"load_static(): environment variable WAFFLE not set.");
		goto ErrorExit;
	}
	strcpy(static_path,path);
   if (verbose == YES)
      RPrintf("Waffle static file: %s\n",static_path);

	if ((static_file = fopen(static_path,"rt")) == NULL)
	{
		sprintf(_slrerr,"load_static(): error opening %s for reading.",static_path);
		goto ErrorExit;
	}

	/* Read static file and pull out what we need. */

	while (fgets(buffer,128,static_file) != NULL)
	{
		/* Build path to user's directory */

		if (strnicmp(buffer,"USER",4) == 0)
		{
			strcpy(user_path,extract_parm(buffer,delimiter));
			strcat(user_path, "\\");
      if (verbose == YES)
        RPrintf("User Path: %s\n",user_path);
		}

		/* Get path to temporary directory. This only gets used if
			 'solarwork' is not set in Solar's configuration file. */

		if (strnicmp(buffer,"TEMPORARY",9) == 0)
		{
			if (strcmp(temp_path,"NONE") == 0)
			{
				strcpy(temp_path,extract_parm(buffer,delimiter));
            if (verbose == YES)
            RPrintf("Temp path: %s\n",temp_path);
			}
		}

		/* Check the driver, use fossil only if selected on command line
			 and in static file 'driver' parameter. */

		if (strnicmp(buffer,"DRIVER",6) == 0)
		{
			if (use_fossil == YES)
			{
				if (strnicmp(extract_parm(buffer,delimiter),"FOSSIL",6) == 0)
				{
					use_fossil = YES;
          if (verbose == YES)
            RPrintf("Fossil support enabled.\n");
				}
				else
				{
					use_fossil = NO;
          if (verbose == YES)
            RPrintf("Fossil support disabled.\n");
				}
			}
			else
			{
        if (verbose == YES)
          RPrintf("Fossil support disabled.\n");
			}
		}

		/* Load comm device, in case we are using a fossil driver. */

		if (strnicmp(buffer,"DEVICE",6) == 0)
		{
			port = atoi(extract_parm(buffer,delimiter)) - 1;
      if (verbose == YES)
        RPrintf("COM Port: %u\n",port);
		}
	}
	fclose(static_file);

	if (verbose == YES)
    RPrintf("Finished reading static, validating...\n");

	/* Check to make sure we got all that we need. */

	if (strcmp(temp_path,"NONE") == 0)
	{
		strcpy(_slrerr,"load_static(): temporary: parameter not found in static file");
		goto ErrorExit;
	}
	if (strcmp(user_path,"NONE") == 0)
	{
		strcpy(_slrerr,"load_static(): user: parameter not found in static file.");
		goto ErrorExit;
	}
   if ((use_fossil == YES) && (port == 99))
	{
		strcpy(_slrerr,"load_static(): device: parameter not found in static file.");
		goto ErrorExit;
	}

	if (verbose == YES)
      RPrintf("Static file load OK\n\n");

GoodExit:
	return 0;
ErrorExit:
	if (static_file) fclose(static_file);
	return 1;
}
