#include "..\common\yesno.h"
#include "..\common\version.h"

/* Local Definitions */
#define NEWSRC			"NEWSRC.SLR"
#define NEWSRC_TMP	"NEWSRC.TMP"

enum SOUP_Types { u, M, m, n, C, c, i, b, B };	   /* Possible types */
enum Exit_Codes { x_success, x_usage, x_fatal };	 /* Exit codes */

/* Global Data */

extern char temp_path[MAXPATH]; 			 /* From config.c */
extern char user_path[MAXPATH]; 			 /* From config.c */
extern char menu_path[MAXPATH];        /* From config.c */
extern char config_path[MAXPATH];      /* From config.c */
extern char log_path[MAXPATH];				 /* From config.c */
extern char solar_path[MAXPATH];			 /* From config.c */
extern char static_path[MAXPATH]; 		 /* From config.c */
extern char waffle_path[MAXPATH]; 		 /* From config.c */
extern char system_path[MAXPATH]; 		 /* From config.c */
extern char extern_path[MAXPATH]; 		 /* From config.c */
extern char extern_root[MAXPATH];      /* From config.c */
extern char help_path[MAXPATH];        /* From config.c */
extern char swap_path[MAXPATH];        /* From config.c */
extern char uucpname[10];              /* From config.c */

extern int  diskswap;                /* From config.c */
extern int  use_fossil;                /* From config.c */
extern int	port; 										 /* From config.c */
extern int	verbose;									 /* From config.c */
extern char _slrerr[80];							 /* From config.c */
extern char logbuf[128];               /* From logit.c  */

/* News control parameters */
extern int	news_type;								 /* From config.c */
extern int	news_index; 							 /* From config.c */
extern long news_area_bytes;					 /* From config.c */
extern long news_area_messages; 			 /* From config.c */
extern long news_total_bytes; 				 /* From config.c */
extern long news_total_messages;			 /* From config.c */

/* Mail control parameters */
extern int	mail_index; 							 /* From config.c */
extern int	mail_type;								 /* From config.c */
extern int	send_mail;								 /* From config.c */
extern int	delete_mail;							 /* From config.c */

/* Other optional parameters */
extern int	send_list;								 /* From config.c */
extern int	use_wafjoin;							 /* From config.c */
extern char default_keyword;					 /* From config.c */
extern char protocol[10]; 						 /* From config.c */
extern char compress[10]; 						 /* From config.c */
extern long disk_minimum;              /* From config.c */

extern int	time_left;								 /* From config.c */
extern int  stupid_user;               /* From config.c */
extern char speed[6]; 								 /* From config.c */

/* External Functions */
extern int	load_static(char username[10]); 			/* From config.c	*/
extern int	load_config();												/* From config.c	*/
extern int	user_defaults();											/* From config.c	*/
extern int	extern_halt();												/* From extern.c	*/
extern int  extern_clear();                       /* From extern.c  */
extern int  extern_solar();                       /* From extern.c  */
extern int  extern_slrxfer(char *username,const char *argument);
extern int  call_solar(char *username, const char *program, const char *specarg);

/* Common Functions */
extern int	getopt(int argc, char *argv[], const char *optionS);
extern int	set_directory(char *path);
extern int	read_doors(); 												/* From doors.c 	*/
extern int	logit(char *facility);								/* From logit.c 	*/
extern int	kill_newsrc(const char *newsrc_type); /* From newsrc.c	*/
extern int  update_newsrc();                      /* From newsrc.c  */
extern int  timechk(int min_left);                /* From timechk.c */
extern int  diskfree(char *chkpath);              /* From diskfree.c */
extern void cleanup();                            /* From cleanup.c */

/* Local functions */
void usage();

extern int	user_options();
extern long compress_packet();

int  copyfile(char *path1, char *path2);
