#include <string.h>

extern char protocol[10];
extern char _slrerr[80];

/*
 * Function: get_protocol_type()
 * Purpose : Extract protocol type from string and store in global
 *           variable protocol.
 * Return  : 0 on success, non-zero on error and set _slrerr.
*/

int get_protocol_type(char buf[128])
{
  char *p = NULL;

  if ((p = strtok(buf,"-")) == NULL)
  {
    strcpy(_slrerr,"get_protocol_type(): error in receive: parameter.");
    goto ErrorExit;
  }
  if ((p = strtok(NULL,"=")) == NULL)
  {
    strcpy(_slrerr,"get_protocol_type(): error in receive: parameter.");
    goto ErrorExit;
  }
  strcpy(protocol,p);

GoodExit:
  return 0;
ErrorExit:
  return 1;
}
