/*===========================================================================
SOLAR :: ..\common\fossil.h

Contributed by Kevin Sartorelli
This software module has been placed into the public domain.
===========================================================================*/

/* Interrupt to call FOSSIL on */

#define FOSSIL      0x14

/* Fossil status definitions */

#define DATA_AVAILABLE  0x0100
#define ROOM_AVAILABLE  0x1000
#define ALL_AVAILABLE   0x2000
#define CARRIER_DETECT  0x0080

/* Predeclarations */

int   Fossil_Init( int port );
void  Fossil_Deinit( int port );
void  Fossil_Baud( int port, int baud_rate);
void  Fossil_Set_DTR( int port, int new_state);
int   Fossil_Status( int port );
int   Fossil_Putc( int port, int ch );
int   Fossil_Puts( int port, char *s );
int   Fossil_Aputc( int port, int ch );
int   Fossil_Getc( int port );
char *Fossil_Gets( char *s, int n, int port );
void  Fossil_Purge( int port );
void  Fossil_WatchCD( int port, int status );
