/*===========================================================================
SOLAR :: ..\common\copyfile.c

Original Author: Kevin Houle <kjhoule@iowegia.des-moines.ia.us>
This software module has been placed into the public domain.
===========================================================================*/

#include <stdio.h>
#include <string.h>

extern char _slrerr[80];

/*
 * Function: int copyfile(char *path1, char *path2)
 * Purpose : Moves file path1 to path2.
 * Return  : zero on success, non-zero on error and set _slrerr.
*/

int copyfile(char *path1, char *path2)
{
	FILE *file1 = NULL;
	FILE *file2 = NULL;
	char copybuf;

	if ((file1 = fopen(path1,"rb")) == NULL)
	{
    sprintf(_slrerr,"copyfile(): file %s not found",path1);
		goto ErrorExit;
  }
  if ((file2 = fopen(path2,"wb")) == NULL)
  {
    sprintf(_slrerr,"copyfile(): error opening %s for write",path2);
		goto ErrorExit;
  }

  copybuf = fgetc(file1);
  while (!feof(file1))
	{
    fprintf(file2,"%c",copybuf);
    copybuf = fgetc(file1);
  }
  fclose(file1);
  fclose(file2);

GoodExit:
  return 0;
ErrorExit:
  if (file1) fclose(file1);
  if (file2) fclose(file2);
  return 1;
}
