/*
**	C H K F I L E S  --  a utility for Waffle BBS 1.65 (MS-DOS)
**
**	Scans a Waffle dirs file and the associated @files files, checking
**	for problems.  Report nonexistant files, duplicate descriptions,
**	files without descriptions and scrambled/illegal file names.
**
** Change log:
** Release 1.0 (first version written)
**	Was sent to a few selected sysops running 1.65betas
** Release 1.1
**	Was the first public release (local BBS only); the only change was
**	that also the number sign "#" is recognized as a comment character
** Release 1.2
**	Changed to compile with MicroS*t C 7.00, moved enhanced dirs routines
**	to separate file; first public release to the usenet community
*/

#include	<ctype.h>
#include	<stdio.h>
#include	<stdarg.h>
#include	<string.h>
#include	"formatch.h"
#include	"dirs.h"

/* Default dirs file name */
#define	DIRFILE	"/waffle/system/dirs"
/* Maximum number of file names per @files file */
#define	MAXFILES	500
/* Default values for these three scan modes */
unsigned int scandeny=0,scanrom=0,scanhide=0,skipfile=0;

char thisfile[65],*dirfile=NULL;

unsigned int foundfiles=0,founddirs=0,errors=0;

#ifdef	PARSE
/* Collection arrays for dirs file tokens and @files filenames */
int tokens;
char *token[MAXTOKENS],*value[MAXTOKENS];
#endif

int filenames;
unsigned int linenumber[MAXFILES];
char filename[MAXFILES][12];

/* Some function prototypes */
int domatch(struct file_match *match);
int parse_line(char *line);
char *token_value(char *searched,char *defvalue);
int find_filenames(char *dirfile,FILE *files,int skiplines);
char *string(char *buffer,char *format,...);

main(argc,argv)
int argc;
char *argv[];	{
	int i,j;
	unsigned int ln=1;
	FILE *dirs,*files;
	char *p,*q,line[BUFSIZ];

        fprintf(stderr,"%s 1.2 "__DATE__
		" by Otto J. Makela (BBS V.32bis/HST +358 41 211 562)\n"
		"Distributed under the GNU General Public Licence: "
		"see file COPYING for details\n",*argv="chkfiles");

	init_match();

	/* Go thru arguments */
	for(i=1; i<argc; i++)
		if(*argv[i]==switchar) 	{
			while(j=*++argv[i])
				switch(isupper(j)?tolower(j):j)	{
					case 'd': scandeny=!scandeny;	break;
					case 'h': scanhide=!scanhide;	break;
					case 'r': scanrom=!scanrom;	break;
					case '1':
						scandeny=1;
						scanhide=1;
						scanrom=1;
						break;
					case 'f': skipfile=!skipfile;	break;
					default:
		printf("Unrecognized command line switch '%c', ",j);
					case '?':
					printf("Valid switches are:\n"
		"\t%cd\ttoggle /deny directory scan [%s]\n"
		"\t%ch\ttoggle /hide directory scan [%s]\n"
		"\t%cr\ttoggle /rom  directory scan [%s]\n"
		"\t%c1\tset all the above on\n"
		"\t%cf\ttoggle /info file description requirement [%s]\n"
		"\t%c?\tshow this info screen with current settings\n",
		switchar,scandeny?"on":"off",
		switchar,scanhide?"on":"off",
		switchar,scanrom? "on":"off",
		switchar,
		switchar,skipfile?"on":"off",
		switchar);
					goto next;
				}
next:			continue;
		} else	{
			if(dirfile)
				printf("Warning: dirs file \"%s\" overrides "
					"\"%s\"\n",argv[i],dirfile);
			dirfile=argv[i];
		}

	if(!dirfile) dirfile=DIRFILE;
	if(!(dirs=fopen(dirfile,"r")))	{
		printf("%s: cannot open\n",dirfile);
		errors++;
		goto exit;
	}

	for(; fgets(line,sizeof(line),dirs); ln++)	{
		/* Parse the line we got, skip probable comments */
		if(!parse_line(line)) continue;

		/* A line without a /dir ? */
		if(!(p=token_value("dir",NULL)))	{
			printf("%s(%u): line does not contain /dir token\n",
				dirfile,ln);
			errors++;
			continue;
		}

		/* Skip ones we don't want this time */
		if(!scandeny && (token_set("deny")!=-1)) continue;
		if(!scanhide && (token_set("hide")!=-1)) continue;
		if(!scanrom  && (token_set("rom" )!=-1)) continue;

		founddirs++;
		if(strchr(q=token_value("info","@files"),dirsepar) ||
			strchr(q,othersepar))
				strcpy(thisfile,q);
			else
				string(thisfile,"%s/%s",p,q);

		if(!(files=fopen(thisfile,"r")))	{
			printf("%s(%u): cannot open index file \"%s\"\n",
				dirfile,ln,thisfile);
			errors++;
			continue;
		}
		find_filenames(thisfile,files,atoi(token_value("skip","0")));

		fclose(files);

		formatch(string(NULL,"%s/",p),READONLY|DIRECTORY,domatch);

		for(i=0; i<filenames; i++)
			if(*filename[i])
				errors++,
				printf("%s(%u): nonexistant file \"%.12s\"\n",
					thisfile,linenumber[i],filename[i]);
	}
	fclose(dirs);

exit:	fprintf(stderr,errors?
		"%u director%s, %u file%s: %u problem%s found\n":
		"%u director%s, %u file%s: no problemo!\n",
		founddirs,founddirs>1?"ies":"y",
		foundfiles,foundfiles>1?"s":"",
		errors,errors>1?"s":"");
	exit(0);
}


/*
**	Remove matched files from the filename[] array
*/
int domatch(struct file_match *match)	{
	register int i;

	foundfiles++;
	for(i=0; i<filenames; i++)
		if(!strncmp(match->shortname,filename[i],12))	{
			*filename[i]='\0';
			return 0;
		}

	/* Waffle hides '@' files, Unix '.' files */
	if(*match->shortname=='@' || *match->shortname=='.') return 0;
	/* Possibly skip the '@files' file itself */
	if(skipfile && !strcmp(match->filename,thisfile)) return 0;

	printf("%s: %s \"%s\" has no description\n",
		thisfile,match->attribute&DIRECTORY?"directory":"file",
		match->shortname);
	errors++;
	return 0;
}


#ifdef	PARSE
/*
**	Parse one line from dirs file into separate tokens and their values
*/
int parse_line(char *line)	{
	char c;
	int quoted=0;

	for(tokens=0; c=*line; line++)
		if(quoted)	{
			if(c=='"')	{
				*line='\0';
				quoted=0;
			}
		} else if(c=='/')	{
			value[tokens]=NULL;
			token[tokens++]=line+1;
		} else if(c=='=' && tokens)	{
			*line='\0';
			value[tokens-1]=line+1;
		} else if(c=='"')	{
			quoted=1;
			if(value[tokens-1]==line) value[tokens-1]++;
		} else if(c==';' || c=='#')	{
			*line='\0';
			break;
		} else if(isupper(c))
			*line=tolower(c);
		else if(isspace(c))
			*line='\0';
	return tokens;
}


/*
**	Return position of requested token in the token[] array, or -1 if none
*/
int token_set(char *searched)	{
	register int i;

	for(i=0; i<tokens; i++)
		if(!strcmp(searched,token[i]))
			return i;
	return -1;
}


/*
**	Return value of requested token, or defvalue if it has no value;
**	return NULL if the requested token does not exist
*/
char *token_value(char *searched,char *defvalue)	{
	register int i;

	if((i=token_set(searched))!=-1 && value[i])
		return value[i];
	else
		return defvalue;
}
#endif


/*
**	Search thru a @files format file and create a files listing
*/
char invalidchars[]="\"?*,;:+/<=>[\\]|";

int find_filenames(char *dirfile,FILE *files,int skiplines)	{
	int i;
	unsigned int ln=1;
	char *p,line[BUFSIZ],thename[BUFSIZ];

	for(i=0; i<skiplines; i++, ln++)
		fgets(line,sizeof(line),files);

	for(filenames=0; fgets(line,sizeof(line),files); ln++)	{
		if(isspace(*(p=line)))	{
			printf("%s(%u): %s\n",dirfile,ln,
				*p=='\n'?"empty line":"leading whitespace");
			errors++;
			continue;
		}
			
		if(!sscanf(line,"%s",thename)) continue;
		canon(thename);

		for(p=thename; *p; p++)
			if(strchr(invalidchars,*p))	{
warn:				printf("%s(%u): illegal character '%c'=0x%02x\n",
					dirfile,ln,*p,*p);
				errors++;
				goto next;
			}
		for(i=0; i<filenames; i++)
			if(!strncmp(thename,filename[i],12))	{
				printf("%s(%u,%u): duplicate filename \"%s\"\n",
					dirfile,linenumber[i],ln,thename);
				errors++;
				goto next;
			}
		linenumber[filenames]=ln;
		strncpy(filename[filenames++],thename,12);
next:		continue;
	}
}


/*
**	Create a string by the specified sprintf() rules
*/
char *string(char *buffer,char *format,...)	{
	static char ownbuffer[BUFSIZ];
	va_list arg_ptr;
	va_start(arg_ptr,format);

	if(!buffer) buffer=ownbuffer;
	vsprintf(buffer,format,arg_ptr);
	va_end(arg_ptr);
	return buffer;
}


/*
**	Canonicalize a given filename (under MeSsy-DOS only)
*/
canon(char *filename)	{
	register char c,last='a';
	int i=8;
	char *p=filename;

	for(; c=*filename++; last=c)
		if(c=='/' || c=='\\')	{
			if(last=='.')
				p[-1]='/';
			else if(last!='/')
				*p++='/';
			c='/';
			i=8;
		} else if(c=='.')	{
			*p++='.';
			i=3;
		} else if(i-->0)
			if(isupper(c))
				*p++=tolower(c);
			else
				*p++=c;
	*p='\0';
}
