/* cputzc.c  -  Drawing image in ZCompact format.
 *
 * CHAINED mode version. For mode 13h (MCGA), C4 on (CHAINED).
 * NOTE that in this mode BPERROW is a permanent constant, and always equal to
 * BPERROW_CHAINED.
 *
 * Uses following coding method:
 *
 * Line    ends by a 0, 0 (color code = 0, counter = 0)
 * Picture ends by rows counter.
 *
 *     +7-------------------6+5----------------------0+
 *     | counter (1 till 3)  |  color code (0 - 63)   |
 *     +---------------------+------------------------+
 * or
 *     +7-6+5------------0+    +7---------------------0+
 *     | 0 | color code   |    |  counter              |
 *     +---+--------------+    +-----------------------+
 *
 * Functions:
 *      CputZCompact().
 * See Also: uputc.c
 * Portability: BORLANDC
 *                                      (c) erdy 1992
 * $Header: $
 */
#pragma inline
#include "far.h"
#include "vgaprefx.h"
#include "vgadrv.h"
#include "screen.h"

#ifdef ZC_PREPARED
        void CputZCompact(char far *image, int mask, int offset, int rows)
#else
        void CputZCompact(char far *image, int x, int y, int rows)
#endif ZC_PREPARED
{
	_CX = rows;
        _ES = Scdraw_seg;

#       ifdef ZC_PREPARED
		asm mov di, offset;
		asm mov ax, mask;
#       else  ZC_PREPARED
		asm mov ax, y;          /* Get argument */
                asm mov dx, BPERROW_CHAINED;
		asm mul dx;

		asm mov di, x;          /* Get argument */
		asm add di, ax;
#       endif ZC_PREPARED

	asm push ds;
	asm lds si, image;
	asm cld;
        asm push bp;
	/*
	 * Scanline loop. CX contains nrows.
	 */
Loop:
                asm mov dx, cx;                    /* Loop counter */
		asm mov bp, di;                    /* Save DI */

		for (;;) {
			asm lodsb;              /* al <- ds:[si++]; get next byte */
			asm mov bl, al;         /* Save color code */

			asm rol al, 1;          /* Get counter */
                        asm rol al, 1;          /* = shr al, 6 */
                        asm and ax, 3;          /* ah = 0, al &= 3 */
			asm jne short OKCounter;
				asm lodsb;      /* Long counter */
				if (_AL == 0) { /* End of this scanline */
#if 0
					if (_BL == 0)   /* Next scan line */
						break;

					asm mov ax, ds;
					if (_BL == 1) { /* Next colormap */
                                                asm add ax, 4; /* Shift to next colormap */
                                                asm sub si, 0x40; /* Shift to 4 paragraphs size */
					}
					if (_BL == 2) { /* Previous colormap */
                                                asm sub ax, 4; /* Shift to next colormap */
                                                asm add si, 0x40; /* Shift to 4 paragraphs size */
					}
					asm mov ds, ax;
#endif
					break;
				}
OKCounter:
			if (_BL == 0) {         /* Zero color code -> skipping */
				asm add di, ax; /* Advance the index */
				continue;
			}
			asm mov cx, ax;         /* Save length */
			/*
			 * Color map table must reside at segment:0.
			 */
                        asm and bx, 0x3F;               /* Mask off color code */
                        asm mov al, [bx];   /* Map color code */
/*asm mov al, bl; /* */
			asm rep stosb;               /* Write colors */
			continue;
		}
                asm mov di, bp;
                asm add di, BPERROW_CHAINED;
                asm mov cx, dx;
        asm loop Loop;

        asm pop bp;
	asm pop ds;
	return;
}