uses
   Dos;

   procedure refresh; external {$L refresh.obj};

const
   TABLE_SIZE     = $40;                { constants and offsets of some }
   CODE_SIZE      = 0;                  { code and data derived from }
   VIDEO          = 4;                  { refresh.asm file }
   VIDEO_ALT      = 8;
   NEW_VIDEO      = $C;
   NEW_VIDEO_ALT  = $10;
   MODES_TABLE    = $14;
   CODES_TABLE    = $14 + 2*TABLE_SIZE;

   function vesa_info(var vesa_buffer): word; assembler;
   asm
        les     di,vesa_buffer
        mov     ax,4F00h
        int     10h
   end;
   function vesa_mode_info(var vesa_buffer; id: word): word; assembler;
   asm
        les     di,vesa_buffer
        mov     cx,id
        mov     ax,4F01h
        int     10h
   end;
   function installation_check: word; assembler;
   asm
        mov     ax,30CFh                { this is the check wether this }
        mov     bx,ax                   { program is installed or not }
        int     10h
        xor     cx,cx
        cmp     ax,0CF30h
        jne     @@1
        cmp     bx,0CF30h
        jne     @@1
        mov     cx,dx
   @@1: xchg    ax,cx
   end;
   function allocate_umb(size: word): word; assembler;
   asm
        mov     es,PrefixSeg            { release environment block - }
        mov     es,es:[2Ch]             { if there's no upper memory the }
        mov     ah,49h                  { TSR part may be small enough }
        int     21h                     { to fit into the created hole }
        mov     ax,5800h
        int     21h                     { save allocation strategy into si }
        xchg    ax,si
        jc      @@2
        mov     ax,5802h                { save umb link state into di }
        int     21h
        xchg    ax,di
        jc      @@2
        mov     bx,81h                  { change allocation strategy: }
        mov     ax,5801h                { try high then low }
        int     21h
        jc      @@2
        mov     bx,1                    { link umb chain if not linked }
        mov     ax,5803h
        int     21h
        mov     bx,size                 { allocate memory block }
        mov     ah,48h
        int     21h
        jnc     @@1
        xor     ax,ax
   @@1: push    ax
        mov     bx,si                   { restore allocation strategy }
        mov     ax,5801h
        int     21h
        mov     bx,di                   { restore umb link state }
        mov     ax,5803h                
        int     21h
        pop     ax
        jmp     @@3
   @@2: xor     ax,ax
   @@3:                                 { ax = segment of newly allocated }
   end;                                 { block, or 0 in case of error }

   function read_value(var line: string): word;
   var
      value, error: word;
      s: string;
   begin
      while (line <> '') and (line[1] = ' ') do
         delete(line, 1, 1);
      s := '';
      while (line <> '') and (line[1] in ['$', '0'..'9']) do begin
         s := s + line[1];
         delete(line, 1, 1)
      end;
      Val(s, value, error);
      if error <> 0 then
         value := $FFFF;
      while (line <> '') and (line[1] = ' ') do
         delete(line, 1, 1);
      read_value := value
   end;

   procedure ini_error(line_number: longint; message: string);
   begin
      WriteLn('error in .ini file (', line_number, ') - ', message);
      halt
   end;

type
   word_array = array[0..$7F] of word;
   byte_array = array[0..$7F] of byte;

const
   translation: array[0..$26] of byte = (
      $00,$01,$26,$25,$0B,$23,$06,$02,  { this is the translation table }
      $1D,$24,$07,$15,$04,$17,$1E,$16,  { which converts the sorted }
      $0D,$20,$03,$0E,$1F,$05,$18,$0A,  { refresh codes to unsorted codes }
      $21,$0F,$10,$22,$19,$0C,$09,$08,  { understood by BIOS - refer to }
      $11,$12,$1A,$13,$1B,$14,$1C );    { refresh.txt for more info }

var
   horizontal, vertical: word_array;    { data derived from refresh.ini }
   refresh_codes, bits: byte_array;     { data derived from refresh.ini }
   modes: word_array;                   { modes_table in refresh.asm }
   codes: byte_array;                   { codes_table in refresh.asm }

   vesa_buffer: word_array;             { VESA communication buffer }

var
   t: text;
   line: string;
   line_number: longint;
   i, j: word;
   install, uninstall: boolean;

begin
   WriteLn('REFRESH v1.0');

   line := ParamStr(1);
   line[2] := upcase(line[2]);
   install := (ParamCount = 1) and (line = '/I');
   uninstall := (ParamCount = 1) and (line = '/U');

   FillChar(modes, sizeOf(modes), $FF);
   FillChar(codes, sizeOf(codes), $FF);
   FillChar(horizontal, sizeOf(horizontal), $FF);
   FillChar(vertical, sizeOf(vertical), $FF);
   FillChar(refresh_codes, sizeOf(refresh_codes), $FF);
   FillChar(bits, sizeOf(refresh_codes), $FF);

   if vesa_info(vesa_buffer) <> $4F then begin
      WriteLn('VESA BIOS extention not available');
      halt
   end;
   for i := 0 to TABLE_SIZE-2 do begin
      modes[i] := word_array(ptr(vesa_buffer[8], vesa_buffer[7])^)[i];
      if modes[i] = $FFFF then break
   end;

   line := ParamStr(0);
   while (line <> '') and (line[Length(line)] <> '\') do
      dec(line[0]);
   FileMode := 0;
   Assign(t, line + 'refresh.ini');
   Reset(t);
   if IOResult <> 0 then begin
      WriteLn('.ini file not found: ', line, 'refresh.ini');
      halt
   end;
   line_number := 0;
   i := 0;
   while not Eof(t) do begin
      ReadLn(t, line);
      inc(line_number);
      while (line <> '') and (line[1] = ' ') do
         delete(line, 1, 1);
      if line = '' then continue;
      if line[1] = ';' then continue;
      if line[1] = '/' then begin
         while line[Length(line)] = ' ' do
            dec(line[0]);
         line[2] := upcase(line[2]);
         if (ParamCount = 0) then begin
            install := (line = '/I');
            uninstall := (line = '/U')
         end;
         continue
      end;
      horizontal[i] := read_value(line);
      if horizontal[i] = $FFFF then
         ini_error(line_number, 'wrong horizontal resolution');
      if (line = '') or (line[1] <> 'x') then
         ini_error(line_number, '"x" expected');
      Delete(line, 1, 1);
      vertical[i] := read_value(line);
      if vertical[i] = $FFFF then
         ini_error(line_number, 'wrong vertical resolution');
      if (line <> '') and (line[1] = 'x') then begin
         Delete(line, 1, 1);
         j := read_value(line);
         if j > $20 then
            ini_error(line_number, 'wrong bits per pixel value');
         bits[i] := j
      end;
      if (line = '') or (line[1] <> '=') then
         ini_error(line_number, '"=" expected');
      Delete(line, 1, 1);
      j := read_value(line);
      if j > $26 then
         ini_error(line_number, 'wrong refresh code');
      refresh_codes[i] := translation[j];
      if line <> '' then
         ini_error(line_number, 'end of line expected');
      inc(i)
   end;
   for i := 0 to TABLE_SIZE-1 do begin
      if modes[i] = $FFFF then break;
      if vesa_mode_info(vesa_buffer, modes[i]) <> $4F then continue;
      if vesa_buffer[0] and $13 <> $13 then continue;
      for j := 0 to $7F do
         if (horizontal[j] = vesa_buffer[9]) and
            (vertical[j] = vesa_buffer[$A]) and
            ((bits[j] = $FF) or (bits[j] = vesa_buffer[$C] shr 8)) then begin
            codes[i] := refresh_codes[j];
            break
         end
   end;

   if not install and not uninstall then begin
      WriteLn('Changing standard screen refresh rates -');
      WriteLn('for SVGA cards with an Alliance Semiconductor AT3D chipset');
      WriteLn;
      WriteLn('usage:');
      WriteLn('refresh <switches>');
      WriteLn('   /i      install or re-install');
      WriteLn('   /u      uninstall');
      halt
   end;
   i := installation_check;
   if i <> 0 then begin
      if install then begin
         move(modes, ptr(i, MODES_TABLE)^, 2*TABLE_SIZE);
         move(codes, ptr(i, CODES_TABLE)^, TABLE_SIZE);
         WriteLn('refresh re-installed successfuly');
         halt
      end;
      GetIntVec($10, pointer(line_number));
      if i <> (line_number shr 16) then
         i := 0;
      GetIntVec($6D, pointer(line_number));
      if i <> (line_number shr 16) then
         i := 0;
      if i = 0 then begin
         WriteLn('interrupts revectored - can''t uninstall');
         halt
      end;
      SetIntVec($10, pointer(ptr(i, VIDEO)^));
      SetIntVec($6D, pointer(ptr(i, VIDEO_ALT)^));
      word(ptr(i-1, 1)^) := 0;          { segment is now free }
      WriteLn('program removed from memory');
      halt
   end;
   if uninstall then begin
      WriteLn('refresh was not installed');
      halt
   end;
   if PrefixSeg > $A000 then begin
      WriteLn('do not load high - refresh does it by itself');
      halt
   end;
   j := word(ptr(seg(refresh), ofs(refresh) + CODE_SIZE)^);
   i := allocate_umb((j + 15) div 16);
   if i = 0 then begin
      WriteLn('not enough upper memory');
      halt
   end;
   move(ptr(seg(refresh), ofs(refresh))^, ptr(i, 0)^, j);
   move(modes, ptr(i, MODES_TABLE)^, 2*TABLE_SIZE);
   move(codes, ptr(i, CODES_TABLE)^, TABLE_SIZE);
   GetIntVec($10, pointer(ptr(i, VIDEO)^));
   GetIntVec($6D, pointer(ptr(i, VIDEO_ALT)^));
   word(ptr(i-1, 1)^) := 8;             { segment owned by DOS }
   SetIntVec($10, ptr(i, NEW_VIDEO));
   SetIntVec($6D, ptr(i, NEW_VIDEO_ALT));
   WriteLn('refresh installed successfuly')

end.
